/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.handler.AsyncHandler;
import com.kony.adapter.model.BinaryField;
import com.konylabs.middleware.common.BinaryOperandAttributes;
import com.konylabs.middleware.connectors.dataadapter.AbstractOperand;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterAsyncHandler;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterData;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataobject.Result;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

abstract class BinaryOperand
extends AbstractOperand<BinaryField> {
    BinaryOperand() {
    }

    @Override
    protected void preExecuteStep(Result result, AsyncHandler<Result> asyncHandler) throws DataAdapterException {
        this.dataAdapterAsyncHandler = new DataAdapterAsyncHandler<BinaryField>(this, asyncHandler);
        this.populateInputMapWithBinaryAttributes();
        this.preparedResult = this.prepareBinaryField();
    }

    @Override
    protected void processResults(BinaryField dataAdapterResult) throws DataAdapterException {
        if (dataAdapterResult != null) {
            Map attributes = dataAdapterResult.getAttributes();
            Set keySet = attributes.keySet();
            for (String key : keySet) {
                Object object = attributes.get(key);
                this.setResultParamString(key, String.valueOf(object));
            }
        }
    }

    private void populateInputMapWithBinaryAttributes() {
        DataAdapterData dataAdapterdata = this.getDataAdapterData();
        Map<String, Object> inputMap = dataAdapterdata.getInputMap();
        DataControllerRequest request = dataAdapterdata.getDataControllerRequest();
        if (request.containsKeyInRequestContext("queryparams")) {
            inputMap.putAll((Map)request.getAttribute("queryparams"));
        }
        for (BinaryOperandAttributes binAttribute : BinaryOperandAttributes.values()) {
            if (!StringUtils.isNotBlank((String)request.getParameter(binAttribute.name()))) continue;
            inputMap.put(binAttribute.name(), request.getParameter(binAttribute.name()));
        }
    }
}

