/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.AdapterPropertyType;
import com.kony.adapter.DataAdapterFactory;
import com.kony.adapter.annotations.binary.BinaryData;
import com.kony.adapter.criteria.BatchContext;
import com.kony.adapter.criteria.Criteria;
import com.kony.adapter.event.DataAdapterEvent;
import com.kony.adapter.event.DataAdapterEventNotifier;
import com.kony.adapter.event.DataAdapterEventObserver;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.handler.AsyncHandler;
import com.kony.adapter.metadata.model.EntityMetadata;
import com.kony.adapter.metadata.model.FieldType;
import com.kony.adapter.metadata.model.Metadata;
import com.kony.adapter.model.Context;
import com.kony.adapter.model.Entity;
import com.kony.adapter.service.meta.ServiceMetadata;
import com.kony.adapter.service.runtime.ServiceData;
import com.kony.mapper.exception.MapperException;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.common.BinaryOperandAttributes;
import com.konylabs.middleware.connectors.AsyncConnector;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.ConnectorResponseAsyncHandler;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterData;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterInputHandler;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterOutputHandler;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterUtil;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.connectors.postprocessor.PostProcessUtils;
import com.konylabs.middleware.connectors.preprocessor.PreProcessUtils;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerRequestFactory;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.mbaas.MiddlewareMBaasUtils;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.monitoring.MonitoringProperties;
import com.konylabs.middleware.monitoring.MonitoringUtils;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.services.AbstractServiceDelegate;
import com.konylabs.middleware.throttle.ThrottleUtil;
import com.konylabs.middleware.utilities.MapperUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataAdapterAsyncConnector
implements AsyncConnector,
DataAdapterEventNotifier {
    private static final Logger LOGGER = Logger.getLogger(DataAdapterAsyncConnector.class);
    private List<DataAdapterEventObserver> observers;
    private AbstractServiceDelegate serviceDelegate;
    private static final ConnectorResponseAsyncHandler connectorResponseAsyncHandler = new ConnectorResponseAsyncHandler();

    @Override
    public void setServiceDelegate(AbstractServiceDelegate serviceDelegate) {
        this.serviceDelegate = serviceDelegate;
    }

    @Override
    public void executeAsync(final com.konylabs.middleware.registry.impl.ServiceMetadata serviceMetadata, final DataControllerRequest request, final DataControllerResponse response, Context parentContext, final Map<String, Object> config) {
        HashMap<String, Object> inputParamMap = null;
        Context context = new Context();
        context.put("parentContext", (Object)parentContext);
        context.put("config", config);
        context.put("serviceMetadata", (Object)serviceMetadata);
        context.put("request", (Object)request);
        context.put("response", (Object)response);
        context.put("connector", (Object)this);
        String claimsToken = request.getHeader("X-Kony-Authorization");
        String puid = DataAdapterUtil.getPuidFromClaimsToken(claimsToken);
        if (StringUtils.isNotBlank((String)puid)) {
            context.put("KONY_SERVER_FILE_SERVICE_PUID", (Object)puid);
        }
        AsyncHandler asyncHandler = (AsyncHandler)parentContext.get("handler");
        context.put("asyncHandler", (Object)asyncHandler);
        try {
            ThrottleUtil.checkThrottled(serviceMetadata, request);
            inputParamMap = ConnectorUtils.getInputParam(new DataAdapterInputHandler(), serviceMetadata.getService(), request, config);
        }
        catch (ConnectorException e) {
            LOGGER.error((Object)"ConnectorInitializationException while executing the data adapter async connector", (Throwable)e);
            DataAdapterException ex = new DataAdapterException(e.getErrorCode(), e.getMessage(), (Throwable)e, e.getHttpStatusCode());
            connectorResponseAsyncHandler.onError(ex, context);
            return;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Generic Exception occurred while executing the data adapter async connector", (Throwable)ex);
            DataAdapterException daex = this.prepareGenericDataAdapterException(ex);
            connectorResponseAsyncHandler.onError(daex, context);
            return;
        }
        final DataAdapterInputHandler wsinput = new DataAdapterInputHandler();
        String adapterType = (String)config.get("adaptertype");
        if (DataAdapterFactory.DataAdapterType.KONY_INTEGRATION_SERVICE.toString().equals(adapterType)) {
            try (MWMetricsTimer orchServiceBackendRequestTimer = new MWMetricsTimer(request, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis");){
                this.executeSDO(serviceMetadata.getService(), request, response, config, context, connectorResponseAsyncHandler, wsinput);
            }
            return;
        }
        boolean isCachable = serviceMetadata.getService().isCachable();
        Object resultFromCache = null;
        if (isCachable && (resultFromCache = ConnectorUtils.getResultFromCache(request, serviceMetadata, inputParamMap, response)) != null) {
            Result result = (Result)resultFromCache;
            asyncHandler.onSuccess((Object)result, context);
            return;
        }
        Result result = new Result();
        context.put("X-Kony-RequestId", (Object)request.getHeader("X-Kony-RequestId"));
        try {
            final DataAdapterData adapterData = new DataAdapterData(context, config, serviceMetadata, this);
            adapterData.setDataControllerRequest(request);
            adapterData.setDataControllerResponse(response);
            this.constructMetadata(adapterData, config, serviceMetadata.getService(), request);
            String adapterName = (String)adapterData.getDataAdapter().getAdapterProperties().get(AdapterPropertyType.name);
            MetricsUtils.addParamToMetricsBean(request, "contype", adapterName);
            HashMap<String, Object> inputMap = null;
            long requestMapperEntityProcessingTime = 0L;
            long requestMapperCriteriaProcessingTime = 0L;
            AppVersion appVersion = serviceMetadata.getAppMetadata().getApplicationVersion();
            boolean excuteService = PreProcessUtils.execute(serviceMetadata.getService(), config, inputParamMap, request, response, result, appVersion);
            if (MapperUtility.isMapperInServiceInput(serviceMetadata.getService()) && !MiddlewareUtils.isBinaryOperand(config)) {
                inputMap = new HashMap();
                wsinput.populateTemplateParams(request, serviceMetadata.getService(), inputMap);
                String odataString = wsinput.getOdataString(request, inputMap, config, serviceMetadata.getService());
                Criteria criteria = adapterData.prepareCriteria(odataString);
                request.setAttribute("criteria", (Object)criteria);
                requestMapperEntityProcessingTime = System.currentTimeMillis();
                this.prepareEntityOrServiceData(serviceMetadata.getService(), request, adapterData);
                requestMapperEntityProcessingTime = System.currentTimeMillis() - requestMapperEntityProcessingTime;
            } else {
                inputMap = inputParamMap;
            }
            final HashMap<String, Object> inputMapFinal = inputMap;
            final long requestMapperEntityProcessingTimeFinal = requestMapperEntityProcessingTime;
            if (serviceMetadata.getService().getServiceInput().isPassthrough()) {
                for (Param param : serviceMetadata.getService().getServiceInput().getParams()) {
                    if (!StringUtils.equalsIgnoreCase((String)FieldType.BINARY.name(), (String)param.getDataType())) continue;
                    inputMap.put(param.getName(), request.getAttribute("binaryKey"));
                }
            }
            adapterData.setInputMap(inputMapFinal);
            Map<String, String> headerMap = wsinput.getHeaders(request, config, serviceMetadata.getService());
            MiddlewareMBaasUtils.populateIdentityHeaders(request, headerMap);
            adapterData.setHeaderMap(headerMap);
            if (excuteService) {
                adapterData.getInitializationOperand().execute(adapterData, result, new AsyncHandler<Result>(){

                    public void onError(DataAdapterException ex, Context ctx) {
                        connectorResponseAsyncHandler.onError(ex, ctx);
                    }

                    public void onSuccess(Result result, Context ctx) {
                        try {
                            DataAdapterAsyncConnector.this.executeService(serviceMetadata, request, response, (AsyncHandler<Result>)connectorResponseAsyncHandler, wsinput, inputMapFinal, config, adapterData, requestMapperEntityProcessingTimeFinal, 0L);
                        }
                        catch (DataAdapterException e) {
                            connectorResponseAsyncHandler.onError(e, ctx);
                            return;
                        }
                    }
                });
            } else {
                connectorResponseAsyncHandler.onSuccess(result, context);
            }
        }
        catch (DataAdapterConnectorException e) {
            LOGGER.error((Object)"DataAdapterConnectorException while executing the data adapter async connector", (Throwable)((Object)e));
            DataAdapterException ex = new DataAdapterException(e.getErrorCode(), e.getMessage(), (Throwable)((Object)e), e.getHttpStatusCode());
            asyncHandler.onError(ex, parentContext);
            return;
        }
        catch (MapperException e) {
            LOGGER.error((Object)"Processing error in mapper", (Throwable)e);
            asyncHandler.onError(this.prepareDataAdapterException(e), parentContext);
            return;
        }
        catch (ConnectorException e) {
            LOGGER.error((Object)"ConnectorException while executing the data adapter async connector", (Throwable)e);
            DataAdapterException ex = new DataAdapterException(e.getErrorCode(), e.getMessage(), (Throwable)e, e.getHttpStatusCode());
            asyncHandler.onError(ex, parentContext);
            return;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Generic Exception has occoured while executing the data adapter async connector", (Throwable)ex);
            DataAdapterException daex = this.prepareGenericDataAdapterException(ex);
            asyncHandler.onError(daex, parentContext);
            return;
        }
    }

    public void notify(DataAdapterEvent event) {
        if (this.observers != null) {
            for (DataAdapterEventObserver observer : this.observers) {
                try {
                    observer.onEvent(event);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception thrown by observer in notify", (Throwable)e);
                }
            }
        }
    }

    public void register(DataAdapterEventObserver observer) {
        if (this.observers == null) {
            this.observers = new CopyOnWriteArrayList<DataAdapterEventObserver>();
        }
        this.observers.add(observer);
    }

    public void unregister(DataAdapterEventObserver observer) {
        if (this.observers != null) {
            this.observers.remove(observer);
        }
    }

    protected DataAdapterException prepareDataAdapterException(MapperException e) {
        return new DataAdapterException(e.getErrorCode() == null ? DataAdapterConnectorException.ERROR_MAPPER_UTILITY : e.getErrorCode(), e.getMessage());
    }

    protected DataAdapterException prepareGenericDataAdapterException(Exception ex) {
        return new DataAdapterException(ex.getMessage(), (Throwable)ex);
    }

    void processResponse(com.konylabs.middleware.registry.impl.ServiceMetadata serviceMetadata, DataControllerRequest request, DataControllerResponse response, Context context, Result finalResult, Map<String, Object> configMap, AsyncHandler<Result> asyncHandler) {
        Context parentContext = (Context)context.get("parentContext");
        try {
            BatchContext batchContext;
            Object obj = context.get("httpStatusCode");
            if (obj != null) {
                response.setStatusCode(Integer.parseInt(obj.toString()));
            }
            new DataAdapterOutputHandler().processOutput(serviceMetadata.getService(), request, response, finalResult);
            finalResult = this.applyMapperOnResponse(serviceMetadata.getService(), request, finalResult);
            if (finalResult != null) {
                AppVersion appVersion = serviceMetadata.getAppMetadata().getApplicationVersion();
                finalResult = PostProcessUtils.execute(serviceMetadata.getService(), configMap, finalResult, request, response, appVersion);
            }
            if ((batchContext = context.getBatchContext()) != null && batchContext.getBatchType() == BatchContext.BATCHTYPE.BUFFER_BASED) {
                String batchPointer = batchContext.getBatchPointer();
                boolean hasMoreBatch = batchContext.hasMoreBatch();
                if (StringUtils.isNotBlank((String)batchPointer)) {
                    finalResult.addParam(new com.konylabs.middleware.dataobject.Param("nextBatchId", batchPointer));
                    finalResult.addParam(new com.konylabs.middleware.dataobject.Param("hasMoreRecords", String.valueOf(hasMoreBatch)));
                }
            }
            asyncHandler.onSuccess((Object)finalResult, parentContext);
        }
        catch (ConnectorException e) {
            DataAdapterException ex = new DataAdapterException(e.getErrorCode(), e.getMessage(), e.getHttpStatusCode());
            asyncHandler.onError(ex, parentContext);
            return;
        }
        catch (MapperException e) {
            asyncHandler.onError(this.prepareDataAdapterException(e), parentContext);
            return;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unknown exception while processing response", (Throwable)e);
            String errorMessage = StringUtils.isNotBlank((String)e.getMessage()) ? e.getMessage() : e.toString();
            asyncHandler.onError(new DataAdapterException("14057", errorMessage, 500), parentContext);
            return;
        }
    }

    protected void constructMetadata(DataAdapterData adapterData, Map<String, Object> config, Service service, DataControllerRequest request) throws DataAdapterConnectorException, ConnectorException {
        try {
            Metadata metadata = adapterData.getDataAdapter().getMetaDataExplorer().getMetadataFormatter().fromJSON(adapterData.getEntityMetadataString());
            adapterData.setMetadata(metadata);
        }
        catch (DataAdapterException e) {
            LOGGER.error((Object)"Unable to perform operation", (Throwable)e);
            throw new DataAdapterConnectorException(DataAdapterConnectorException.DATAADAPTER_EXCEPTION, e.getErrorMessage(), e.getHttpStatusCode());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to perform operation, exception occurred", (Throwable)e);
            throw new DataAdapterConnectorException(DataAdapterConnectorException.DATAADAPTER_EXCEPTION, e.getMessage(), 500);
        }
    }

    private Result applyMapperOnResponse(Service service, DataControllerRequest request, Result result) throws MapperException {
        try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.RESPONSE_MAPPER, "respmapdur");){
            Result result2 = MapperUtility.applyMapperOnResult(request, service, result, this);
            return result2;
        }
    }

    private void executeService(com.konylabs.middleware.registry.impl.ServiceMetadata serviceMetadata, DataControllerRequest request, DataControllerResponse response, AsyncHandler<Result> asyncHandler, DataAdapterInputHandler wsinput, Map<String, Object> inputMap, Map<String, Object> config, DataAdapterData adapterData, long requestMapperEntityProcessingTime, long requestMapperCriteriaProcessingTime) throws DataAdapterException {
        Result result = new Result();
        Service service = serviceMetadata.getService();
        try {
            Criteria criteria;
            String odataString = wsinput.getOdataString(request, inputMap, config, serviceMetadata.getService());
            Criteria finalCriteria = criteria = adapterData.prepareCriteria(odataString);
            ConfigParam opCode = serviceMetadata.getService().getServiceConfig().getConfigParam("opcode");
            boolean applyMapperOnCriteria = opCode != null && opCode.getValue().equals("query");
            Map<String, String> fieldMap = serviceMetadata.getFieldsMap();
            if (applyMapperOnCriteria && fieldMap != null && !fieldMap.isEmpty()) {
                requestMapperCriteriaProcessingTime = System.currentTimeMillis();
                finalCriteria = MapperUtility.applyMapperOnCriteria(serviceMetadata.getService(), criteria, fieldMap);
                requestMapperCriteriaProcessingTime = System.currentTimeMillis() - requestMapperCriteriaProcessingTime;
            }
            MWMetricsTimer.manualUpdate(request, FabricTimerCategory.REQUEST_MAPPER, "reqmapdur", requestMapperEntityProcessingTime + requestMapperCriteriaProcessingTime);
            adapterData.setCriteria(finalCriteria);
            adapterData.getAdapterOperand().execute(adapterData, result, asyncHandler);
            if (MiddlewareUtils.isResponsePassThrough(serviceMetadata.getService())) {
                this.handleBinaryResponse(result, response);
            }
        }
        catch (ConnectorException e) {
            LOGGER.error((Object)"ConnectorException while executing the data adapter async connector", (Throwable)e);
            DataAdapterException ex = new DataAdapterException(e.getErrorCode(), e.getMessage(), (Throwable)e, e.getHttpStatusCode());
            throw ex;
        }
        catch (DataAdapterConnectorException e) {
            LOGGER.error((Object)"Error while executing the data adapter async connector", (Throwable)((Object)e));
            DataAdapterException ex = new DataAdapterException(e.getErrorCode(), e.getMessage(), (Throwable)((Object)e), e.getHttpStatusCode());
            throw ex;
        }
        boolean isCachable = serviceMetadata.getService().isCachable();
        if (result != null && isCachable) {
            int cacheduration = service == null || service.getCacheduration().length() == 0 ? -1 : Integer.parseInt(service.getCacheduration());
            ConnectorUtils.insertResultsIntoCache(request, serviceMetadata, inputMap, result, cacheduration);
        }
    }

    protected void handleBinaryResponse(Result result, DataControllerResponse response) {
        com.konylabs.middleware.dataobject.Param binaryDataParam;
        String opstatus = result.getParamByName("opstatus").getValue();
        if (StringUtils.isNotBlank((String)opstatus) && Integer.parseInt(opstatus) == 0 && (binaryDataParam = result.getParamByName("binaryKey")) != null) {
            BinaryData bData = (BinaryData)binaryDataParam.getObjectValue();
            response.setAttribute("chunkedresults_json", (Object)bData.getInputStream());
            response.setAttribute(BinaryOperandAttributes.fieldName.name(), (Object)bData.getName());
            response.setAttribute(BinaryOperandAttributes.fileName.name(), (Object)bData.getOriginalFileName());
        }
    }

    protected void prepareEntityOrServiceData(Service service, DataControllerRequest request, DataAdapterData adapterData) throws MapperException {
        if (adapterData.getMetadata() instanceof EntityMetadata) {
            this.prepareEntity(service, request, adapterData);
        } else if (adapterData.getMetadata() instanceof ServiceMetadata) {
            this.prepareServiceData(service, request, adapterData);
        }
    }

    private void prepareEntity(Service service, DataControllerRequest request, DataAdapterData adapterData) throws MapperException {
        Entity entity = MapperUtility.prepareEntity(service, request, adapterData.getDataAdapter(), (EntityMetadata)adapterData.getMetadata(), this);
        adapterData.setEntity(entity);
    }

    private void prepareServiceData(Service service, DataControllerRequest request, DataAdapterData adapterData) throws MapperException {
        ServiceData serviceData = MapperUtility.prepareServiceData(service, request, this);
        adapterData.setServiceData(serviceData);
    }

    /*
     * Exception decompiling
     */
    private void executeSDO(Service service, DataControllerRequest request, DataControllerResponse response, Map<String, Object> config, Context context, AsyncHandler<Result> handler, DataAdapterInputHandler wsinput) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Connector registerEventObserversForIntegrationServiceInSdo(Service inProcService) throws ProcessorException {
        Connector inProcConnector = this.serviceDelegate.getConnector(inProcService.getServiceType());
        if (this.observers != null && inProcConnector instanceof DataAdapterEventNotifier) {
            for (DataAdapterEventObserver observer : this.observers) {
                ((DataAdapterEventNotifier)inProcConnector).register(observer);
            }
        }
        return inProcConnector;
    }

    private void unregisterEventObserversForIntegrationServiceInSdo(Connector inProcConnector) {
        if (this.observers != null && inProcConnector instanceof DataAdapterEventNotifier) {
            for (DataAdapterEventObserver observer : this.observers) {
                ((DataAdapterEventNotifier)inProcConnector).unregister(observer);
            }
        }
    }

    private Map<String, String> populateAdditionalTimerInfo(Service service, String inlineAppId, String inlineAPIVersion, String inlineServiceId, String parentServiceName, ApplicationMetadata appMetadata) {
        HashMap<String, String> additionalTimerInfo = new HashMap<String, String>();
        additionalTimerInfo.put(MonitoringProperties.SERVICE_NAME.getName(), inlineAppId);
        additionalTimerInfo.put(MonitoringProperties.OPERATION_NAME.getName(), inlineServiceId);
        additionalTimerInfo.put(MonitoringProperties.SERVICE_VERSION.getName(), inlineAPIVersion);
        additionalTimerInfo.put(MonitoringProperties.SERVICE_TYPE.getName(), service.getServiceType());
        additionalTimerInfo.put(MonitoringProperties.VERB.getName(), appMetadata.getServiceMetadata(inlineServiceId).getSupportedMethods());
        additionalTimerInfo.put(MonitoringProperties.PARENT_SERVICE_NAME.getName(), parentServiceName);
        if (MonitoringUtils.isOrchestrationService(service.getServiceType())) {
            additionalTimerInfo.put(MonitoringProperties.SERVICE_CATEGORY.getName(), "Orchestration");
        } else {
            additionalTimerInfo.put(MonitoringProperties.SERVICE_CATEGORY.getName(), "Integration");
        }
        return additionalTimerInfo;
    }

    private DataControllerRequest prepareMapDataControllerRequest(HashMap<String, Object> inputMap, DataControllerRequest originalDCR, String appId) {
        for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
            Object object = entry.getValue();
            String key = entry.getKey();
            if (object instanceof Dataset) {
                Dataset dataSet = (Dataset)object;
                inputMap.put(key, ResultToJSON.convertDataset((Dataset)dataSet).toString());
                continue;
            }
            if (!(object instanceof Record)) continue;
            Record record = (Record)object;
            inputMap.put(key, ResultToJSON.convertRecord((Record)record).toString());
        }
        DataControllerRequest mapdcr = DataControllerRequestFactory.newInstance(inputMap, originalDCR.getHeaderMap(), originalDCR.getRemoteAddr(), originalDCR.getCookies());
        mapdcr.setSession(originalDCR.getSession());
        mapdcr.addRequestParam_("appID", appId);
        mapdcr.addRequestParam_("serviceID", originalDCR.getParameter("serviceID"));
        mapdcr.addRequestParam_("channel", originalDCR.getParameter("channel"));
        mapdcr.addRequestParam_("objectID", originalDCR.getParameter("objectID"));
        Iterator attributes = originalDCR.getAttributeNames();
        while (attributes.hasNext()) {
            String attribute = (String)attributes.next();
            if (attribute.equalsIgnoreCase("RowNodeCreator")) continue;
            mapdcr.setAttribute(attribute, originalDCR.getAttribute(attribute));
        }
        return mapdcr;
    }

    private Map<String, Object> applyMapperOnRequest(Service service, DataControllerRequest request) throws MapperException {
        try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.REQUEST_MAPPER, "reqmapdur");){
            Map<String, Object> map = MapperUtility.prepareInputMap(service, request, this);
            return map;
        }
    }
}

