/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.handler.AsyncHandler;
import com.kony.adapter.model.Context;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.middleware.connectors.dataadapter.AbstractOperand;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ExceptionUtil;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataAdapterAsyncHandler<T>
implements AsyncHandler<T> {
    private static final Logger LOGGER = Logger.getLogger(DataAdapterAsyncHandler.class);
    private final AsyncHandler<Result> asyncHandler;
    private final AbstractOperand<T> operand;
    private MWMetricsTimer metricsTimer;

    public DataAdapterAsyncHandler(AbstractOperand<T> operand, AsyncHandler<Result> asyncHandler) {
        this.operand = operand;
        this.asyncHandler = asyncHandler;
    }

    public void onSuccess(T dataAdapterResult, Context context) {
        this.pushServiceTimeToMetricsBean();
        LOGGER.debug((Object)("Succesfully executed " + this.operand.getOperandName()));
        try {
            LOGGER.debug((Object)("Processing result for " + this.operand.getOperandName()));
            this.operand.processResults(dataAdapterResult);
            LOGGER.debug((Object)("Processed result for " + this.operand.getOperandName()));
            this.asyncHandler.onSuccess((Object)this.operand.getResult(), context);
            return;
        }
        catch (DataAdapterException e) {
            this.onError(e, context);
            return;
        }
        catch (Exception ex) {
            DataAdapterException e = new DataAdapterException(this.operand.getErrorCode(), ex.getMessage());
            this.onError(e, context);
            return;
        }
    }

    public void onError(DataAdapterException ex, Context context) {
        this.pushServiceTimeToMetricsBean();
        LOGGER.error((Object)("Error executing " + this.operand.getOperandName()), (Throwable)ex);
        Result result = this.operand.getResult();
        if (result != null) {
            if (ex.getCause() instanceof MiddlewareException) {
                ExceptionUtil.addErrorAttributes((Result)result, (MiddlewareException)((MiddlewareException)ex.getCause()));
            } else {
                this.operand.setResultParamString("errmsg", ex.getMessage());
                this.operand.setResultParamInt("opstatus", this.operand.getErrorCode());
                if (ex.getHttpStatusCode() != 0) {
                    this.operand.setResultParamInt("httpStatusCode", String.valueOf(ex.getHttpStatusCode()));
                }
            }
        }
        this.asyncHandler.onSuccess((Object)this.operand.getResult(), context);
    }

    private void pushServiceTimeToMetricsBean() {
        LOGGER.debug((Object)"call back method invoked on the DataAdapterAsyncHandler from Adapter");
        if (!StringUtils.equals((String)"initialize", (String)this.operand.getOperandName())) {
            this.metricsTimer.close();
        }
    }

    public void startMWMetricsTimer() {
        DataControllerRequest request = this.operand.getDataAdapterData().getDataControllerRequest();
        this.metricsTimer = new MWMetricsTimer(request, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis");
    }
}

