/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.konylabs.commons.vo.AppVersion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DataAdapterCache {
    private Map<AppVersion, Map<String, String>> appVerOperationIDConnectionHashMap = new HashMap<AppVersion, Map<String, String>>();
    private Map<String, String> hashAdapterBasePackageMap = new HashMap<String, String>();
    private Map<String, String> connectionHashConnectionInfoKeyMap = new HashMap<String, String>();
    private Map<String, Integer> hashCountMap = new HashMap<String, Integer>();
    private Set<AppVersion> updatedAssets = new HashSet<AppVersion>();
    private Set<AppVersion> updatedOrCreatedServices = new HashSet<AppVersion>();
    private boolean isJarRefresh = false;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public void clear() {
        this.appVerOperationIDConnectionHashMap.clear();
        this.connectionHashConnectionInfoKeyMap.clear();
        this.hashCountMap.clear();
        this.updatedAssets.clear();
        this.updatedOrCreatedServices.clear();
        this.hashAdapterBasePackageMap.clear();
    }

    public boolean isJarRefresh() {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.isJarRefresh;
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void setJarRefresh(boolean isJarRefresh) {
        this.readWriteLock.writeLock().lock();
        try {
            this.isJarRefresh = isJarRefresh;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Map<AppVersion, Map<String, String>> getAppVerOperationIDConnectionHashMap() {
        return this.appVerOperationIDConnectionHashMap;
    }

    public void putappVerOperationIDConnectionHashMap(AppVersion appVersion, String operationID, String hash) {
        Map<String, String> operationIDConnectionHashMap = this.getOperationIDConnectionHashMap(appVersion);
        if (operationIDConnectionHashMap == null) {
            operationIDConnectionHashMap = new HashMap<String, String>();
            operationIDConnectionHashMap.put(operationID, hash);
            this.appVerOperationIDConnectionHashMap.put(appVersion, operationIDConnectionHashMap);
        } else {
            operationIDConnectionHashMap.put(operationID, hash);
        }
    }

    public Map<String, String> getOperationIDConnectionHashMap(AppVersion appIDVerID) {
        return this.appVerOperationIDConnectionHashMap.get(appIDVerID);
    }

    public boolean hasOperationKey(AppVersion appVersion) {
        return this.getAppVerOperationIDConnectionHashMap().get(appVersion) != null;
    }

    public boolean hasAppVerOperationIDConnectionHashMap(AppVersion appIDVerID, String operationID) {
        return this.getOperationIDConnectionHashMap(appIDVerID) != null && this.getOperationIDConnectionHashMap(appIDVerID).containsKey(operationID);
    }

    public Map<String, Integer> getHashCountMap() {
        return this.hashCountMap;
    }

    public void setHashCountMap(Map<String, Integer> hashCountMap) {
        this.hashCountMap = hashCountMap;
    }

    public void putHashCountMap(String hash, Integer value) {
        this.hashCountMap.put(hash, value);
    }

    public void incrementHashCountMap(String hash) {
        Integer count = this.hashCountMap.get(hash);
        count = count + 1;
        this.hashCountMap.put(hash, count);
    }

    public void decrementHashCountMap(String hash) {
        Integer count = this.hashCountMap.get(hash);
        count = count - 1;
        this.hashCountMap.put(hash, count);
    }

    public Integer getCountOfConnectionPropsHash(String hash) {
        return this.hashCountMap.get(hash);
    }

    public void removeHashCountMap(String hash) {
        this.hashCountMap.remove(hash);
    }

    public Map<String, String> getConnectionHashConnectionInfoKeyMap() {
        return this.connectionHashConnectionInfoKeyMap;
    }

    public void putConnectionHashConnectionInfoKeyMap(String hash, String ConnectionInfo) {
        this.connectionHashConnectionInfoKeyMap.put(hash, ConnectionInfo);
    }

    public boolean hasConnectionHashConnectionInfoKey(String hash) {
        return this.connectionHashConnectionInfoKeyMap.containsKey(hash);
    }

    public void setConnectionHashConnectionInfoKeyMap(Map<String, String> operationIDConnectionInfoKeyMap) {
        this.connectionHashConnectionInfoKeyMap = operationIDConnectionInfoKeyMap;
    }

    public Set<AppVersion> getUpdatedAssets() {
        return this.updatedAssets;
    }

    public void setUpdatedAssets(Set<AppVersion> updatedAssets) {
        this.updatedAssets = updatedAssets;
    }

    public Set<AppVersion> getUpdatedOrCreatedServices() {
        return this.updatedOrCreatedServices;
    }

    public void setUpdatedOrCreatedServices(Set<AppVersion> updatedOrCreatedServices) {
        this.updatedOrCreatedServices = updatedOrCreatedServices;
    }

    public Map<String, String> getHashAdapterBasePackage() {
        return this.hashAdapterBasePackageMap;
    }

    public void putHashAdapterBasePackage(String hash, String basePackage) {
        this.hashAdapterBasePackageMap.put(hash, basePackage);
    }

    public void clearUpdatedServicesCache() {
        this.getUpdatedAssets().clear();
        this.getUpdatedOrCreatedServices().clear();
    }
}

