/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.event.DataAdapterEvent;
import com.kony.adapter.event.DataAdapterEventNotifier;
import com.kony.adapter.event.DataAdapterEventObserver;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.model.Context;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.ConnectorAsyncHandler;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterAsyncConnector;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.services.AbstractServiceDelegate;
import com.konylabs.middleware.services.ServiceDelegate;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataAdapterConnector
implements Connector,
DataAdapterEventNotifier {
    private static final Logger LOGGER = Logger.getLogger(DataAdapterConnector.class);
    private final DataAdapterAsyncConnector asyncConnector = this.getDataAdapterAsyncConnector();

    @Override
    public void setCallingProcessor(Processor processor) {
        if (processor instanceof AbstractServiceDelegate) {
            this.asyncConnector.setServiceDelegate((ServiceDelegate)processor);
        }
    }

    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        CountDownLatch latch = new CountDownLatch(1);
        ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
        Map<String, Object> configMap = this.getConfigMap(serviceMetadata, request);
        MiddlewareUtils.populateAdditionalConfig(serviceMetadata, request, configMap);
        ConnectorAsyncHandler handler = new ConnectorAsyncHandler(latch);
        Context context = new Context();
        context.put("handler", (Object)handler);
        this.asyncConnector.executeAsync(serviceMetadata, request, response, context, configMap);
        this.waitForResults(latch);
        try {
            return handler.getFinalResult();
        }
        catch (DataAdapterException e) {
            throw new ConnectorException("DataAdapterConnector", StringUtils.isBlank((String)e.getErrorCode()) ? "9110" : e.getErrorCode(), e.getHttpStatusCode(), e.getErrorMessage(), (Throwable)e);
        }
    }

    protected DataAdapterAsyncConnector getDataAdapterAsyncConnector() {
        return new DataAdapterAsyncConnector();
    }

    protected Map<String, Object> getConfigMap(ServiceMetadata serviceMetadata, DataControllerRequest request) {
        return MiddlewareUtils.populateConfigMap(serviceMetadata.getService(), serviceMetadata);
    }

    protected void waitForResults(CountDownLatch latch) {
        LOGGER.debug((Object)"Submitted the operation to dataAdapter and waiting for results.");
        try {
            latch.await(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Adapter failed executing the operation", (Throwable)e);
        }
    }

    public void notify(DataAdapterEvent event) {
        this.asyncConnector.notify(event);
    }

    public void register(DataAdapterEventObserver observer) {
        this.asyncConnector.register(observer);
    }

    public void unregister(DataAdapterEventObserver observer) {
        this.asyncConnector.unregister(observer);
    }

    public static enum OPCODE {
        login,
        logout,
        create,
        update,
        partialupdate,
        delete,
        get,
        query,
        bulkcreate,
        bulkupdate,
        bulkdelete,
        service,
        queryBinary,
        createBinary,
        updateBinary,
        deleteBinary;

    }
}

