/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.DataAdapter;
import com.kony.adapter.DataAdapterFactory;
import com.kony.adapter.criteria.Criteria;
import com.kony.adapter.event.DataAdapterEvent;
import com.kony.adapter.event.DataAdapterEventNotifier;
import com.kony.adapter.event.DataAdapterEventObserver;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.metadata.model.EntityMetadata;
import com.kony.adapter.metadata.model.Metadata;
import com.kony.adapter.metadata.model.RelationshipMetadata;
import com.kony.adapter.model.Context;
import com.kony.adapter.model.Entity;
import com.kony.adapter.service.runtime.ServiceData;
import com.kony.adapter.util.criteria.CriteriaBuilder;
import com.kony.adapter.util.criteria.CriteriaBuilderFactory;
import com.kony.apigateway.adapter.AWSAPIGatewayDataAdapter;
import com.kony.dataadapter.annotations.adapter.AnnotationAdapter;
import com.kony.rdbms.adapter.RDBMSDataAdapter;
import com.kony.skyrest.adapter.SkyDataAdapter;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.connectors.dataadapter.AbstractOperand;
import com.konylabs.middleware.connectors.dataadapter.CreateBinaryOperand;
import com.konylabs.middleware.connectors.dataadapter.CreateOperand;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterAsyncConnector;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterConnector;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterOperand;
import com.konylabs.middleware.connectors.dataadapter.DeleteBinaryOperand;
import com.konylabs.middleware.connectors.dataadapter.DeleteOperand;
import com.konylabs.middleware.connectors.dataadapter.InitializingOperand;
import com.konylabs.middleware.connectors.dataadapter.PartialUpdateOperand;
import com.konylabs.middleware.connectors.dataadapter.QueryBinaryOperand;
import com.konylabs.middleware.connectors.dataadapter.QueryOperand;
import com.konylabs.middleware.connectors.dataadapter.ServiceOperand;
import com.konylabs.middleware.connectors.dataadapter.UpdateBinaryOperand;
import com.konylabs.middleware.connectors.dataadapter.UpdateOperand;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DataAdapterData {
    private static final Logger LOGGER = Logger.getLogger(DataAdapterData.class);
    private DataAdapter dataAdapter;
    private Metadata metadata;
    private Criteria criteria;
    private Context context;
    private ServiceMetadata serviceMetadata;
    private Map<String, Param> serviceInputParams;
    private Map<String, Object> config;
    private Map<String, Object> inputMap;
    private String opCode;
    private String entityMetadataString;
    private String adapterType;
    private String adapterClass;
    private String adapterBasePackage;
    private Map<String, String> headerMap;
    private Map<String, Object> additionalProps;
    private Map<String, EntityMetadata> relatedEntityMetadataMap;
    private DataControllerRequest dataControllerRequest;
    private DataControllerResponse dataControllerResponse;
    private Entity entity;
    private ServiceData serviceData;

    public DataAdapterData() {
    }

    public DataAdapterData(Context context, Map<String, Object> config, Map<String, Object> inputMap, Map<String, String> headerMap, Map<String, Object> additionalProps, ServiceMetadata serviceMetadata, final DataAdapterAsyncConnector connector) throws DataAdapterConnectorException {
        this.context = context;
        this.config = config;
        this.inputMap = inputMap;
        this.headerMap = headerMap;
        this.additionalProps = additionalProps;
        this.serviceMetadata = serviceMetadata;
        this.opCode = (String)config.get("opcode");
        this.entityMetadataString = (String)config.get("entitymetadata");
        this.adapterType = (String)config.get("adaptertype");
        this.adapterClass = (String)config.get("adapterclass");
        this.adapterBasePackage = (String)config.get("basepackage");
        DataAdapter adapter = this.getAdapterClass(this.adapterType, this.adapterClass, this.adapterBasePackage, serviceMetadata);
        if (adapter instanceof DataAdapterEventNotifier) {
            DataAdapterEventObserver eventObserver = new DataAdapterEventObserver(){

                public void onEvent(DataAdapterEvent event) {
                    connector.notify(event);
                }
            };
            ((DataAdapterEventNotifier)adapter).register(eventObserver);
        }
        this.setDataAdapter(adapter);
    }

    public DataAdapterData(Context context, Map<String, Object> config, ServiceMetadata serviceMetadata, DataAdapterAsyncConnector connector) throws DataAdapterConnectorException {
        this(context, config, null, null, null, serviceMetadata, connector);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public ServiceData getServiceData() {
        return this.serviceData;
    }

    public void setServiceData(ServiceData serviceData) {
        this.serviceData = serviceData;
    }

    public DataControllerRequest getDataControllerRequest() {
        return this.dataControllerRequest;
    }

    public void setDataControllerRequest(DataControllerRequest dcr) {
        this.dataControllerRequest = dcr;
        this.setTenantBeanInContext();
    }

    private void setTenantBeanInContext() {
        if (this.context != null) {
            TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromDCRequest(this.dataControllerRequest);
            this.context.put("tenantBean", tenantBean);
        }
    }

    public DataAdapter getDataAdapter() {
        return this.dataAdapter;
    }

    public void setDataAdapter(DataAdapter dataAdapter) {
        this.dataAdapter = dataAdapter;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata entityMetadata) {
        this.metadata = entityMetadata;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(HashMap<String, Object> config) {
        this.config = config;
    }

    public Map<String, Object> getInputMap() {
        if (this.inputMap == null) {
            this.inputMap = new HashMap<String, Object>();
        }
        return this.inputMap;
    }

    public void setInputMap(Map<String, Object> inputMap) {
        this.inputMap = inputMap;
    }

    public String getOpCode() {
        return this.opCode;
    }

    public void setOpCode(String opCode) {
        this.opCode = opCode;
    }

    public String getEntityMetadataString() {
        return this.entityMetadataString;
    }

    public void setEntityMetadataString(String entityMetadataString) {
        this.entityMetadataString = entityMetadataString;
    }

    public String getAdapterType() {
        return this.adapterType;
    }

    public void setAdapterType(String adapterType) {
        this.adapterType = adapterType;
    }

    public String getAdapterClass() {
        return this.adapterClass;
    }

    protected DataAdapter getAdapterClass(String adapterType, String adapterClass, String adapterBasePackage, ServiceMetadata serviceMetadata) throws DataAdapterConnectorException {
        Class<? extends Object> adapterClassObj = null;
        try {
            if (StringUtils.isNotBlank((String)adapterType)) {
                LOGGER.debug((Object)("Adapter type is: " + adapterType));
                if (adapterType.equals(DataAdapterFactory.DataAdapterType.KONY_SKYREST.toString())) {
                    adapterClassObj = SkyDataAdapter.class;
                } else if (adapterType.equals(DataAdapterFactory.DataAdapterType.KONY_DATABASE.toString())) {
                    adapterClassObj = RDBMSDataAdapter.class;
                } else if (adapterType.equals(DataAdapterFactory.DataAdapterType.KONY_AWSAPI_GATEWAY.toString())) {
                    adapterClassObj = AWSAPIGatewayDataAdapter.class;
                } else if (adapterType.equals(DataAdapterFactory.DataAdapterType.CUSTOM.toString())) {
                    LOGGER.debug((Object)("Base package is : " + adapterBasePackage));
                    MiddlewareClassloaderManager middlewareClassloaderManager = MiddlewareClassloaderFactory.getClassLoaderManager();
                    AnnotationAdapter annotationAdapter = serviceMetadata != null && serviceMetadata.getProcessedConfigMap() != null && serviceMetadata.getProcessedConfigMap().get("AdapterKey") != null ? (AnnotationAdapter)serviceMetadata.getProcessedConfigMap().get("AdapterKey") : middlewareClassloaderManager.getDataAdapterInstance(adapterBasePackage);
                    return annotationAdapter;
                }
            } else if (StringUtils.isNotBlank((String)adapterClass)) {
                adapterClassObj = MiddlewareClassloaderFactory.getClassLoaderManager().getClassObj(adapterClass);
            } else {
                String errorCode = DataAdapterConnectorException.EMPTY_ADAPTER_TYPE;
                String errorMessage = DataAdapterConnectorException.getErrorCodeMessage(errorCode);
                throw new DataAdapterConnectorException(errorCode, errorMessage, 500);
            }
            DataAdapterFactory.getInstance().registerDataAdapter(adapterType, adapterClassObj);
            return DataAdapterFactory.getInstance().getDataAdapterInstance(adapterType);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while trying to create instance of data adapter connector", (Throwable)e);
            throw new DataAdapterConnectorException(DataAdapterConnectorException.ADAPTER_TYPE_ERROR, 500);
        }
    }

    public Criteria prepareCriteria(String odataString) throws DataAdapterConnectorException {
        if (this.criteria == null) {
            this.criteria = new Criteria();
        }
        return DataAdapterData.prepareCriteria(odataString, this.context);
    }

    public static Criteria prepareCriteria(String odataString, Context context) throws DataAdapterConnectorException {
        StringBuilder sbCriteria = new StringBuilder();
        LOGGER.debug((Object)"Inside prepare criteria method.");
        Map<String, String> paramsMap = DataAdapterData.getOdataMap(odataString);
        if (paramsMap != null) {
            for (String key : paramsMap.keySet()) {
                String value = paramsMap.get(key);
                String actualOdataValue = "${" + key + "}";
                if (value == null || actualOdataValue.compareTo(value) == 0) continue;
                if (sbCriteria.length() > 0) {
                    sbCriteria.append("&");
                }
                sbCriteria.append(key).append("=").append(value);
            }
        }
        try {
            CriteriaBuilder criteriaBuilder = CriteriaBuilderFactory.create((String)sbCriteria.toString());
            context.setBatchContext(criteriaBuilder.getBatchContext());
            return criteriaBuilder.getCriteria();
        }
        catch (DataAdapterException dae) {
            LOGGER.error((Object)"Adapter failed executing the operation", (Throwable)dae);
            throw new DataAdapterConnectorException(DataAdapterConnectorException.DATAADAPTER_EXCEPTION, dae.getErrorMessage(), dae.getHttpStatusCode());
        }
    }

    private static Map<String, String> getOdataMap(String odataString) {
        if (odataString != null && odataString.length() > 0) {
            return DataAdapterData.getQueryParams(new Scanner(odataString), "&", "=");
        }
        return null;
    }

    private static Map<String, String> getQueryParams(Scanner scanner, String paramSeperator, String nameValueSeperator) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        scanner.useDelimiter(paramSeperator);
        while (scanner.hasNext()) {
            String[] nameValue = scanner.next().split(nameValueSeperator);
            if (nameValue.length == 0 || nameValue.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String name = nameValue[0];
            String value = null;
            if (nameValue.length == 2) {
                value = nameValue[1];
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }

    public DataAdapterOperand getAdapterOperand() throws DataAdapterConnectorException {
        AbstractOperand operand = null;
        if (this.config != null) {
            String opCode = (String)this.config.get("opcode");
            if (DataAdapterConnector.OPCODE.query.toString().equals(opCode)) {
                operand = new QueryOperand();
            } else if (DataAdapterConnector.OPCODE.create.toString().equals(opCode)) {
                operand = new CreateOperand();
            } else if (DataAdapterConnector.OPCODE.update.toString().equals(opCode)) {
                operand = new UpdateOperand();
            } else if (DataAdapterConnector.OPCODE.delete.toString().equals(opCode)) {
                operand = new DeleteOperand();
            } else if (DataAdapterConnector.OPCODE.service.toString().equals(opCode)) {
                operand = new ServiceOperand();
            } else if (DataAdapterConnector.OPCODE.partialupdate.toString().equals(opCode)) {
                operand = new PartialUpdateOperand();
            } else if (DataAdapterConnector.OPCODE.queryBinary.toString().equals(opCode)) {
                operand = new QueryBinaryOperand();
            } else if (DataAdapterConnector.OPCODE.createBinary.toString().equals(opCode)) {
                operand = new CreateBinaryOperand();
            } else if (DataAdapterConnector.OPCODE.updateBinary.toString().equals(opCode)) {
                operand = new UpdateBinaryOperand();
            } else if (DataAdapterConnector.OPCODE.deleteBinary.toString().equals(opCode)) {
                operand = new DeleteBinaryOperand();
            }
        }
        if (operand == null) {
            throw new DataAdapterConnectorException(DataAdapterConnectorException.EMPTY_OPERAND, 500);
        }
        return operand;
    }

    public DataAdapterOperand getInitializationOperand() {
        return new InitializingOperand();
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    public void setService(ServiceMetadata serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

    public Map<String, Param> getServiceInputParams() {
        if (this.serviceInputParams == null) {
            this.serviceInputParams = new HashMap<String, Param>();
            ArrayList paramsList = this.serviceMetadata.getService().getServiceInput().getParams();
            for (Param param : paramsList) {
                this.serviceInputParams.put(param.getName(), param);
            }
        }
        return this.serviceInputParams;
    }

    public void setServiceInputParams(Map<String, Param> serviceInputParams) {
        this.serviceInputParams = serviceInputParams;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
    }

    public Map<String, Object> getAdditionalProps() {
        return this.additionalProps;
    }

    public void setAdditionalProps(Map<String, Object> additionalProps) {
        this.additionalProps = additionalProps;
    }

    public Map<String, EntityMetadata> getRelatedEntityMetadataMap() {
        if (this.relatedEntityMetadataMap == null) {
            this.relatedEntityMetadataMap = new HashMap<String, EntityMetadata>();
            this.prepareRelatedEntityMetadataMap((EntityMetadata)this.getMetadata());
        }
        return this.relatedEntityMetadataMap;
    }

    private void prepareRelatedEntityMetadataMap(EntityMetadata entityMetadata) {
        List emRelationshipsList = entityMetadata.getRelationships();
        if (emRelationshipsList != null && emRelationshipsList.size() > 0) {
            for (RelationshipMetadata em : emRelationshipsList) {
                this.relatedEntityMetadataMap.put(em.getRelatedEntityMetaData().getName(), em.getRelatedEntityMetaData());
                this.prepareRelatedEntityMetadataMap(em.getRelatedEntityMetaData());
            }
        }
    }

    public void setRelatedEntityMetadataMap(Map<String, EntityMetadata> relatedEntityMetadata) {
        this.relatedEntityMetadataMap = relatedEntityMetadata;
    }

    public DataControllerResponse getDataControllerResponse() {
        return this.dataControllerResponse;
    }

    public void setDataControllerResponse(DataControllerResponse dataControllerResponse) {
        this.dataControllerResponse = dataControllerResponse;
    }
}

