/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.util.criteria.Odata2CriteriaBuilder;
import com.kony.api.gateway.Gateway;
import com.konylabs.middleware.connectors.io.AbstractServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.mbaas.MiddlewareMBaasUtils;
import com.konylabs.middleware.registry.vo.Dataset;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Record;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.registry.vo.ServiceInput;
import com.konylabs.middleware.registry.vo.TemplateParam;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataAdapterInputHandler
extends AbstractServiceInputHandler {
    private static final Logger LOGGER = Logger.getLogger(DataAdapterInputHandler.class);

    @Override
    public String getMessage(DataControllerRequest request, Map<String, Object> inputMap, Map configMap, Service service) throws ConnectorException {
        LOGGER.error((Object)"Unimplemented method for DataAdapterConnector-> getMessage()");
        throw new ConnectorException(service.getServiceType(), "1001", "Unimplemented method for DataAdapterConnector-> getMessage()");
    }

    public String getOdataString(DataControllerRequest request, Map<String, Object> inputMap, Map<String, Object> configMap, Service service) throws ConnectorException {
        this.validateOdataParams(inputMap);
        ArrayList tempParams = service.getServiceInput().getTemplateParams();
        if (tempParams.size() > 0) {
            TemplateParam param = (TemplateParam)tempParams.get(0);
            return this.fillMessage(param, inputMap, configMap);
        }
        return null;
    }

    void validateOdataParams(Map<String, Object> inputMap) throws ConnectorException {
        for (String key : inputMap.keySet()) {
            if (!key.startsWith("$")) continue;
            this.validateOdataParam(key + "=" + EncodeUtils.encode((String)((String)inputMap.get(key))));
        }
    }

    void validateOdataParam(String odataString) throws ConnectorException {
        try {
            new Odata2CriteriaBuilder(odataString).getBatchContext();
        }
        catch (DataAdapterException e) {
            LOGGER.error((Object)"Odata parsing failed ", (Throwable)e);
            throw new ConnectorException("DataAdapterConector", DataAdapterConnectorException.INVALID_ODATA, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> getInputMap(DataControllerRequest request, Map configMap, Service service, String endpointURL) throws ConnectorException {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        try {
            ServiceInput serviceInput = service.getServiceInput();
            ArrayList params = serviceInput.getParams();
            ArrayList records = serviceInput.getRecords();
            ArrayList datasets = serviceInput.getDatasets();
            LOGGER.debug((Object)("Param Size : " + params.size()));
            LOGGER.debug((Object)("Record Size : " + records.size()));
            LOGGER.debug((Object)("Dataset Size : " + datasets.size()));
            this.populateTemplateParams(request, service, inputMap);
            this.populateParams(request, params, inputMap);
            this.populateRecords(request, records, inputMap);
            this.populateDatasets(request, datasets, inputMap);
            this.evaluateExpressionParams(params, inputMap);
        }
        catch (JSONException e) {
            throw new ConnectorException("", "", e.getMessage(), (Throwable)e);
        }
        return inputMap;
    }

    private void evaluateExpressionParams(List<Param> params, Map<String, Object> inputMap) throws ConnectorException {
        for (Param metadataParam : params) {
            if (!"expression".equals(metadataParam.getSource())) continue;
            String expressionValue = this.fillMessageForParamsWithExpression(metadataParam, inputMap, inputMap);
            inputMap.put(metadataParam.getName(), expressionValue);
        }
    }

    public void populateTemplateParams(DataControllerRequest request, Service service, Map<String, Object> inputMap) throws ConnectorException {
        TemplateParam tparam = null;
        ArrayList tempParams = service.getServiceInput().getTemplateParams();
        if (tempParams.size() > 0) {
            tparam = (TemplateParam)tempParams.get(0);
            ArrayList tparams = tparam.getParam();
            this.populateParams(request, tparams, inputMap);
        }
    }

    void populateParams(DataControllerRequest request, List<Param> params, Map<String, Object> inputMap) throws ConnectorException {
        Session session = request.getSession(false);
        if (session == null) {
            LOGGER.error((Object)"Very rare scenario. Did not find an exisitng session in connector.");
        }
        for (Param param : params) {
            String source = param.getSource();
            String paramName = param.getName();
            Object paramValue = null;
            LOGGER.debug((Object)("Param Source : " + source + " Name: " + paramName));
            if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                if ("collection".equals(param.getDataType())) {
                    if (StringUtils.isNotEmpty((String)request.getParameter(paramName))) {
                        paramValue = this.convertString2ListForPrimitiveCollection(request.getParameter(paramName), paramName, paramValue);
                    }
                } else {
                    paramValue = request.getParameter(paramName);
                }
                MaskUtils.logDebugWithMasking((String)"ParamValue :", (String)paramName, (String)String.valueOf(paramValue));
            } else if ("session".equals(source)) {
                paramValue = session.getAttribute(paramName);
                MaskUtils.logDebugWithMasking((String)"ParamValue :", (String)paramName, (String)String.valueOf(paramValue));
            } else if ("identity".equals(source)) {
                Gateway gateway = MiddlewareMBaasUtils.getGatewayFromDCR(request);
                paramValue = super.processIdentityParam(param, gateway);
            } else if ("constant".equals(source)) {
                paramValue = param.getSourcevalue();
            } else if ("expression".equals(source)) {
                paramValue = param.getValue();
            } else {
                LOGGER.debug((Object)("Invalid source type " + source + " while preparing request for scraping service"));
                throw new ConnectorException("sapConnector", "8701", "Invalid source to the param for  " + paramName);
            }
            if (paramValue == null && StringUtils.isNotBlank((String)param.getDefaultValue())) {
                paramValue = param.getDefaultValue();
            }
            if (paramValue != null && "date".equalsIgnoreCase(param.getDataType())) {
                try {
                    paramValue = this.convertStringToDate(paramValue, param.getFormatvalue());
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"Unable to format the value ", (Throwable)ex);
                }
            }
            if (paramValue == null) continue;
            if ("NULL".equalsIgnoreCase(paramValue.toString())) {
                inputMap.put(paramName, null);
                continue;
            }
            if ("\"NULL\"".equalsIgnoreCase(paramValue.toString())) {
                inputMap.put(paramName, paramValue.toString().substring(1, paramValue.toString().length() - 1));
                continue;
            }
            inputMap.put(paramName, paramValue);
        }
    }

    Date convertStringToDate(Object paramValue, String formatValue) throws ParseException {
        if (StringUtils.isNotBlank((String)formatValue)) {
            SimpleDateFormat sdf = new SimpleDateFormat(formatValue);
            return sdf.parse((String)paramValue);
        }
        return DatatypeConverter.parseDateTime((String)((String)paramValue)).getTime();
    }

    private Object convertString2ListForPrimitiveCollection(String paramPrimitiveValue, String paramName, Object paramValue) throws ConnectorException {
        try {
            paramValue = new Gson().fromJson(paramPrimitiveValue, List.class);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error((Object)("Error occurred: Value provided for " + paramName + "[" + paramValue + "] is not a valid json."), (Throwable)e);
            throw new ConnectorException("", "", "Error occurred: Value provided for " + paramName + "[" + paramValue + "] is not a valid json.", (Throwable)e);
        }
        return paramValue;
    }

    private void populateRecords(DataControllerRequest request, List<Record> records, Map<String, Object> inputMap) throws ConnectorException {
        Session session = request.getSession(false);
        if (session == null) {
            LOGGER.error((Object)"Very rare scenario. Did not find an exisitng session when in scrapping connector.");
        }
        for (Record record : records) {
            String source = record.getSource();
            String paramName = record.getId();
            Object paramValue = null;
            LOGGER.debug((Object)("Record Source : " + source + " Name: " + paramName));
            if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                paramValue = request.getParameter(paramName);
                MaskUtils.logDebugWithMasking((String)"Record value", (String)paramName, (String)String.valueOf(paramValue));
                paramValue = this.convertJSON2Record(paramValue, record.getId());
            } else if ("session".equals(source)) {
                paramValue = session.getAttribute(paramName);
                MaskUtils.logDebugWithMasking((String)"Record value", (String)paramName, (String)String.valueOf(paramValue));
            } else {
                LOGGER.debug((Object)("Invalid source type " + source + " while preparing request for scraping service"));
                throw new ConnectorException("sapConnector", "8701", "Invalid source to the param for  " + paramName);
            }
            inputMap.put(paramName, paramValue);
        }
    }

    private com.konylabs.middleware.dataobject.Record convertJSON2Record(Object jsonString, String id) throws JSONException, ConnectorException {
        com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
        record.setId(id);
        if (jsonString == null) {
            jsonString = "{}";
        }
        JSONObject jsonObject = null;
        jsonObject = jsonString instanceof JSONObject ? (JSONObject)jsonString : new JSONObject((String)jsonString);
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            com.konylabs.middleware.dataobject.Param param = new com.konylabs.middleware.dataobject.Param();
            Object paramValue = jsonObject.get(key);
            if (paramValue instanceof JSONArray) {
                JSONArray paramValueArray = (JSONArray)paramValue;
                if (paramValueArray.length() >= 1 && !(paramValueArray.get(0) instanceof JSONObject)) {
                    param.setObjectValue(this.convertString2ListForPrimitiveCollection(String.valueOf(paramValueArray), key, paramValueArray));
                    param.setName(key);
                    param.setType("collection");
                    record.addParam(param);
                    continue;
                }
                record.addDataset(this.convertJSON2Dataset(paramValue, key));
                continue;
            }
            if (paramValue instanceof JSONObject) {
                record.addRecord(this.convertJSON2Record(paramValue, key));
                continue;
            }
            if (paramValue instanceof String) {
                param.setName(key);
                param.setValue((String)paramValue);
                param.setType("string");
                record.addParam(param);
                continue;
            }
            if (paramValue instanceof Double) {
                param.setName(key);
                param.setValue(paramValue == null ? null : paramValue.toString());
                param.setObjectValue(paramValue);
                param.setType("double");
                record.addParam(param);
                continue;
            }
            if (paramValue instanceof Float) {
                param.setName(key);
                param.setValue(paramValue == null ? null : paramValue.toString());
                param.setObjectValue(paramValue);
                param.setType("float");
                record.addParam(param);
                continue;
            }
            if (paramValue instanceof Integer) {
                param.setName(key);
                param.setValue(paramValue == null ? null : paramValue.toString());
                param.setObjectValue(paramValue);
                param.setType("int");
                record.addParam(param);
                continue;
            }
            if (paramValue instanceof Long) {
                param.setName(key);
                param.setValue(paramValue == null ? null : paramValue.toString());
                param.setObjectValue(paramValue);
                param.setType("long");
                record.addParam(param);
                continue;
            }
            if (paramValue instanceof Boolean) {
                param.setName(key);
                param.setValue(paramValue == null ? null : paramValue.toString());
                param.setObjectValue(paramValue);
                param.setType("boolean");
                record.addParam(param);
                continue;
            }
            if (paramValue instanceof Character) {
                param.setName(key);
                param.setValue(paramValue == null ? null : paramValue.toString());
                param.setObjectValue(paramValue);
                param.setType("char");
                record.addParam(param);
                continue;
            }
            param.setName(key);
            param.setValue(paramValue == null ? null : paramValue.toString());
            param.setObjectValue(paramValue);
            param.setType("object");
            record.addParam(param);
        }
        return record;
    }

    private void populateDatasets(DataControllerRequest request, List<Dataset> datasets, Map<String, Object> inputMap) throws ConnectorException {
        Session session = request.getSession(false);
        if (session == null) {
            LOGGER.error((Object)"Very rare scenario. Did not find an exisitng session when in scrapping connector.");
        }
        for (Dataset dataset : datasets) {
            String source = dataset.getSource();
            String paramName = dataset.getId();
            Object paramValue = null;
            LOGGER.debug((Object)("Record Source : " + source + " Name: " + paramName));
            if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                paramValue = request.getParameter(paramName);
                MaskUtils.logDebugWithMasking((String)"Record", (String)paramName, (String)String.valueOf(paramValue));
                paramValue = this.convertJSON2Dataset(paramValue, paramName);
            } else if ("session".equals(source)) {
                paramValue = session.getAttribute(paramName);
                MaskUtils.logDebugWithMasking((String)"Record", (String)paramName, (String)String.valueOf(paramValue));
            } else {
                LOGGER.debug((Object)("Invalid source type " + source + " while preparing request for scraping service"));
                throw new ConnectorException("sapConnector", "8701", "Invalid source to the param for  " + paramName);
            }
            inputMap.put(paramName, paramValue);
        }
    }

    private com.konylabs.middleware.dataobject.Dataset convertJSON2Dataset(Object paramValue, String id) throws JSONException, ConnectorException {
        com.konylabs.middleware.dataobject.Dataset dataset = new com.konylabs.middleware.dataobject.Dataset();
        dataset.setId(id);
        if (paramValue == null) {
            paramValue = "[]";
        }
        JSONArray jsonArray = null;
        if (paramValue instanceof JSONArray) {
            jsonArray = (JSONArray)paramValue;
        } else if (paramValue instanceof JSONObject) {
            dataset.addRecord(this.convertJSON2Record(paramValue, id));
        } else {
            jsonArray = new JSONArray((String)paramValue);
        }
        if (jsonArray != null) {
            for (int idx = 0; idx < jsonArray.length(); ++idx) {
                JSONObject jsonObj = (JSONObject)jsonArray.get(idx);
                dataset.addRecord(this.convertJSON2Record(jsonObj, id));
            }
        }
        return dataset;
    }

    @Override
    protected String fillMessageForString(String tvalue, String key, String value, Map<String, String> configMap, boolean encode, boolean escape) {
        return EncodeUtils.encode((String)super.fillMessageForString(tvalue, key, value, configMap, encode, escape));
    }

    @Override
    protected String fillMessageForDataSet(String template, com.konylabs.middleware.dataobject.Dataset dataset) {
        return EncodeUtils.encode((String)super.fillMessageForDataSet(template, dataset));
    }
}

