/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.konylabs.middleware.connectors.XPathEngineImpl;
import com.konylabs.middleware.connectors.io.BaseOutputHandler;
import com.konylabs.middleware.connectors.json.JsonPathFromXpathEngineImpl;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Record;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class DataAdapterOutputHandler
extends BaseOutputHandler {
    private static final Logger LOGGER = Logger.getLogger(DataAdapterOutputHandler.class);
    private String rootValue;

    @Override
    public void processOutput(Service service, DataControllerRequest request, DataControllerResponse response, Result result) throws ConnectorException {
        String responseStr = null;
        String opstatusCode = null;
        try {
            ConfigParam pathsMetadata = service.getServiceConfig().getConfigParam("pathMetadata");
            if (pathsMetadata != null && result.getParamByName("errmsg") == null) {
                Result newResult = this.applyPathsOnResult(service, result, request, pathsMetadata);
                this.resetResult(result);
                result.addAllParams((Collection)newResult.getAllParams());
                result.addAllRecords((Collection)newResult.getAllRecords());
                result.addAllDatasets((Collection)newResult.getAllDatasets());
            }
            responseStr = ResultToJSON.convert((Result)result, (DataControllerResponse)response);
            LOGGER.debug((Object)("Response message: " + responseStr));
            LOGGER.debug((Object)"Processing the output for the DataAdapter");
            response.setResponse(responseStr);
        }
        catch (Exception e) {
            MiddlewareUtils.maskTrace("5007", "Error parsing the JSON response.", e);
            result.addParam(new com.konylabs.middleware.dataobject.Param("opstatus", "777777", "int"));
            result.addParam(new com.konylabs.middleware.dataobject.Param("httpStatusCode", "500", "int"));
            if (ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) {
                result.addParam(new com.konylabs.middleware.dataobject.Param("errmsg", "Cannot parse. Invalid Json for " + service.getId(), "string"));
            }
            return;
        }
        String httpStatusCode = String.valueOf(response.getStatusCode());
        super.processOutput(service, request, response, result);
        if (responseStr == null || responseStr.trim().length() == 0) {
            LOGGER.debug((Object)"Empty response received.");
            result.addParam(new com.konylabs.middleware.dataobject.Param("opstatus", "8005", "int"));
            result.addParam(new com.konylabs.middleware.dataobject.Param("httpStatusCode", httpStatusCode, "int"));
            result.addParam(new com.konylabs.middleware.dataobject.Param("errmsg", "empty response received", "string"));
            return;
        }
        opstatusCode = (String)response.getHeaders().get("X-Kony-Service-Opstatus");
        result.addParam(new com.konylabs.middleware.dataobject.Param("opstatus", opstatusCode == null ? "0" : opstatusCode, "int"));
        com.konylabs.middleware.dataobject.Param status = result.getParamByName("httpStatusCode");
        if (status == null) {
            result.addParam(new com.konylabs.middleware.dataobject.Param("httpStatusCode", httpStatusCode, "int"));
        } else {
            response.setStatusCode(Integer.parseInt(status.getValue()));
        }
    }

    private void resetResult(Result dataObjectResult) {
        dataObjectResult.clearParams();
        dataObjectResult.clearDatasets();
        dataObjectResult.clearRecords();
    }

    private Result applyPathsOnResult(Service service, Result result, DataControllerRequest request, ConfigParam pathsMetadata) throws Exception {
        JsonObject jsonObject = new JsonParser().parse(pathsMetadata.getValue()).getAsJsonObject();
        JsonArray arrayOfjsonPaths = jsonObject.get("jsonPaths") != null ? jsonObject.get("jsonPaths").getAsJsonArray() : new JsonArray();
        JsonArray arrayOfXmlPaths = jsonObject.get("xmlPaths") != null ? jsonObject.get("xmlPaths").getAsJsonArray() : new JsonArray();
        Result deconstructedResult = new Result();
        for (JsonElement jsPath : arrayOfjsonPaths) {
            this.processJsonPaths(service, result, request, jsPath.getAsString(), deconstructedResult);
        }
        for (JsonElement xmlPath : arrayOfXmlPaths) {
            this.processXmlPaths(service, result, request, xmlPath.getAsString(), deconstructedResult);
        }
        return deconstructedResult;
    }

    private List<String> getParamNamesFromService(List<Param> params) {
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Param param : params) {
            paramNames.add(param.getName());
        }
        return paramNames;
    }

    private List<String> getParamNamesFromDataObjectRecord(Service service, com.konylabs.middleware.dataobject.Record dataObjectRecord) {
        for (Record voRecord : service.getServiceOutput().getRecords()) {
            if (voRecord.getId() != dataObjectRecord.getId()) continue;
            return this.getParamNamesFromService(voRecord.getParams());
        }
        return null;
    }

    private void processXmlPaths(Service service, Result result, DataControllerRequest request, String paramPath, Result deconstructedResult) throws Exception {
        this.getRootValueFromResult(result, paramPath, service, deconstructedResult);
        if (this.rootValue.startsWith("<")) {
            XPathEngineImpl xpathEngineImpl = new XPathEngineImpl(this.rootValue, "UTF-8");
            xpathEngineImpl.fillParams(deconstructedResult, service.getServiceOutput().getParams(), request);
            deconstructedResult.addAllRecords(xpathEngineImpl.fillRecords(service.getServiceOutput().getRecords()));
            deconstructedResult.addAllDatasets(xpathEngineImpl.fillDatasets(service.getServiceOutput().getDatasets()));
        }
    }

    private void getRootValueFromResult(Result result, String paramPath, Service service, Result deconstructedResult) {
        this.getRootValueFromParams(paramPath, result.getAllParams(), deconstructedResult, this.getParamNamesFromService(service.getServiceOutput().getParams()), null);
        this.getRootValueFromRecords(paramPath, result.getAllRecords(), service, deconstructedResult);
        this.getRootValueFromDataSets(paramPath, result.getAllDatasets(), service, deconstructedResult);
    }

    private void getRootValueFromDataSets(String paramPath, List<Dataset> allDatasets, Service service, Result newResult) {
        for (Dataset dataset : allDatasets) {
            newResult.addDataset(dataset);
            this.getRootValueFromRecords(paramPath, dataset.getAllRecords(), service, newResult);
        }
    }

    private void getRootValueFromRecords(String paramPath, List<com.konylabs.middleware.dataobject.Record> allRecords, Service service, Result newResult) {
        for (com.konylabs.middleware.dataobject.Record record : allRecords) {
            newResult.addRecord(record);
            this.getRootValueFromParams(paramPath, record.getAllParams(), newResult, this.getParamNamesFromDataObjectRecord(service, record), record);
            this.getRootValueFromRecords(paramPath, record.getAllRecords(), service, newResult);
            this.getRootValueFromDataSets(paramPath, record.getAllDatasets(), service, newResult);
        }
    }

    private Result getRootValueFromParams(String paramPath, List<com.konylabs.middleware.dataobject.Param> dataObjectParams, Result newResult, List<String> listOfVoOutputParams, com.konylabs.middleware.dataobject.Record addToRecord) {
        com.konylabs.middleware.dataobject.Record newRecord = null;
        if (addToRecord != null) {
            newRecord = newResult.getRecordById(addToRecord.getId());
        }
        for (com.konylabs.middleware.dataobject.Param param : dataObjectParams) {
            if (param.getName().equals(paramPath)) {
                this.rootValue = param.getValue();
            }
            if (addToRecord == null && listOfVoOutputParams.contains(param.getName())) {
                newResult.addParam(param);
                continue;
            }
            if (newRecord == null || addToRecord == null) continue;
            newRecord.addParam(param);
        }
        if (newRecord != null) {
            newResult.addRecord(newRecord);
        }
        return newResult;
    }

    private void processJsonPaths(Service service, Result result, DataControllerRequest request, String paramPath, Result deconstructedResult) throws Exception {
        this.getRootValueFromResult(result, paramPath, service, deconstructedResult);
        if (this.rootValue.startsWith("{") || this.rootValue.startsWith("[")) {
            JsonPathFromXpathEngineImpl engine = new JsonPathFromXpathEngineImpl(this.rootValue);
            result.addAllParams((Collection)engine.fillParams((List)service.getServiceOutput().getParams(), request, null));
            result.addAllRecords((Collection)engine.fillRecords((List)service.getServiceOutput().getRecords(), request, null));
            deconstructedResult.addAllDatasets((Collection)engine.fillDatasets((List)service.getServiceOutput().getDatasets(), request, null));
        }
    }
}

