/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.DataAdapter;
import com.kony.adapter.connection.ConnectionProperties;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.handler.AsyncHandler;
import com.kony.adapter.model.Context;
import com.kony.dataadapter.annotations.adapter.AnnotationAdapter;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.common.MWConstants;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterUtil;
import com.konylabs.middleware.connectors.dataadapter.codeless.AbstractAdapterBuilder;
import com.konylabs.middleware.connectors.dataadapter.codeless.AdapterBuilderFactory;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataAdapterTask {
    private static final Logger LOGGER = Logger.getLogger(DataAdapterTask.class);
    private AppCache konyAppCache;
    private DataAdapterCache dataAdapterCache;

    public DataAdapterTask() {
    }

    public DataAdapterTask(AppCache konyAppCache, DataAdapterCache dataAdapterCache) {
        this.konyAppCache = konyAppCache;
        this.dataAdapterCache = dataAdapterCache;
    }

    public void performJarUpdateTask() {
        Set<AppVersion> appVersionkeySet = this.dataAdapterCache.getAppVerOperationIDConnectionHashMap().keySet();
        Set<AppVersion> UpdatedOrCreatedServices = this.dataAdapterCache.getUpdatedOrCreatedServices();
        appVersionkeySet.removeAll(UpdatedOrCreatedServices);
        if (this.hasCodeLessAdapters(this.dataAdapterCache.getHashAdapterBasePackage())) {
            this.initializeAll();
        }
    }

    public boolean hasCodeLessAdapters(Map<String, String> hashAdapterBasePackage) {
        return !MWConstants.CODEBASED_ADAPTERS_BASEPACKAGE.containsAll(hashAdapterBasePackage.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDestroyTask() throws MiddlewareException, DataAdapterException {
        Iterator<AppVersion> iterator = this.dataAdapterCache.getUpdatedAssets().iterator();
        while (iterator.hasNext()) {
            AppVersion appVersion = iterator.next();
            try {
                this.destroyAdapterIfExists(appVersion);
            }
            catch (Error e) {
                LOGGER.error((Object)"Error occurred while destroying Data adapter", (Throwable)e);
            }
            finally {
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servicesIntializationTask() {
        Set<AppVersion> UpdatedOrCreatedServices = this.dataAdapterCache.getUpdatedOrCreatedServices();
        Iterator<AppVersion> iterator = UpdatedOrCreatedServices.iterator();
        while (iterator.hasNext()) {
            AppVersion appVersion = iterator.next();
            try {
                this.initializeDataAdapter(appVersion);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error occurred while initializing Data adapter", (Throwable)e);
            }
            catch (Error error) {
                LOGGER.error((Object)"Error occurred while initializing Data adapter", (Throwable)error);
            }
            finally {
                iterator.remove();
            }
        }
    }

    public void destroyAdapterIfExists(AppVersion appVersion) {
        if (this.dataAdapterCache.hasOperationKey(appVersion)) {
            try {
                ApplicationMetadata appMeta = (ApplicationMetadata)this.konyAppCache.getAppMetadata(appVersion);
                if (appMeta != null) {
                    for (String serviceName : appMeta.getServiceNames()) {
                        ServiceMetadata servMeta = appMeta.getServiceMetadata(serviceName);
                        if (!DataAdapterUtil.isCustomAdapterInitializableService(servMeta)) continue;
                        String adapterBasePackage = (String)servMeta.getServiceConfigParamMap().get("basepackage");
                        AnnotationAdapter adapter = MiddlewareClassloaderFactory.getClassLoaderManager().getDataAdapterInstance(adapterBasePackage);
                        this.destroyAdapter((DataAdapter)adapter, appVersion, servMeta.getService().getId(), servMeta.getProcessedConfigMap());
                    }
                } else {
                    this.dataAdapterCache.getAppVerOperationIDConnectionHashMap().remove(appVersion);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Failed to destroy Adapter", (Throwable)e);
            }
        }
    }

    public void initializeDataAdapter(AppVersion appVersion) throws MiddlewareException {
        ApplicationMetadata appMetadata = (ApplicationMetadata)this.konyAppCache.getAppMetadata(appVersion);
        HashSet<String> oldOperationIDs = new HashSet<String>();
        if (this.dataAdapterCache.hasOperationKey(appVersion)) {
            oldOperationIDs.addAll(this.dataAdapterCache.getOperationIDConnectionHashMap(appVersion).keySet());
        }
        Map<String, Map<String, Object>> assetTypeMap = appMetadata.getAssetMap();
        Map<String, Object> assetMap = null;
        if (assetTypeMap != null && assetTypeMap.size() > 0) {
            assetMap = assetTypeMap.values().iterator().next();
        }
        for (String serviceName : appMetadata.getServiceNames()) {
            ServiceMetadata servMeta = appMetadata.getServiceMetadata(serviceName);
            if (!DataAdapterUtil.isCustomAdapterInitializableService(servMeta)) continue;
            this.initializeService(appVersion, oldOperationIDs, assetMap, servMeta);
        }
        this.checkForDeletedServices(oldOperationIDs, appVersion);
    }

    public void initializeService(AppVersion appVersion, Set<String> oldOperationIDs, Map<String, Object> assetMap, ServiceMetadata servMeta) throws MiddlewareException {
        MiddlewareClassloaderManager middlewareClassloaderManager = MiddlewareClassloaderFactory.getClassLoaderManager();
        HashMap<String, Object> connMap = new HashMap<String, Object>();
        HashMap<String, Object> connMapForHash = new HashMap<String, Object>();
        AbstractAdapterBuilder abstractAdapterBuilder = AdapterBuilderFactory.getAdapter(assetMap, servMeta, this.konyAppCache);
        DataAdapter adapter = abstractAdapterBuilder.withMiddlwareClassloader(middlewareClassloaderManager).withAppVersion(appVersion).withConnMap(connMap).withConnHashMap(connMapForHash).build();
        try {
            abstractAdapterBuilder.getConnectionProperties(adapter);
            servMeta.getProcessedConfigMap().put("AdapterKey", adapter);
            String hash = DataAdapterUtil.getConnectionPropertiesHashValue(new ConnectionProperties(connMapForHash));
            String operationID = servMeta.getService().getId();
            if (this.dataAdapterCache.hasAppVerOperationIDConnectionHashMap(appVersion, operationID)) {
                if (oldOperationIDs != null) {
                    oldOperationIDs.remove(operationID);
                }
                this.updateOperationInitialize(adapter, connMap, hash, appVersion, servMeta);
            } else {
                this.newOperationInitialize(adapter, connMap, hash, appVersion, servMeta);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Adapter Initialize failed", (Throwable)e);
        }
    }

    private void updateOperationInitialize(DataAdapter adapter, Map<String, Object> connMap, String hash, AppVersion appVersion, ServiceMetadata servMeta) throws DataAdapterException {
        String oldHash = this.dataAdapterCache.getOperationIDConnectionHashMap(appVersion).get(servMeta.getService().getId());
        if (!hash.equals(oldHash)) {
            this.destroyAdapter(adapter, appVersion, servMeta.getService().getId(), servMeta.getProcessedConfigMap());
            this.newOperationInitialize(adapter, connMap, hash, appVersion, servMeta);
        } else {
            servMeta.getProcessedConfigMap().put("connectionHash", this.dataAdapterCache.getConnectionHashConnectionInfoKeyMap().get(hash));
        }
    }

    private void checkForDeletedServices(Set<String> oldOperationIDs, AppVersion appVersion) {
        if (oldOperationIDs != null && !oldOperationIDs.isEmpty()) {
            for (String operationID : oldOperationIDs) {
                String hash = this.dataAdapterCache.getOperationIDConnectionHashMap(appVersion).get(operationID);
                DataAdapter adapter = DataAdapterUtil.getAdapterByBasePackage(this.dataAdapterCache.getHashAdapterBasePackage().get(hash));
                this.destroyAdapter(adapter, appVersion, operationID, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAdapter(DataAdapter adapter, AppVersion appVersion, String serviceName, Map<String, Object> ProcessedConfigMap) {
        if (this.dataAdapterCache.getOperationIDConnectionHashMap(appVersion).containsKey(serviceName)) {
            String hash = this.dataAdapterCache.getOperationIDConnectionHashMap(appVersion).get(serviceName);
            this.dataAdapterCache.getOperationIDConnectionHashMap(appVersion).remove(serviceName);
            if (this.dataAdapterCache.getCountOfConnectionPropsHash(hash) == 1) {
                try {
                    this.executedestroy(adapter, this.dataAdapterCache.getConnectionHashConnectionInfoKeyMap().get(hash));
                }
                finally {
                    this.dataAdapterCache.removeHashCountMap(hash);
                    this.dataAdapterCache.getHashAdapterBasePackage().remove(hash);
                    this.dataAdapterCache.getConnectionHashConnectionInfoKeyMap().remove(hash);
                    if (ProcessedConfigMap != null && ProcessedConfigMap.containsKey("ConnectionInfoKey")) {
                        ProcessedConfigMap.remove("ConnectionInfoKey");
                    }
                }
            } else {
                this.dataAdapterCache.decrementHashCountMap(hash);
            }
        }
        if (this.dataAdapterCache.getOperationIDConnectionHashMap(appVersion).isEmpty()) {
            this.dataAdapterCache.getAppVerOperationIDConnectionHashMap().remove(appVersion);
        }
    }

    private void executedestroy(DataAdapter adapter, String connectionInfoKey) {
        AsyncHandler<DataAdapter> responseHandler = new AsyncHandler<DataAdapter>(){

            public void onSuccess(DataAdapter response, Context context) {
                LOGGER.debug((Object)"Succesfully executed the destroy on data adapter");
            }

            public void onError(DataAdapterException exception, Context context) {
                LOGGER.error((Object)"Error occurred while executing the data adapter destroy operation ", (Throwable)exception);
            }
        };
        try {
            Context context = new Context();
            context.put("ConnectionInfoKey", (Object)connectionInfoKey);
            adapter.destroy(context, (AsyncHandler)responseHandler);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurred while destroying the data adapter", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAll() {
        HashMap<AppVersion, Map<String, String>> appVerOperationIDConnectionHashMap = new HashMap<AppVersion, Map<String, String>>();
        HashMap<String, String> hashAdapterBasePackage = new HashMap<String, String>();
        HashSet<AppVersion> updatedAssets = new HashSet<AppVersion>();
        HashSet<AppVersion> updatedOrCreatedServices = new HashSet<AppVersion>();
        HashMap<String, String> connectionHashConnectionInfoKeyMap = new HashMap<String, String>();
        HashMap<String, Integer> hashCountMap = new HashMap<String, Integer>();
        hashCountMap.putAll(this.dataAdapterCache.getHashCountMap());
        connectionHashConnectionInfoKeyMap.putAll(this.dataAdapterCache.getConnectionHashConnectionInfoKeyMap());
        hashAdapterBasePackage.putAll(this.dataAdapterCache.getHashAdapterBasePackage());
        updatedAssets.addAll(this.dataAdapterCache.getUpdatedAssets());
        updatedOrCreatedServices.addAll(this.dataAdapterCache.getUpdatedOrCreatedServices());
        appVerOperationIDConnectionHashMap.putAll(this.dataAdapterCache.getAppVerOperationIDConnectionHashMap());
        this.dataAdapterCache.clear();
        try {
            for (Map.Entry appVerOpEntry : appVerOperationIDConnectionHashMap.entrySet()) {
                AppVersion appVersion = (AppVersion)appVerOpEntry.getKey();
                Map operationIDHash = (Map)appVerOpEntry.getValue();
                ApplicationMetadata appMeta = (ApplicationMetadata)this.konyAppCache.getAppMetadata(appVersion);
                Map<String, Map<String, Object>> assetTypeMap = appMeta.getAssetMap();
                Map<String, Object> assetMap = null;
                if (assetTypeMap != null && assetTypeMap.size() > 0) {
                    assetMap = assetTypeMap.values().iterator().next();
                }
                for (Map.Entry operationIDHashEntry : operationIDHash.entrySet()) {
                    String operationID = (String)operationIDHashEntry.getKey();
                    String hash = (String)operationIDHashEntry.getValue();
                    String basePackage = this.dataAdapterCache.getHashAdapterBasePackage().get(hash);
                    if (!MWConstants.CODEBASED_ADAPTERS_BASEPACKAGE.contains(basePackage)) {
                        ServiceMetadata serviceMetadata = appMeta.getServiceMetadata(operationID);
                        if (!DataAdapterUtil.isCustomAdapterInitializableService(serviceMetadata)) continue;
                        try {
                            this.initializeService(appVersion, null, assetMap, serviceMetadata);
                        }
                        catch (MiddlewareException e) {
                            LOGGER.error((Object)"serviceInitialization failed", (Throwable)e);
                        }
                        continue;
                    }
                    this.dataAdapterCache.putappVerOperationIDConnectionHashMap(appVersion, operationID, hash);
                    this.dataAdapterCache.putHashCountMap(hash, (Integer)hashCountMap.get(hash));
                    this.dataAdapterCache.putHashAdapterBasePackage(hash, basePackage);
                    this.dataAdapterCache.putConnectionHashConnectionInfoKeyMap(hash, (String)connectionHashConnectionInfoKeyMap.get(hash));
                }
            }
        }
        finally {
            this.dataAdapterCache.getUpdatedAssets().addAll(updatedAssets);
            this.dataAdapterCache.getUpdatedOrCreatedServices().addAll(updatedOrCreatedServices);
            appVerOperationIDConnectionHashMap.clear();
            updatedAssets.clear();
            updatedOrCreatedServices.clear();
            hashAdapterBasePackage.clear();
            connectionHashConnectionInfoKeyMap.clear();
            hashCountMap.clear();
        }
    }

    private void newOperationInitialize(DataAdapter adapter, Map<String, Object> connMap, String hash, AppVersion appVersion, ServiceMetadata servMeta) throws DataAdapterException {
        if (this.dataAdapterCache.hasConnectionHashConnectionInfoKey(hash)) {
            this.newOperationInitializeWithExistingConnProps(hash, appVersion, servMeta);
        } else {
            this.newOperationInitializeWithNewConnProps(adapter, connMap, hash, appVersion, servMeta);
        }
    }

    private void newOperationInitializeWithNewConnProps(final DataAdapter adapter, Map<String, Object> connMap, final String hash, final AppVersion appVersion, final ServiceMetadata servMeta) throws DataAdapterException {
        AsyncHandler<DataAdapter> asyncHandler = new AsyncHandler<DataAdapter>(){

            public void onSuccess(DataAdapter response, Context context) {
                LOGGER.debug((Object)"Succesfully executed the data adapter initialize");
                String connectionInfoKey = (String)context.get("ConnectionInfoKey");
                DataAdapterTask.this.dataAdapterCache.getConnectionHashConnectionInfoKeyMap().put(hash, connectionInfoKey);
                DataAdapterTask.this.dataAdapterCache.getHashAdapterBasePackage().put(hash, (String)((AnnotationAdapter)adapter).getAnnotationMetadataStore().getBasePackageList().get(0));
                DataAdapterTask.this.dataAdapterCache.putappVerOperationIDConnectionHashMap(appVersion, servMeta.getService().getId(), hash);
                DataAdapterTask.this.dataAdapterCache.putHashCountMap(hash, 1);
                servMeta.getProcessedConfigMap().put("ConnectionInfoKey", DataAdapterTask.this.dataAdapterCache.getConnectionHashConnectionInfoKeyMap().get(hash));
            }

            public void onError(DataAdapterException exception, Context context) {
                LOGGER.error((Object)"Error occurred while executing the data adapter initialize ", (Throwable)exception);
            }
        };
        adapter.initialize(new ConnectionProperties(connMap), new Context(), (AsyncHandler)asyncHandler);
    }

    private void newOperationInitializeWithExistingConnProps(String hash, AppVersion appVersion, ServiceMetadata servMeta) {
        this.dataAdapterCache.putappVerOperationIDConnectionHashMap(appVersion, servMeta.getService().getId(), hash);
        this.dataAdapterCache.incrementHashCountMap(hash);
        servMeta.getProcessedConfigMap().put("ConnectionInfoKey", this.dataAdapterCache.getConnectionHashConnectionInfoKeyMap().get(hash));
    }

    public void destroyAll(Map<String, AnnotationAdapter> adapterinstancebybasepackage) {
        for (Map.Entry<String, AnnotationAdapter> adapterinstancebybasepackageEntry : adapterinstancebybasepackage.entrySet()) {
            try {
                DataAdapter adapter = (DataAdapter)adapterinstancebybasepackageEntry.getValue();
                this.executedestroy(adapter, null);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error occurred while executing the data adapter destroy ", (Throwable)e);
            }
        }
    }
}

