/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.DataAdapter;
import com.kony.adapter.DataAdapterFactory;
import com.kony.adapter.annotations.connection.ConnectionInputProperty;
import com.kony.adapter.connection.ConnectionProperties;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.metadata.model.ConnectionInput;
import com.kony.adapter.metadata.model.ConnectionInputGroupMetadata;
import com.kony.adapter.metadata.model.ConnectionInputPropertyMetadata;
import com.kony.adapter.metadata.model.ConnectionPropertyDescriptor;
import com.kony.api.auth.exceptions.InvalidTokenException;
import com.kony.api.auth.jwt.common.TokenSerDe;
import com.kony.api.common.IToken;
import com.kony.dataadapter.annotations.adapter.ConnectionPropertyContainer;
import com.kony.dataadapter.annotations.adapter.DefaultAdapterInvocationProperties;
import com.kony.dataadapter.annotations.utilities.HashUtil;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterTask;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.identityproviders.MBaaSIdentityProvider;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class DataAdapterUtil {
    private static final Logger LOGGER = Logger.getLogger(DataAdapterUtil.class);

    public static String getConnectionPropertiesHashValue(ConnectionProperties connectionProperties) {
        return HashUtil.digest((String)connectionProperties.toString());
    }

    public static boolean isDataAdapterConnectorOrStorageConnector(String serviceType) {
        return MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.dataAdapterConnector.name().equals(serviceType) || MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.storageConnector.name().equals(serviceType);
    }

    public static DataAdapter getAdapterByBasePackage(String adapterBasePackage) {
        if (adapterBasePackage != null) {
            MiddlewareClassloaderManager middlewareClassloaderManager = MiddlewareClassloaderFactory.getClassLoaderManager();
            try {
                return middlewareClassloaderManager.getDataAdapterInstance(adapterBasePackage);
            }
            catch (MiddlewareException e) {
                LOGGER.error((Object)"Error occurred while getAdapterByBasePackage", (Throwable)e);
            }
        }
        return null;
    }

    public static String getConfigParam(ServiceMetadata serviceMetadata, String paramName) {
        return (String)serviceMetadata.getServiceConfigParamMap().get(paramName);
    }

    public static void addStorageConnectionProperties(ServiceMetadata servMeta, Map<String, Object> connMap, Map<String, Object> connMapForHash) {
        if (MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.storageConnector.name().equals(servMeta.getService().getServiceType())) {
            DataAdapterUtil.updateConnPropMap(servMeta, connMap);
            if (connMapForHash != null) {
                DataAdapterUtil.updateConnPropMap(servMeta, connMapForHash);
            }
        }
    }

    public static void populateConnectionInputGroupMetadata(List<ConnectionInput> conInputMetadataList, Map<String, ?> config, Map<String, Object> connMap, Map<String, Object> assetMap, Map<String, Object> sharedAssetMap, Map<String, Object> connMapForHash, AppVersion appVersion) throws DataAdapterConnectorException {
        for (ConnectionInput conInput : conInputMetadataList) {
            if (conInput instanceof ConnectionInputPropertyMetadata) {
                DataAdapterUtil.populateConnectionInputPropertyMetadata((ConnectionInputPropertyMetadata)conInput, config, connMap, assetMap, sharedAssetMap, connMapForHash, appVersion);
                continue;
            }
            if (!(conInput instanceof ConnectionInputGroupMetadata)) continue;
            List conInputList = ((ConnectionInputGroupMetadata)conInput).getConnectionInputList();
            DataAdapterUtil.populateConnectionInputGroupMetadata(conInputList, config, connMap, assetMap, sharedAssetMap, connMapForHash, appVersion);
        }
    }

    public static Map<String, Object> addDynamicConnectionProperties(ServiceMetadata servMeta, DefaultAdapterInvocationProperties invocationProperties, Map<String, Object> connMap, Map<String, Object> connMapForHash) throws DataAdapterException {
        Map<String, Object> dynamicConnProps = DataAdapterUtil.prepareConnectionProperties(invocationProperties, servMeta);
        connMap.putAll(dynamicConnProps);
        connMapForHash.putAll(dynamicConnProps);
        return dynamicConnProps;
    }

    public static InputStream getAdapterZipStream(Map<String, Object> assetMap, ServiceMetadata servMeta, AppCache konyAppCache) {
        Map sharedAssetMap = konyAppCache.getSharedAssetMapByType("DATAADAPTER");
        String assetName = DataAdapterUtil.getDataAdapterAssetName(servMeta);
        if (assetMap != null && assetMap.containsKey(assetName)) {
            return new ByteArrayInputStream((byte[])assetMap.get(assetName));
        }
        if (sharedAssetMap != null && sharedAssetMap.containsKey(assetName)) {
            return new ByteArrayInputStream((byte[])sharedAssetMap.get(assetName));
        }
        return null;
    }

    private static void populateConnectionInputPropertyMetadata(ConnectionInputPropertyMetadata conInputPropertyMeta, Map<String, ?> config, Map<String, Object> connMap, Map<String, Object> assetMap, Map<String, Object> sharedAssetMap, Map<String, Object> connMapForHash, AppVersion appVersion) throws DataAdapterConnectorException {
        Object configValue = config.get(conInputPropertyMeta.getName());
        if (configValue instanceof Object && connMapForHash != null) {
            connMapForHash.put(conInputPropertyMeta.getName(), configValue);
        }
        if (DataAdapterUtil.isConfigParamOfFileType(conInputPropertyMeta)) {
            if (configValue instanceof String && ((String)configValue).isEmpty()) {
                configValue = "";
            } else if (assetMap != null && assetMap.get(configValue) != null) {
                if (appVersion != null) {
                    connMapForHash.put(conInputPropertyMeta.getName(), configValue + "|" + appVersion.toString());
                }
                configValue = new ByteArrayInputStream((byte[])assetMap.get(configValue));
            } else if (sharedAssetMap != null && sharedAssetMap.containsKey(configValue)) {
                if (appVersion != null) {
                    connMapForHash.put(conInputPropertyMeta.getName(), configValue + "|" + appVersion.toString());
                }
                configValue = new ByteArrayInputStream((byte[])sharedAssetMap.get(configValue));
            } else if (configValue != null) {
                throw new DataAdapterConnectorException(DataAdapterConnectorException.ASSET_NOT_FOUND_ERROR, "asset not found with key:" + configValue);
            }
        }
        if (configValue != null) {
            connMap.put(conInputPropertyMeta.getName(), configValue);
        }
    }

    private static boolean isConfigParamOfFileType(ConnectionInputPropertyMetadata conInputPropertyMeta) {
        String fieldType = conInputPropertyMeta.getUiFieldType() == null ? null : conInputPropertyMeta.getUiFieldType().name();
        return ConnectionInputProperty.UIFieldType.FILE.name().equalsIgnoreCase(fieldType);
    }

    public static void performAdapterIntialization(AppCache konyAppCache, DataAdapterCache dataAdapterCache) {
        if (dataAdapterCache.isJarRefresh()) {
            try {
                new DataAdapterTask(konyAppCache, dataAdapterCache).performJarUpdateTask();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error occurred while performJarUpdateTask", (Throwable)e);
            }
            finally {
                dataAdapterCache.setJarRefresh(false);
            }
        }
        try {
            if (!dataAdapterCache.getUpdatedAssets().isEmpty()) {
                new DataAdapterTask(konyAppCache, dataAdapterCache).performDestroyTask();
            }
        }
        catch (DataAdapterException | MiddlewareException e) {
            LOGGER.error((Object)"Error occurred while destroying the Data adapter", e);
        }
        new DataAdapterTask(konyAppCache, dataAdapterCache).servicesIntializationTask();
    }

    public static boolean isCustomAdapterInitializableService(ServiceMetadata servMeta) {
        return DataAdapterUtil.isDataAdapterConnectorOrStorageConnector(servMeta.getService().getServiceType()) && DataAdapterUtil.getConfigParam(servMeta, "adaptertype").equalsIgnoreCase(DataAdapterFactory.DataAdapterType.CUSTOM.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCodeless(Map<String, Object> assetMap, ServiceMetadata servMeta, AppCache konyAppCache) throws MiddlewareException {
        ZipInputStream zin;
        InputStream stream;
        block5: {
            boolean bl;
            block6: {
                stream = null;
                zin = null;
                try {
                    ZipEntry entry;
                    stream = DataAdapterUtil.getAdapterZipStream(assetMap, servMeta, konyAppCache);
                    if (!FilenameUtils.isExtension((String)DataAdapterUtil.getDataAdapterAssetName(servMeta), (String)"zip")) break block5;
                    zin = new ZipInputStream(stream);
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().equals("properties.json")) continue;
                        bl = true;
                        break block6;
                    }
                    break block5;
                }
                catch (IOException e) {
                    try {
                        throw new MiddlewareException("null", e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(zin);
                        IOUtils.closeQuietly((InputStream)stream);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)zin);
            IOUtils.closeQuietly((InputStream)stream);
            return bl;
        }
        IOUtils.closeQuietly(zin);
        IOUtils.closeQuietly((InputStream)stream);
        return false;
    }

    public static String getPuidFromClaimsToken(String claimsToken) {
        if (StringUtils.isNotBlank((CharSequence)claimsToken)) {
            try {
                IToken iToken = TokenSerDe.deserializeToken((String)claimsToken);
                Object value = iToken.getClaim("_puid");
                return value != null ? String.valueOf(value) : null;
            }
            catch (InvalidTokenException e) {
                LOGGER.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    private static Map<String, Object> prepareConnectionProperties(DefaultAdapterInvocationProperties invocationProperties, ServiceMetadata servMeta) {
        LinkedHashMap<String, Object> dynamicConnProperties = new LinkedHashMap<String, Object>();
        if (invocationProperties == null) {
            return dynamicConnProperties;
        }
        ConnectionPropertyContainer connPropertyContainer = invocationProperties.getConnectionManager();
        if (connPropertyContainer != null && connPropertyContainer.getConnectionProperties() != null) {
            for (ConnectionPropertyDescriptor property : connPropertyContainer.getConnectionProperties()) {
                String value = DataAdapterUtil.getConfigParam(servMeta, property.getName());
                if ((value = (String)StringUtils.defaultIfEmpty((CharSequence)value, (CharSequence)property.getDefaultValue())) == null) continue;
                dynamicConnProperties.put(property.getName(), value);
            }
        }
        return dynamicConnProperties;
    }

    private static String getDataAdapterAssetName(ServiceMetadata servMeta) {
        String assetName = DataAdapterUtil.getConfigParam(servMeta, "zipName");
        return StringUtils.isBlank((CharSequence)assetName) ? DataAdapterUtil.getConfigParam(servMeta, "ramlStream") : assetName;
    }

    private static void updateConnPropMap(ServiceMetadata servMeta, Map<String, Object> connMap) {
        String advancedSettings = "{\"lastupdatetimestamp\":\"LastUpdatedDateTime\"}";
        connMap.put("maxPoolSize", servMeta.getServiceConfigParamMap().get("maxPoolSize"));
        connMap.put("connectionTimeout", servMeta.getServiceConfigParamMap().get("connectionTimeout"));
        connMap.put("advancedSettings", advancedSettings);
    }

    private DataAdapterUtil() {
    }
}

