/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.DataAdapter;
import com.kony.adapter.DataAdapterFactory;
import com.kony.adapter.connection.ConnectionProperties;
import com.kony.adapter.criteria.BatchContext;
import com.kony.adapter.criteria.BufferBatchContext;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.handler.AsyncHandler;
import com.kony.adapter.metadata.model.ConnectionInputMetadata;
import com.konylabs.middleware.connectors.dataadapter.AbstractOperand;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterAsyncHandler;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterUtil;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class InitializingOperand
extends AbstractOperand<DataAdapter> {
    private final Map<String, Object> connMap = new HashMap<String, Object>();

    @Override
    protected void preExecuteStep(Result result, AsyncHandler<Result> asyncHandler) throws DataAdapterException {
        this.dataAdapterAsyncHandler = new DataAdapterAsyncHandler<DataAdapter>(this, asyncHandler);
        String adapterType = this.getDataAdapterData().getAdapterType();
        ServiceMetadata serviceMetadata = this.getDataAdapterData().getServiceMetadata();
        if (adapterType.equals(DataAdapterFactory.DataAdapterType.CUSTOM.toString()) && serviceMetadata.getProcessedConfigMap().containsKey("ConnectionInfoKey")) {
            this.getDataAdapterData().getContext().put("ConnectionInfoKey", serviceMetadata.getProcessedConfigMap().get("ConnectionInfoKey"));
        } else {
            ConnectionInputMetadata loginInputMetadata;
            ConnectionInputMetadata connectionInputMetadata = this.getDataAdapterData().getDataAdapter().getMetaDataExplorer().getConnectionInputMetadata();
            Map<String, Map<String, Object>> assetTypeMap = serviceMetadata.getAppMetadata().getAssetMap();
            Map<String, Object> assetMap = null;
            if (assetTypeMap != null && assetTypeMap.size() > 0) {
                assetMap = assetTypeMap.values().iterator().next();
            }
            if (connectionInputMetadata != null) {
                List conInputMetadataList = connectionInputMetadata.getConnectionInputList();
                try {
                    DataAdapterUtil.populateConnectionInputGroupMetadata(conInputMetadataList, this.getDataAdapterData().getConfig(), this.connMap, assetMap, null, null, null);
                    DataAdapterUtil.addStorageConnectionProperties(serviceMetadata, this.connMap, null);
                }
                catch (DataAdapterConnectorException e) {
                    throw new DataAdapterException(e.getMessage(), (Throwable)((Object)e));
                }
            }
            if ((loginInputMetadata = this.getDataAdapterData().getDataAdapter().getMetaDataExplorer().getLoginInputMetadata()) != null) {
                List loginProperties = loginInputMetadata.getConnectionInputList();
                try {
                    DataAdapterUtil.populateConnectionInputGroupMetadata(loginProperties, this.getDataAdapterData().getConfig(), this.connMap, assetMap, null, null, null);
                }
                catch (DataAdapterConnectorException e) {
                    throw new DataAdapterException(e.getMessage(), (Throwable)((Object)e));
                }
            }
        }
        Map<String, String> headerList = this.getDataAdapterData().getHeaderMap();
        if (headerList.size() > 0) {
            BufferBatchContext batchContext = new BufferBatchContext();
            for (Map.Entry<String, String> headerParam : headerList.entrySet()) {
                String headerName = headerParam.getKey();
                String headerValue = headerParam.getValue();
                if (!StringUtils.isNotBlank((String)headerValue)) continue;
                this.getDataAdapterData().getContext().putSessionToken(headerName, (Object)headerValue);
            }
            this.getDataAdapterData().getContext().setBatchContext((BatchContext)batchContext);
        }
    }

    @Override
    protected void executeStep() throws DataAdapterException {
        if (this.getDataAdapterData().getAdapterType().equals(DataAdapterFactory.DataAdapterType.CUSTOM.toString()) && this.getDataAdapterData().getServiceMetadata().getProcessedConfigMap().containsKey("ConnectionInfoKey")) {
            this.dataAdapterAsyncHandler.onSuccess(null, this.getDataAdapterData().getContext());
            return;
        }
        this.getDataAdapterData().getDataAdapter().initialize(new ConnectionProperties(this.connMap), this.getDataAdapterData().getContext(), (AsyncHandler)this.dataAdapterAsyncHandler);
    }

    @Override
    protected void processResults(DataAdapter dataAdapterResult) {
    }

    @Override
    protected String getOperandName() {
        return "initialize";
    }

    @Override
    protected String getErrorCode() {
        return DataAdapterConnectorException.INITIALIZE_OPERATOR_ERROR;
    }
}

