/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.handler.AsyncHandler;
import com.kony.adapter.model.BinaryContent;
import com.kony.adapter.model.BinaryContextParamType;
import com.kony.adapter.model.BinaryField;
import com.kony.adapter.model.ByteRange;
import com.konylabs.middleware.common.BinaryOperandAttributes;
import com.konylabs.middleware.connectors.dataadapter.BinaryOperand;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.BufferedInputStream;
import java.util.HashMap;

class QueryBinaryOperand
extends BinaryOperand {
    QueryBinaryOperand() {
    }

    @Override
    protected void executeStep() throws DataAdapterException {
        this.getDataAdapterData().getDataAdapter().getBinaryAdapter().read((BinaryField)this.preparedResult, this.getDataAdapterData().getContext(), (AsyncHandler)this.dataAdapterAsyncHandler);
    }

    @Override
    protected void processResults(BinaryField dataAdapterResult) throws DataAdapterException {
        if (dataAdapterResult != null && dataAdapterResult.getContent() != null) {
            BinaryContent content = dataAdapterResult.getContent();
            String type = this.getBinaryResponseType();
            if ("bytes".equals(type) || MiddlewareUtils.isResponsePassThrough(this.getDataAdapterData().getServiceMetadata().getService())) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(content.getStreamingContent());
                this.getDataAdapterData().getDataControllerResponse().setAttribute("chunkedresults_json", (Object)bufferedInputStream);
                this.sendContentRangeHeaderToDevice(dataAdapterResult);
            } else {
                this.setResultParamString(BinaryOperandAttributes.data.name(), content.getBase64Content());
            }
        }
    }

    public void sendContentRangeHeaderToDevice(BinaryField dataAdapterResult) {
        Object contentLength = dataAdapterResult.getBinaryContext().get(BinaryContextParamType.CONTENT_LENGTH);
        Object byteRange = dataAdapterResult.getBinaryContext().get(BinaryContextParamType.SERVED_BYTE_RANGE);
        ByteRange servedRange = (ByteRange)byteRange;
        if (servedRange != null) {
            StringBuilder contentRespHeader = new StringBuilder("bytes ");
            if (servedRange.getStartPosition() != null) {
                contentRespHeader.append(servedRange.getStartPosition());
            }
            contentRespHeader.append("-");
            if (servedRange.getEndPosition() != null) {
                contentRespHeader.append(servedRange.getEndPosition());
            }
            contentRespHeader.append("/").append(contentLength);
            HashMap<String, String> contentHeader = new HashMap<String, String>();
            contentHeader.put("Content-Range", contentRespHeader.toString());
            this.getDataAdapterData().getDataControllerResponse().setHeaders(contentHeader);
        }
    }

    @Override
    protected void createBinaryContent(BinaryField binaryField, Object fieldValue, BinaryContent.BINARY_CONTENT_TYPE contentType) throws DataAdapterException {
    }

    @Override
    protected String getOperandName() {
        return "read binary";
    }

    @Override
    protected String getErrorCode() {
        return DataAdapterConnectorException.READ_BINARY_OPERATOR_ERROR;
    }
}

