/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.annotations.binary.BinaryData;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.handler.AsyncHandler;
import com.kony.adapter.service.meta.ServiceMetadata;
import com.kony.adapter.service.runtime.ServiceData;
import com.kony.adapter.service.runtime.ServiceInput;
import com.kony.adapter.service.runtime.ServiceOutput;
import com.kony.adapter.service.runtime.ServiceOutputList;
import com.kony.adapter.service.runtime.ServiceOutputObject;
import com.kony.adapter.service.runtime.ServiceOutputParam;
import com.konylabs.middleware.connectors.dataadapter.AbstractOperand;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterAsyncHandler;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ServiceOperand
extends AbstractOperand<ServiceOutput> {
    private static final Logger LOGGER = Logger.getLogger(ServiceOperand.class);
    private ServiceInput inputCollection;

    @Override
    protected void preExecuteStep(Result result, AsyncHandler<Result> asyncHandler) throws DataAdapterException {
        this.dataAdapterAsyncHandler = new DataAdapterAsyncHandler<ServiceOutput>(this, asyncHandler);
        this.inputCollection = this.prepareGenericInputCollection();
    }

    @Override
    protected void executeStep() throws DataAdapterException {
        this.getDataAdapterData().getDataAdapter().invokeService((ServiceMetadata)this.getDataAdapterData().getMetadata(), this.inputCollection, this.getDataAdapterData().getContext(), this.getDataAdapterData().getCriteria(), (AsyncHandler)this.dataAdapterAsyncHandler);
    }

    @Override
    protected void processResults(ServiceOutput dataAdapterResult) throws DataAdapterException {
        if (dataAdapterResult != null) {
            if (!(dataAdapterResult instanceof ServiceOutputList)) {
                throw new DataAdapterException(DataAdapterConnectorException.SERVICE_OPERATOR_ERROR, "The top level ServiceOutput Should be of type ServiceOutputList and represent Result");
            }
            this.prepareResults((ServiceData)dataAdapterResult, this.getResult());
        }
    }

    private void prepareResults(ServiceData serviceOutput, Result results) {
        List outCollection = serviceOutput.getParamRecordDataset();
        int counter = 0;
        for (ServiceData aCollection : outCollection) {
            if (aCollection instanceof ServiceOutputList) {
                Dataset dataSet = new Dataset();
                if (StringUtils.isNotBlank((String)aCollection.getName())) {
                    dataSet.setId(aCollection.getName());
                } else {
                    String dataSetID = counter == 0 ? "records" : "records" + counter;
                    dataSet.setId(dataSetID);
                    ++counter;
                }
                this.assignDataSetToResult((ServiceOutputList)aCollection, dataSet);
                results.addDataset(dataSet);
                continue;
            }
            if (aCollection instanceof ServiceOutputObject) {
                Record record = new Record();
                record.setId("record");
                this.assignRecordToResult((ServiceOutputObject)aCollection, record);
                results.addRecord(record);
                continue;
            }
            if (!(aCollection instanceof ServiceOutputParam)) continue;
            results.addParam(this.assignParamToResult((ServiceOutputParam)aCollection));
        }
    }

    private void assignRecordToResult(ServiceOutputObject serviceOutOject, Record record) {
        List paramList = serviceOutOject.getParamRecordDataset();
        if (serviceOutOject.getName() != null && !serviceOutOject.getName().isEmpty()) {
            record.setId(serviceOutOject.getName());
        }
        for (ServiceData serviceParam : paramList) {
            if (serviceParam instanceof ServiceOutputParam) {
                record.addParam(this.assignParamToResult((ServiceOutputParam)serviceParam));
                continue;
            }
            if (serviceParam instanceof ServiceOutputObject) {
                Record record2 = new Record();
                this.assignRecordToResult((ServiceOutputObject)serviceParam, record2);
                record.addRecord(record2);
                continue;
            }
            if (!(serviceParam instanceof ServiceOutputList)) continue;
            Dataset dataSet = new Dataset();
            dataSet.setId(((ServiceOutputList)serviceParam).getName());
            this.assignDataSetToResult((ServiceOutputList)serviceParam, dataSet);
            record.addDataset(dataSet);
        }
    }

    protected Param assignParamToResult(ServiceOutputParam serviceOutParam) {
        Param param = new Param();
        param.setName(serviceOutParam.getName());
        Object value = serviceOutParam.getValue();
        if (value == null) {
            param.setValue(null);
        } else if (value instanceof List) {
            param.setObjectValue(value);
            param.setType("collection");
        } else if (value instanceof BinaryData) {
            param.setObjectValue(value);
        } else {
            param.setValue(value.toString());
        }
        return param;
    }

    private void assignDataSetToResult(ServiceOutputList serviceOutList, Dataset aDataSet) {
        List recordsList = serviceOutList.getParamRecordDataset();
        for (ServiceData aServiceOutOject : recordsList) {
            if (aServiceOutOject instanceof ServiceOutputObject) {
                Record record = new Record();
                this.assignRecordToResult((ServiceOutputObject)aServiceOutOject, record);
                aDataSet.addRecord(record);
                continue;
            }
            if (aServiceOutOject instanceof ServiceOutputList) {
                LOGGER.debug((Object)"No support for dataset in dataset");
                continue;
            }
            if (!(aServiceOutOject instanceof ServiceOutputParam)) continue;
            LOGGER.debug((Object)"No support for params in dataset");
        }
    }

    @Override
    protected String getOperandName() {
        return "service";
    }

    @Override
    protected String getErrorCode() {
        return DataAdapterConnectorException.SERVICE_OPERATOR_ERROR;
    }
}

