/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.DataAdapterFactory;
import com.kony.adapter.metadata.model.Metadata;
import com.kony.dataadapter.annotations.metadata.dynamic.DynamicEntityMetadata;
import com.kony.middleware.db.DatabaseHelper;
import com.kony.middleware.db.DatabaseHelperFactory;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterAsyncConnector;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterConnector;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterData;
import com.konylabs.middleware.connectors.dataadapter.StorageDatabaseDetails;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.impl.StorageApplicationMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.util.Map;
import org.apache.log4j.Logger;

public class StorageConnector
extends DataAdapterConnector {
    private static final Logger LOGGER = Logger.getLogger(StorageConnector.class);
    private final DatabaseHelper databaseHelper = DatabaseHelperFactory.createDatabaseHelper();

    @Override
    protected DataAdapterAsyncConnector getDataAdapterAsyncConnector() {
        return new DataAdapterAsyncConnector(){

            @Override
            protected void constructMetadata(DataAdapterData adapterData, Map<String, Object> config, Service service, DataControllerRequest request) throws DataAdapterConnectorException, ConnectorException {
                StorageConnector.this.constructMetadata(adapterData, config, service, request);
            }
        };
    }

    @Override
    protected Map<String, Object> getConfigMap(ServiceMetadata serviceMetadata, DataControllerRequest request) {
        Map<String, Object> config = super.getConfigMap(serviceMetadata, request);
        config.put("adaptertype", DataAdapterFactory.DataAdapterType.CUSTOM.toString());
        config.put("basepackage".toString(), "com.kony.rdbms");
        return config;
    }

    private void populateStorageConfiguration(Map<String, Object> config, String appId, TenantBean<AppCache> tenantBean) {
        LOGGER.debug((Object)"Populating RDBMS context configuration");
        String envProp = tenantBean.getEnvProperty(EnvironmentProperties.ENVIRONMENT_ID.name());
        StorageDatabaseDetails storageDatabaseDetails = this.databaseHelper.getStorageDatabaseDetails(appId, envProp);
        config.put("jdbcClass".toString(), storageDatabaseDetails.getDriverClass());
        config.put("jdbcUrl".toString(), storageDatabaseDetails.getJdbcURL());
        config.put("userId".toString(), storageDatabaseDetails.getUsername());
        config.put("password", storageDatabaseDetails.getPassword());
        config.put("maxPoolSize", storageDatabaseDetails.getMaxConnections());
        config.put("connectionTimeout", storageDatabaseDetails.getConnectionTimeout());
    }

    protected void constructMetadata(DataAdapterData adapterData, Map<String, Object> config, Service service, DataControllerRequest request) throws DataAdapterConnectorException {
        LOGGER.debug((Object)"Building entity metadata object for storage connector.");
        ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
        TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromDCRequest(request);
        this.populateStorageConfiguration(config, serviceMetadata.getAppId(), tenantBean);
        String objectId = (String)config.get("objectname");
        StorageApplicationMetadata appMetadata = (StorageApplicationMetadata)serviceMetadata.getAppMetadata();
        String opcode = serviceMetadata.getService().getServiceConfig().getConfigParam("opcode").getValue();
        DynamicEntityMetadata storageTableMetadata = DataAdapterConnector.OPCODE.create.toString().equals(opcode) || DataAdapterConnector.OPCODE.update.toString().equals(opcode) ? appMetadata.getStorageTableMetadata(objectId).getEntityMetadataForCreateUpdate() : appMetadata.getStorageTableMetadata(objectId).getEntityMetadata();
        adapterData.setMetadata((Metadata)storageTableMetadata);
    }
}

