/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.metadata.model.FieldType;
import com.kony.rdbms.metadata.model.ColumnMetadata;
import com.konylabs.middleware.connectors.dataadapter.StorageDatabaseDetails;
import com.konylabs.middleware.identityproviders.MBaaSIdentityProvider;
import com.konylabs.middleware.registry.vo.Application;
import com.konylabs.middleware.registry.vo.Service;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.internal.info.MigrationInfoImpl;

public class StorageConnectorUtils {
    private static final Logger LOGGER = Logger.getLogger(StorageConnectorUtils.class);
    private static Map<String, String> objectFieldTypeToDBFieldType = new HashMap<String, String>();

    public static String getDBFieldTypeFromObjectType(String key) {
        return objectFieldTypeToDBFieldType.get(key);
    }

    public static Flyway getFlyway(String jdbcURL, String databaseAdminUser, String databaseAdminPassword, String schemaName, String location) {
        Flyway flyway = new Flyway();
        if (location != null) {
            String scriptLocation = "filesystem:" + location;
            flyway.setLocations(new String[]{scriptLocation});
        }
        flyway.setSchemas(new String[]{schemaName});
        flyway.setBaselineOnMigrate(true);
        flyway.setDataSource(jdbcURL, databaseAdminUser, databaseAdminPassword, new String[0]);
        return flyway;
    }

    public static boolean isStorageAsService(Application app) {
        return app != null && app.getServices() != null && app.getServices().getService() != null && !app.getServices().getService().isEmpty() && ((Service)app.getServices().getService().get(0)).getServiceType().equalsIgnoreCase(MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.storageConnector.name());
    }

    public static Map<String, Object> readLastVersionInfoFromSchemaVersion(StorageDatabaseDetails storageDatabaseDetails, String schemaName) {
        HashMap<String, Object> columns = new HashMap<String, Object>();
        try {
            Flyway flyway = StorageConnectorUtils.getFlyway(storageDatabaseDetails.getJdbcURL(), storageDatabaseDetails.getUsername(), storageDatabaseDetails.getPassword(), schemaName, null);
            MigrationInfo[] migrationInfoArray = flyway.info().all();
            if (migrationInfoArray.length > 0) {
                MigrationInfoImpl migrationInfoOfLastVersion = (MigrationInfoImpl)migrationInfoArray[migrationInfoArray.length - 1];
                columns.put("success", migrationInfoOfLastVersion.getAppliedMigration().isSuccess());
                columns.put("version", migrationInfoOfLastVersion.getAppliedMigration().getVersion().getVersion());
                columns.put("script", migrationInfoOfLastVersion.getAppliedMigration().getScript());
                columns.put("installed_rank", migrationInfoOfLastVersion.getAppliedMigration().getInstalledRank());
            } else {
                LOGGER.error((Object)"database creation failed");
                columns.put("error_message", "database creation failed");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception occurred while connecting to storage schema : " + schemaName), (Throwable)e);
            columns.put("error_message", e.getMessage());
        }
        return columns;
    }

    public static void setJdbcTypeAndFieldType(ColumnMetadata columnMetadata, String dataType) {
        switch (dataType) {
            case "string": {
                columnMetadata.setFieldType(FieldType.STRING);
                columnMetadata.setJdbcType(12);
                break;
            }
            case "date": {
                columnMetadata.setFieldType(FieldType.DATETIME);
                columnMetadata.setJdbcType(93);
                break;
            }
            case "number": {
                columnMetadata.setFieldType(FieldType.DOUBLE);
                columnMetadata.setJdbcType(8);
                break;
            }
            case "boolean": {
                columnMetadata.setFieldType(FieldType.BOOLEAN);
                columnMetadata.setJdbcType(-7);
                break;
            }
            case "binary": {
                columnMetadata.setFieldType(FieldType.BINARY);
                columnMetadata.setJdbcType(-2);
                break;
            }
            default: {
                columnMetadata.setFieldType(FieldType.STRING);
                columnMetadata.setJdbcType(12);
            }
        }
    }

    public static String getFirstPartFromEnvGUID(String envguid) {
        if (envguid != null && envguid.contains("-")) {
            return envguid.substring(0, envguid.indexOf("-"));
        }
        return envguid;
    }

    static {
        objectFieldTypeToDBFieldType.put("autoGenerated", "isAutoGenerated");
        objectFieldTypeToDBFieldType.put("creatable", "isCreatable");
        objectFieldTypeToDBFieldType.put("sourceFieldName", "name");
        objectFieldTypeToDBFieldType.put("nullable", "isNullable");
        objectFieldTypeToDBFieldType.put("updateable", "isUpdatable");
        objectFieldTypeToDBFieldType.put("fieldlength", "length");
        objectFieldTypeToDBFieldType.put("sourceDatatype", "type");
        objectFieldTypeToDBFieldType.put("description", "description");
    }

    public static enum StorageDatabaseType {
        mysql,
        sqlserver,
        oracle,
        db2;

    }

    public static enum StoragePlaceHoldersEnum {
        KONY_STORAGE_DATA_TABLESPACE,
        KONY_STORAGE_INDEX_TABLESPACE,
        KONY_STORAGE_LOB_TABLESPACE,
        KONY_STORAGE_SQLSERVER_DEFAULT_SCHEMA;

    }
}

