/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.dataadapter.annotations.metadata.dynamic.DynamicEntityMetadata;
import com.kony.dataadapter.annotations.metadata.dynamic.EntityAttributeTypeMetadata;
import com.kony.dataadapter.annotations.metadata.dynamic.EntityTypeControllerMetadata;
import com.kony.dataadapter.annotations.metadata.dynamic.EntityTypeMetadata;
import com.kony.dataadapter.annotations.metadata.dynamic.RelationshipAttributeTypeMetadata;
import com.kony.dataadapter.annotations.metadata.dynamic.RelationshipTypeMetadata;
import com.kony.middleware.db.DatabaseHelper;
import com.kony.middleware.db.DatabaseHelperFactory;
import com.kony.rdbms.controller.TableController;
import com.kony.rdbms.metadata.model.AnnotatedTable;
import com.kony.rdbms.metadata.model.ColumnMetadata;
import com.kony.rdbms.metadata.model.RelationshipKeys;
import com.kony.rdbms.metadata.model.TableRelationships;
import com.konylabs.middleware.connectors.dataadapter.StorageConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.StorageEntityMetadata;
import com.konylabs.middleware.registry.vo.Application;
import com.konylabs.middleware.registry.vo.Field;
import com.konylabs.middleware.registry.vo.Fieldparam;
import com.konylabs.middleware.registry.vo.Keyfield;
import com.konylabs.middleware.registry.vo.ObjectGroups;
import com.konylabs.middleware.registry.vo.Objectgroup;
import com.konylabs.middleware.registry.vo.Relation;
import com.konylabs.middleware.registry.vo.Relationfield;
import com.konylabs.middleware.registry.vo.Relations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class StorageEntityMetadataBuilder {
    public static Map<String, StorageEntityMetadata> buildEntityMetadataObject(Application application, String envGuid) {
        ObjectGroups objectGroups = application.getObjectGroups();
        List objectGroupList = objectGroups.getObjectGroup();
        List objectsList = ((Objectgroup)objectGroupList.get(0)).getObject();
        DatabaseHelper databaseHelper = DatabaseHelperFactory.createDatabaseHelper();
        String schemaName = databaseHelper.getStorageSchemaName(application.getId(), envGuid);
        HashMap<String, StorageEntityMetadata> dynamicEntityMetadataMap = new HashMap<String, StorageEntityMetadata>();
        for (int i = 0; i < objectsList.size(); ++i) {
            com.konylabs.middleware.registry.vo.Object object = (com.konylabs.middleware.registry.vo.Object)objectsList.get(i);
            EntityTypeControllerMetadata entityControllerMetadata = new EntityTypeControllerMetadata(TableController.class);
            EntityAttributeTypeMetadata entityAttributeTypeMetadata = new EntityAttributeTypeMetadata(ColumnMetadata.class);
            EntityTypeMetadata entityTypeMetadata = new EntityTypeMetadata(AnnotatedTable.class, entityAttributeTypeMetadata, entityControllerMetadata);
            entityTypeMetadata.setRelationshipTypeMetadata(new RelationshipTypeMetadata(TableRelationships.class));
            entityTypeMetadata.setRelatedEntityAttributeTypesMetadata(new RelationshipAttributeTypeMetadata(RelationshipKeys.class));
            AnnotatedTable annotatedTableMetadata = StorageEntityMetadataBuilder.createEntityMetadata(object, schemaName);
            DynamicEntityMetadata dynamicEntityMetadata = new DynamicEntityMetadata((Object)annotatedTableMetadata, entityTypeMetadata);
            AnnotatedTable annotatedTableMetadataForCreateUpdate = StorageEntityMetadataBuilder.createEntityMetadata(object, schemaName);
            List columnMeatdataList = annotatedTableMetadataForCreateUpdate.getColumnMetadata();
            List<ColumnMetadata> updatedColumnMetadataList = StorageEntityMetadataBuilder.filterNonEditableColumnMetadata(columnMeatdataList);
            annotatedTableMetadataForCreateUpdate.setColumnMetadata(updatedColumnMetadataList);
            DynamicEntityMetadata dynamicEntityMetadataForCreateUpdate = new DynamicEntityMetadata((Object)annotatedTableMetadataForCreateUpdate, entityTypeMetadata);
            StorageEntityMetadata storageEntityMetadata = new StorageEntityMetadata();
            storageEntityMetadata.setEntityMetadata(dynamicEntityMetadata);
            storageEntityMetadata.setEntityMetadataForCreateUpdate(dynamicEntityMetadataForCreateUpdate);
            dynamicEntityMetadataMap.put(object.getId(), storageEntityMetadata);
        }
        for (StorageEntityMetadata storageEntityMetadata : dynamicEntityMetadataMap.values()) {
            List relationshipList = ((AnnotatedTable)storageEntityMetadata.getEntityMetadata().getDynamicMetadataObject()).getRelatedTableList();
            StorageEntityMetadataBuilder.fillRelatedChildren(dynamicEntityMetadataMap, relationshipList, false);
            List createUpdateRelationshipList = ((AnnotatedTable)storageEntityMetadata.getEntityMetadataForCreateUpdate().getDynamicMetadataObject()).getRelatedTableList();
            StorageEntityMetadataBuilder.fillRelatedChildren(dynamicEntityMetadataMap, createUpdateRelationshipList, true);
        }
        return dynamicEntityMetadataMap;
    }

    private static void fillRelatedChildren(Map<String, StorageEntityMetadata> dynamicEntityMetadataMap, List<TableRelationships> relationshipList, boolean isCreateOrUpdate) {
        if (CollectionUtils.isNotEmpty(relationshipList)) {
            for (TableRelationships relationship : relationshipList) {
                AnnotatedTable relatedOriginalTable = (AnnotatedTable)dynamicEntityMetadataMap.get(relationship.getTargetTable().getName()).getEntityMetadata().getDynamicMetadataObject();
                if (isCreateOrUpdate) {
                    relationship.getTargetTable().setColumnMetadata(StorageEntityMetadataBuilder.filterNonEditableColumnMetadata(relatedOriginalTable.getColumnMetadata()));
                    continue;
                }
                relationship.getTargetTable().setColumnMetadata(relatedOriginalTable.getColumnMetadata());
            }
        }
    }

    private static List<ColumnMetadata> filterNonEditableColumnMetadata(List<ColumnMetadata> columnMeatdataList) {
        ArrayList<ColumnMetadata> buffer = new ArrayList<ColumnMetadata>();
        for (ColumnMetadata columnMetadta : columnMeatdataList) {
            if (columnMetadta.getName().equals("CreatedDateTime") || columnMetadta.getName().equals("LastUpdatedDateTime")) continue;
            buffer.add(columnMetadta);
        }
        return buffer;
    }

    private static AnnotatedTable createEntityMetadata(com.konylabs.middleware.registry.vo.Object object, String schemaName) {
        AnnotatedTable annotatedTableMetadata = new AnnotatedTable();
        annotatedTableMetadata.setSchemaName(schemaName);
        String objectId = object.getId();
        annotatedTableMetadata.setTableName(objectId);
        annotatedTableMetadata.setDisplayName(objectId);
        List keyFields = object.getKey().getKeyField();
        ArrayList<String> keyFieldNames = new ArrayList<String>();
        for (int j = 0; j < keyFields.size(); ++j) {
            keyFieldNames.add(((Keyfield)keyFields.get(j)).getName());
        }
        List fieldList = object.getFields().getField();
        List<Object> relatedTableList = new ArrayList();
        relatedTableList = StorageEntityMetadataBuilder.getTableRelationshipsList(object, annotatedTableMetadata, schemaName);
        annotatedTableMetadata.setRelatedTableList(relatedTableList);
        ArrayList<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();
        StorageEntityMetadataBuilder.updateKeyAndNonKeyFieldMetadataList(keyFieldNames, fieldList, columnMetadataList);
        annotatedTableMetadata.setColumnMetadata(columnMetadataList);
        return annotatedTableMetadata;
    }

    public static List<TableRelationships> getTableRelationshipsList(com.konylabs.middleware.registry.vo.Object object, AnnotatedTable currentEntity, String schemaName) {
        ArrayList<TableRelationships> relationShipMetadataList = new ArrayList<TableRelationships>();
        Relations relations = object.getRelations();
        List relationsList = relations.getRelation();
        AnnotatedTable childEntity = null;
        TableRelationships relationShipMetadata = null;
        for (int i = 0; i < relationsList.size(); ++i) {
            Relation relation = (Relation)relationsList.get(i);
            childEntity = new AnnotatedTable();
            childEntity.setSchemaName(schemaName);
            childEntity.setTableName(relation.getTargetObject());
            childEntity.setDisplayName(relation.getTargetObject());
            List<RelationshipKeys> relatedKeysList = StorageEntityMetadataBuilder.getRelationKeysList(relation);
            relationShipMetadata = new TableRelationships(childEntity, relatedKeysList);
            relationShipMetadata.setCascadeDelete(relation.isCascade());
            relationShipMetadata.setRelationshipName(relation.getName());
            relationShipMetadataList.add(relationShipMetadata);
        }
        return relationShipMetadataList;
    }

    public static List<RelationshipKeys> getRelationKeysList(Relation relation) {
        ArrayList<RelationshipKeys> relatedKeysList = new ArrayList<RelationshipKeys>();
        List relationFieldList = relation.getRelationFields().getRelationField();
        Relationfield relationfield = null;
        RelationshipKeys reltaionshipKeys = null;
        ColumnMetadata sourceColumnMetadata = null;
        ColumnMetadata targetColumnMetadata = null;
        for (int i = 0; i < relationFieldList.size(); ++i) {
            relationfield = (Relationfield)relationFieldList.get(i);
            sourceColumnMetadata = new ColumnMetadata();
            sourceColumnMetadata.setName(relationfield.getSourceField());
            targetColumnMetadata = new ColumnMetadata();
            targetColumnMetadata.setName(relationfield.getTargetField());
            reltaionshipKeys = new RelationshipKeys(sourceColumnMetadata, targetColumnMetadata);
            relatedKeysList.add(reltaionshipKeys);
        }
        return relatedKeysList;
    }

    private static void updateKeyAndNonKeyFieldMetadataList(List<String> keyFieldNames, List<Field> fieldList, List<ColumnMetadata> columnMetadataList) {
        for (int j = 0; j < fieldList.size(); ++j) {
            Field field = fieldList.get(j);
            ColumnMetadata columnMetadata = StorageEntityMetadataBuilder.getCloumnMetadataObject(field, keyFieldNames);
            columnMetadata.setPrimary(keyFieldNames.contains(field.getName()));
            columnMetadataList.add(columnMetadata);
        }
    }

    private static ColumnMetadata getCloumnMetadataObject(Field field, List<String> keyFieldNames) {
        List fieldParamList = field.getFieldParam();
        HashMap<String, String> fieldVals = new HashMap<String, String>();
        for (int k = 0; k < fieldParamList.size(); ++k) {
            Fieldparam fieldParam = (Fieldparam)fieldParamList.get(k);
            String key = fieldParam.getName();
            String val = StorageConnectorUtils.getDBFieldTypeFromObjectType(key);
            if (val == null) continue;
            if (val.equalsIgnoreCase("type")) {
                fieldVals.put(val, fieldParam.getValue().toUpperCase());
                continue;
            }
            fieldVals.put(val, fieldParam.getValue());
        }
        ColumnMetadata columnMetadata = new ColumnMetadata();
        columnMetadata.setName(field.getName());
        if ("SoftDeleteFlag".equals(field.getName())) {
            columnMetadata.setSoftDelete(true);
        } else if ("LastUpdatedDateTime".equals(field.getName())) {
            columnMetadata.setLastModified(true);
        }
        columnMetadata.setDisplayName(field.getDisplayName());
        StorageConnectorUtils.setJdbcTypeAndFieldType(columnMetadata, field.getDatatype());
        columnMetadata.setColumnSize(Long.valueOf(Long.MAX_VALUE));
        columnMetadata.setColumnDecimalDigits(Integer.MAX_VALUE);
        columnMetadata.setAutoGenerated(Boolean.valueOf((String)fieldVals.get("isAutoGenerated")).booleanValue());
        columnMetadata.setCalculated(false);
        columnMetadata.setCreatable(Boolean.valueOf((String)fieldVals.get("isCreatable")).booleanValue());
        columnMetadata.setNullable(Boolean.valueOf((String)fieldVals.get("isNullable")).booleanValue());
        columnMetadata.setPrimary(keyFieldNames.contains(field.getName()));
        columnMetadata.setUpdatable(Boolean.valueOf((String)fieldVals.get("isUpdatable")).booleanValue());
        return columnMetadata;
    }
}

