/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter.codeless;

import com.kony.adapter.DataAdapter;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.metadata.model.ConnectionInputMetadata;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterUtil;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import java.util.List;
import java.util.Map;

public abstract class AbstractAdapterBuilder {
    private ServiceMetadata serviceMetadata;
    private MiddlewareClassloaderManager middlwareClassloader;
    private Map<String, Object> assetMap;
    private AppVersion appVersion;
    private AppCache konyAppCache;
    private Map<String, Object> connMap;
    private Map<String, Object> connMapForHash;

    public abstract DataAdapter build() throws MiddlewareException;

    public abstract void getConnectionProperties(DataAdapter var1) throws DataAdapterException;

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    public AbstractAdapterBuilder withServiceMetadata(ServiceMetadata serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
        return this;
    }

    public AbstractAdapterBuilder withAppVersion(AppVersion appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public AbstractAdapterBuilder withConnHashMap(Map<String, Object> connMapForHash) {
        this.connMapForHash = connMapForHash;
        return this;
    }

    public AbstractAdapterBuilder withConnMap(Map<String, Object> connMap) {
        this.connMap = connMap;
        return this;
    }

    public Map<String, Object> getConnMap() {
        return this.connMap;
    }

    public Map<String, Object> getConnMapForHash() {
        return this.connMapForHash;
    }

    public AppVersion getAppVersion() {
        return this.appVersion;
    }

    public AppCache getKonyAppCache() {
        return this.konyAppCache;
    }

    public AbstractAdapterBuilder withKonyAppCache(AppCache konyAppCache) {
        this.konyAppCache = konyAppCache;
        return this;
    }

    public MiddlewareClassloaderManager getMiddlwareClassloader() {
        return this.middlwareClassloader;
    }

    public AbstractAdapterBuilder withMiddlwareClassloader(MiddlewareClassloaderManager middlwareClassloader) {
        this.middlwareClassloader = middlwareClassloader;
        return this;
    }

    public Map<String, Object> getAssetMap() {
        return this.assetMap;
    }

    public AbstractAdapterBuilder withAssetMap(Map<String, Object> assetMap) {
        this.assetMap = assetMap;
        return this;
    }

    public void populateConnectionProperties(DataAdapter adapter, ConnectionInputMetadata connectionInputMetadata) throws DataAdapterException {
        try {
            ConnectionInputMetadata loginInputMetadata;
            if (connectionInputMetadata != null) {
                List conInputMetadataList = connectionInputMetadata.getConnectionInputList();
                DataAdapterUtil.populateConnectionInputGroupMetadata(conInputMetadataList, this.serviceMetadata.getServiceConfigParamMap(), this.connMap, this.assetMap, this.konyAppCache.getSharedAssetMapByType("DATAADAPTER"), this.connMapForHash, this.appVersion);
            }
            if ((loginInputMetadata = adapter.getMetaDataExplorer().getLoginInputMetadata()) != null) {
                List conInputMetadataList = loginInputMetadata.getConnectionInputList();
                DataAdapterUtil.populateConnectionInputGroupMetadata(conInputMetadataList, this.serviceMetadata.getServiceConfigParamMap(), this.connMap, this.assetMap, this.konyAppCache.getSharedAssetMapByType("DATAADAPTER"), this.connMapForHash, this.appVersion);
            }
        }
        catch (DataAdapterConnectorException e) {
            throw new DataAdapterException(e.getMessage(), (Throwable)((Object)e));
        }
    }
}

