/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.io;

import com.kony.api.gateway.Gateway;
import com.kony.api.gateway.GatewayException;
import com.konylabs.middleware.common.MWConstants;
import com.konylabs.middleware.connectors.io.IServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.identityproviders.MBaaSIdentityProviderUtil;
import com.konylabs.middleware.mbaas.MiddlewareMBaasUtils;
import com.konylabs.middleware.registry.vo.Header;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.registry.vo.TemplateParam;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TemplateUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractServiceInputHandler
implements IServiceInputHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractServiceInputHandler.class);
    protected static final String REQUEST_CONST = "request";
    protected static final String SESSION_CONST = "session";
    protected static final String IDENTITY_CONST = "identity";
    protected static final String CONSTANT = "constant";
    protected static final String TEMPLATE = "expression";
    protected static final String TEMPLATE_PARAM_CONST = "templateParam";
    public static final String COLLECTION = "collection";
    protected static final String BASEINPUT = "BaseInput :";
    protected static final String PARAMVALUE = "ParamValue :";

    @Override
    public Map<String, String> getHeaders(DataControllerRequest request, Map configMap, Service service) throws ConnectorException {
        HashMap<String, String> hMap;
        block9: {
            hMap = new HashMap<String, String>();
            ArrayList hParams = service.getServiceInput().getHeaders();
            if (hParams.size() <= 0) break block9;
            Header header = (Header)hParams.get(0);
            if (!MiddlewareUtils.isHeadersPassThrough(service)) {
                for (Param param : header.getParam()) {
                    String source = param.getSource();
                    String paramName = param.getName();
                    String value = param.getValue();
                    if (StringUtils.isBlank((String)source) || REQUEST_CONST.equals(source)) {
                        this.addFromRequest(request, param, paramName, value, hMap);
                        continue;
                    }
                    if (SESSION_CONST.equals(source)) {
                        this.addFromSession(request, paramName, value, service, hMap);
                        continue;
                    }
                    if (IDENTITY_CONST.equals(source)) {
                        this.addFromIdentity(request, param, paramName, value, hMap);
                        continue;
                    }
                    if (CONSTANT.equals(source)) {
                        hMap.put(paramName, this.getDefaultValueFromParam(param));
                        continue;
                    }
                    if (TEMPLATE.equals(source)) {
                        this.addFromTemplate(request, param, paramName, hMap);
                        continue;
                    }
                    String serviceId = service.getId();
                    LOGGER.error((Object)("Invalid source type " + source + " for the param " + paramName + "while preparing request for soap service"));
                    throw new ConnectorException(BASEINPUT, "9103", "Invalid source to the param for service " + serviceId);
                }
            } else {
                Map headerNames = request.getHeaderMap();
                for (Map.Entry entry : headerNames.entrySet()) {
                    if (entry.getValue() == null || MWConstants.REQUEST_HEADERS_EXCLUDE_LIST.contains(entry.getKey())) continue;
                    hMap.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
        }
        return hMap;
    }

    protected void addFromRequest(DataControllerRequest request, Param param, String paramName, String value, Map<String, String> hMap) {
        String paramValue = request.getHeader(paramName);
        if ("Cookie".equalsIgnoreCase(paramName)) {
            if (StringUtils.isNotBlank((String)request.getParameter(paramName))) {
                String string = paramValue = StringUtils.isNotBlank((String)paramValue) && paramValue.contains("cacheid") ? request.getParameter(paramName) : paramValue + "; " + request.getParameter(paramName);
            }
            if (StringUtils.isNotBlank((String)value)) {
                paramValue = value + "; " + paramValue;
            }
        }
        if (!"Cookie".equalsIgnoreCase(paramName) && StringUtils.isBlank((String)paramValue)) {
            paramValue = request.getParameter(paramName);
        }
        String val = paramValue == null ? (StringUtils.isEmpty((String)value) ? param.getDefaultValue() : value) : paramValue;
        hMap.put(paramName, val);
        MaskUtils.logDebugWithMasking((String)"Header param name", (String)paramName, (String)val);
    }

    protected void addFromSession(DataControllerRequest request, String paramName, String value, Service service, Map<String, String> hMap) throws ConnectorException {
        String serviceId = service.getId();
        Session session = request.getSession();
        if (session == null) {
            LOGGER.error((Object)("Error MW6000: Session doesn't exist where as source is mentioned as session for the param " + paramName));
            throw new ConnectorException(BASEINPUT, "6000", "Session doesnt exist where as source is mentioned as session for service " + serviceId);
        }
        String paramValue = (String)session.getAttribute(paramName);
        if (paramValue == null) {
            LOGGER.error((Object)("Error MW6001: Value in session doesn't exist where as  source is mentioned as session  " + paramName));
            throw new ConnectorException(BASEINPUT, "6001", "Value in session doesn't exist where as source is mentioned as session for service " + serviceId);
        }
        hMap.put(paramName, paramValue);
        String val = paramValue == null ? value : paramValue;
        MaskUtils.logDebugWithMasking((String)"Header param name", (String)paramName, (String)val);
    }

    protected void addFromIdentity(DataControllerRequest request, Param param, String paramName, String value, Map<String, String> hMap) throws ConnectorException {
        String paramValue;
        Gateway gateway = MiddlewareMBaasUtils.getGatewayFromDCR(request);
        Object objectValue = this.processIdentityParam(param, gateway);
        String string = paramValue = objectValue == null ? null : objectValue.toString();
        String val = paramValue == null ? (StringUtils.isEmpty((String)value) ? param.getDefaultValue() : value) : paramValue;
        hMap.put(paramName, val);
    }

    protected String getDefaultValueFromParam(Param param) {
        String paramValue = param.getSourcevalue();
        if (paramValue != null && StringUtils.isNotBlank((String)param.getDefaultValue())) {
            paramValue = param.getDefaultValue();
        }
        return paramValue;
    }

    protected void addFromTemplate(DataControllerRequest request, Param param, String paramName, Map<String, String> hMap) throws ConnectorException {
        String paramValue = param.getSourcevalue();
        if (paramValue != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            HashMap<String, Object> sessionAttributeMap = new HashMap<String, Object>();
            Map<String, Object> lowerCaseMap = MiddlewareUtils.convertToLowerCaseMap(request.getHeaderMap());
            context.put("Request", lowerCaseMap);
            Session session = request.getSession();
            Enumeration attrNames = session.getAttributeNames();
            if (attrNames != null) {
                while (attrNames.hasMoreElements()) {
                    String key = (String)attrNames.nextElement();
                    sessionAttributeMap.put(key, session.getAttribute(key));
                }
            }
            context.put("Session", sessionAttributeMap);
            String templateHeaderValue = TemplateUtils.substituteTemplate(paramName, paramValue, TEMPLATE_PARAM_CONST, context);
            hMap.put(paramName, templateHeaderValue);
        }
    }

    public Object processIdentityParam(Param param, Gateway gateway) throws ConnectorException {
        String paramValue = param.getSourcevalue() == null ? param.getValue() : param.getSourcevalue();
        try {
            return MBaaSIdentityProviderUtil.fetchIdentityToken(paramValue, gateway);
        }
        catch (GatewayException e) {
            LOGGER.error((Object)("Error in evaluating security filters while loading identity attribute for " + param.getName()));
            throw new ConnectorException(BASEINPUT, "9103", "Error in evaluating security filters while loading identity attribute for " + param.getName(), (Throwable)e);
        }
    }

    protected String fillMessage(TemplateParam tparam, Map<String, Object> inputMap, Map configMap) throws ConnectorException {
        HashMap<String, Object> evalContext = new HashMap<String, Object>();
        String tvalue = tparam.getValue();
        ArrayList paramList = tparam.getParam();
        HashMap<String, Boolean> encodeMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> escapeMap = new HashMap<String, Boolean>();
        for (Param param : paramList) {
            String paramName = param.getName();
            boolean paramEncoding = Boolean.TRUE;
            boolean paramEscape = Boolean.FALSE;
            if (paramName == null) continue;
            if (param.getEncode() != null && Boolean.FALSE.toString().equalsIgnoreCase(param.getEncode().trim())) {
                paramEncoding = Boolean.FALSE;
            }
            if (param.getEscape() != null && Boolean.TRUE.toString().equalsIgnoreCase(param.getEscape().trim())) {
                paramEscape = Boolean.TRUE;
            }
            encodeMap.put(paramName, paramEncoding);
            escapeMap.put(paramName, paramEscape);
            evalContext.put(paramName, "");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Template: " + tvalue));
            LOGGER.debug((Object)("Template Param Encoding Map: " + encodeMap));
            LOGGER.debug((Object)("Template Param Escaping Map: " + escapeMap));
        }
        if (inputMap != null && inputMap.size() > 0) {
            for (String key : inputMap.keySet()) {
                Object value = inputMap.get(key);
                if (value instanceof Dataset) {
                    tvalue = this.fillMessageForDataSet(tvalue, (Dataset)value);
                    evalContext.put(key, value);
                    continue;
                }
                if (!(value instanceof String)) continue;
                value = this.fillMessageForString(tvalue, key, (String)value, configMap, encodeMap.get(key) != null && (Boolean)encodeMap.get(key) != false, escapeMap.get(key) != null && (Boolean)escapeMap.get(key) != false);
                evalContext.put(key, value);
            }
            tvalue = MiddlewareUtils.replaceMissingDatasets(tvalue);
            LOGGER.debug((Object)("Template Param: " + tvalue));
            return TemplateUtils.substituteTemplate(tparam.getName(), tvalue, TEMPLATE_PARAM_CONST, evalContext);
        }
        return tvalue;
    }

    protected String fillMessageForDataSet(String template, Dataset dataset) {
        String tvalue = template;
        String didPattern = "(#foreach[\\s]+\\$" + dataset.getId() + ")[\\s|<]";
        String dID = "";
        int startIdx = -1;
        int didEndIdx = -1;
        Pattern pattern = Pattern.compile(didPattern);
        Matcher matcher = pattern.matcher(tvalue);
        if (matcher.find()) {
            startIdx = matcher.start();
            didEndIdx = matcher.end();
            dID = matcher.group(1);
        }
        if (startIdx != -1 && didEndIdx != -1) {
            StringBuilder str = new StringBuilder("($rec in $").append(dataset.getId()).append(".records) ");
            if (dataset.getAllRecords().size() > 0) {
                for (com.konylabs.middleware.dataobject.Param param : dataset.getRecord(0).getAllParams()) {
                    str.append(" #set( $").append(param.getName()).append(" = $rec.getParam(\"").append(param.getName()).append("\").getEscapeXMLValue()) ");
                }
                for (Dataset nestedDataset : dataset.getRecord(0).getAllDatasets()) {
                    str.append(" #set( $").append(nestedDataset.getId()).append(" = $rec.getDatasetById(\"").append(nestedDataset.getId()).append("\")) ");
                    tvalue = this.fillMessageForDataSet(tvalue, nestedDataset);
                }
            }
            tvalue = tvalue.substring(0, startIdx) + "#foreach " + str.toString() + tvalue.substring(startIdx + dID.length());
            str.delete(0, str.length());
        }
        return tvalue;
    }

    protected String fillMessageForString(String tvalue, String key, String value, Map<String, String> configMap, boolean encode, boolean escape) {
        LOGGER.debug((Object)("encode value for fillMessage String " + encode));
        String contentType = MiddlewareUtils.getContentType(configMap, "text/xml");
        if (contentType != null && contentType.contains("application/x-www-form-urlencoded")) {
            value = EncodeUtils.encode((String)value);
        }
        return value;
    }

    protected String fillMessageForParamsWithExpression(Param param, Map<String, Object> inputMap, Map configMap) throws ConnectorException {
        HashMap<String, Object> evalContext = new HashMap<String, Object>();
        String tvalue = param.getValue();
        HashMap<String, Boolean> encodeMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> escapeMap = new HashMap<String, Boolean>();
        String paramName = param.getName();
        boolean paramEncoding = Boolean.TRUE;
        boolean paramEscape = Boolean.FALSE;
        if (param.getEncode() != null && Boolean.FALSE.toString().equalsIgnoreCase(param.getEncode().trim())) {
            paramEncoding = Boolean.FALSE;
        }
        if (param.getEscape() != null && Boolean.TRUE.toString().equalsIgnoreCase(param.getEscape().trim())) {
            paramEscape = Boolean.TRUE;
        }
        encodeMap.put(paramName, paramEncoding);
        escapeMap.put(paramName, paramEscape);
        evalContext.put(paramName, "");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Template: " + tvalue));
            LOGGER.debug((Object)("Template Param Encoding Map: " + encodeMap));
            LOGGER.debug((Object)("Template Param Escaping Map: " + escapeMap));
        }
        if (inputMap != null && inputMap.size() > 0) {
            for (String key : inputMap.keySet()) {
                Object value = inputMap.get(key);
                if (value instanceof Dataset) {
                    tvalue = this.fillMessageForDataSet(tvalue, (Dataset)value);
                    evalContext.put(key, value);
                    continue;
                }
                if (!(value instanceof String)) continue;
                value = this.fillMessageForString(tvalue, key, (String)value, configMap, encodeMap.get(key) != null && (Boolean)encodeMap.get(key) != false, escapeMap.get(key) != null && (Boolean)escapeMap.get(key) != false);
                evalContext.put(key, value);
            }
            tvalue = MiddlewareUtils.replaceMissingDatasets(tvalue);
            LOGGER.debug((Object)("Template Param: " + tvalue));
            return TemplateUtils.substituteTemplate(param.getName(), tvalue, TEMPLATE_PARAM_CONST, evalContext);
        }
        return tvalue;
    }
}

