/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.io;

import com.konylabs.middleware.connectors.io.ServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.MaskUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JavaInputHandler
extends ServiceInputHandler {
    private static final Logger LOGGER = Logger.getLogger(JavaInputHandler.class);

    @Override
    public String getMessage(DataControllerRequest request, Map<String, Object> inputMap, Map configMap, Service service) throws ConnectorException {
        return null;
    }

    @Override
    public Map<String, Object> getInputMap(DataControllerRequest request, Map configMap, Service service, String endpointURL) throws ConnectorException {
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        ArrayList params = service.getServiceInput().getParams();
        this.populateValues(request, params, inputParams, endpointURL, service);
        return inputParams;
    }

    @Override
    protected void populateValues(DataControllerRequest request, ArrayList<Param> params, Map<String, Object> inputParams, String endPointUrl, Service service) throws ConnectorException {
        String serviceId = request.getParameter("serviceID");
        if (params != null) {
            int size = params.size();
            LOGGER.debug((Object)("Param Size : " + size));
            for (int i = 0; i < size; ++i) {
                Param param = params.get(i);
                String source = param.getSource();
                String paramName = param.getName();
                boolean encodeValue = false;
                LOGGER.debug((Object)("Param Source : " + source + " Name: " + paramName));
                if (StringUtils.isBlank((String)source) || "request".equals(source)) {
                    this.addFromRequest(request, param, paramName, param.getDataType(), encodeValue, endPointUrl, inputParams);
                    continue;
                }
                if ("session".equals(source)) {
                    this.addFromSession(request, param, paramName, encodeValue, endPointUrl, service, inputParams);
                    continue;
                }
                if ("identity".equals(source)) {
                    super.addFromIdentity(request, param, paramName, encodeValue, endPointUrl, inputParams);
                    continue;
                }
                LOGGER.error((Object)("MW7001: Invalid source type " + source + " for param " + param + " while preparing request for scraping service."));
                throw new ConnectorException("javaConnector", "7001", "Invalid source to the param" + paramName + " for service " + serviceId);
            }
        }
    }

    @Override
    protected void addFromRequest(DataControllerRequest request, Param param, String paramName, String dataType, boolean encodeValue, String endPointUrl, Map<String, Object> inputMap) {
        String paramValue = request.getParameter(paramName);
        MaskUtils.logDebugWithMasking((String)"ParamValue :", (String)paramName, (String)paramValue);
        if (paramValue == null && StringUtils.isNotEmpty((String)param.getDefaultValue())) {
            paramValue = param.getDefaultValue();
        }
        inputMap.put(paramName, paramValue);
    }

    @Override
    protected void addFromSession(DataControllerRequest request, Param param, String paramName, boolean encodeValue, String endPointUrl, Service service, Map<String, Object> inputMap) throws ConnectorException {
        Session session = request.getSession(false);
        String serviceId = request.getParameter("serviceID");
        if (session == null) {
            LOGGER.error((Object)("Error Code: MW6000: Session expired or doesnt exist where as source is mentioned as session for the param - " + paramName));
            throw new ConnectorException(service.getServiceType(), "6000", "Session expired or doesnt exist where as source is mentioned as session " + paramName + "  for service " + serviceId);
        }
        Object paramValue = session.getAttribute(paramName);
        MaskUtils.logDebugWithMasking((String)"ParamValue :", (String)paramName, (String)String.valueOf(paramValue));
        inputMap.put(paramName, paramValue);
    }
}

