/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.io;

import com.kony.api.gateway.Gateway;
import com.konylabs.middleware.connectors.io.AbstractServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.mbaas.MiddlewareMBaasUtils;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.registry.vo.TemplateParam;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ServiceInputHandler
extends AbstractServiceInputHandler {
    private static final Logger LOGGER = Logger.getLogger(ServiceInputHandler.class);

    @Override
    public String getMessage(DataControllerRequest request, Map<String, Object> inputMap, Map configMap, Service service) throws ConnectorException {
        ArrayList tempParams = service.getServiceInput().getTemplateParams();
        if (tempParams.size() > 0) {
            String contentType = null;
            String string = contentType = request.getParameter("content-type") != null ? request.getParameter("content-type") : request.getParameter("Content-Type");
            if (contentType == null) {
                String string2 = contentType = request.getHeader("content-type") != null ? request.getHeader("content-type") : request.getHeader("Content-Type");
            }
            if (contentType != null) {
                configMap.put("content-type", contentType);
            } else {
                Session session = request.getSession();
                contentType = (String)session.getAttribute("content-type");
                if (contentType != null) {
                    configMap.put("content-type", contentType);
                }
            }
            TemplateParam param = (TemplateParam)tempParams.get(0);
            return this.fillMessage(param, inputMap, configMap);
        }
        return null;
    }

    @Override
    public Map<String, Object> getInputMap(DataControllerRequest request, Map configMap, Service service, String endpointURL) throws ConnectorException {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        TemplateParam tparam = null;
        ArrayList tempParams = service.getServiceInput().getTemplateParams();
        if (tempParams.size() > 0) {
            tparam = (TemplateParam)tempParams.get(0);
            ArrayList params = tparam.getParam();
            this.populateValues(request, params, inputMap, endpointURL, service);
        }
        ArrayList indParams = service.getServiceInput().getParams();
        this.populateValues(request, indParams, inputMap, endpointURL, service);
        return inputMap;
    }

    protected void populateValues(DataControllerRequest request, ArrayList<Param> params, Map<String, Object> inputMap, String endPointUrl, Service service) throws ConnectorException {
        int psize = params.size();
        Param param = null;
        String source = "";
        String paramName = "";
        String paramValue = "";
        String strEncode = "";
        String dataType = "";
        boolean encodeValue = true;
        for (int j = 0; j < psize; ++j) {
            param = params.get(j);
            source = param.getSource();
            paramName = param.getName();
            paramValue = "";
            dataType = param.getDataType();
            strEncode = param.getEncode();
            encodeValue = true;
            if (strEncode != null && strEncode.length() != 0) {
                encodeValue = Boolean.parseBoolean(strEncode);
            }
            if (StringUtils.isBlank((String)source) || "request".equals(source)) {
                this.addFromRequest(request, param, paramName, dataType, encodeValue, endPointUrl, inputMap);
            } else if ("session".equals(source)) {
                this.addFromSession(request, param, paramName, encodeValue, endPointUrl, service, inputMap);
            } else if ("identity".equals(source)) {
                this.addFromIdentity(request, param, paramName, encodeValue, endPointUrl, inputMap);
            } else if ("constant".equals(source)) {
                inputMap.put(paramName, super.getDefaultValueFromParam(param));
            } else {
                String serviceId = request.getParameter("serviceID");
                LOGGER.error((Object)("Invalid source type " + source + " while preparing request for soap service"));
                throw new ConnectorException("BaseInput :", "9103", "Invalid source to the param for  " + paramName + " for service " + serviceId);
            }
            MaskUtils.logDebugWithMasking((String)"ParamValue :", (String)paramName, (String)String.valueOf(paramValue));
        }
    }

    protected void addFromRequest(DataControllerRequest request, Param param, String paramName, String dataType, boolean encodeValue, String endPointUrl, Map<String, Object> inputMap) {
        Object paramValue = "";
        if ("".equals(dataType) || "string".equals(dataType) || "date".equals(dataType) || "number".equals(dataType) || "boolean".equals(dataType)) {
            paramValue = request.getParameter(paramName);
            if (paramValue == null && StringUtils.isNotBlank((String)param.getDefaultValue())) {
                paramValue = param.getDefaultValue();
            }
            if (encodeValue && paramValue != null && StringUtils.isNotBlank((String)endPointUrl) && endPointUrl.contains("$" + paramName)) {
                paramValue = EncodeUtils.encode((String)paramValue);
            }
        } else if ("file".equals(dataType)) {
            File file = request.getUploadedFile(paramName);
            if (file != null) {
                paramValue = file;
            }
            LOGGER.debug((Object)("Param Name: " + paramName + " has a File Object"));
        } else if ("collection".equals(dataType)) {
            paramValue = request.getParameter(paramName);
            if (paramValue == null && StringUtils.isNotBlank((String)param.getDefaultValue())) {
                paramValue = param.getDefaultValue();
            }
            paramValue = MiddlewareUtils.convertJSON2Dataset((String)paramValue, paramName);
            LOGGER.debug((Object)("Param Name: " + paramName + " Dataset : " + paramValue));
        }
        MaskUtils.logDebugWithMasking((String)"ParamValue :", (String)paramName, (String)String.valueOf(paramValue));
        inputMap.put(paramName, paramValue);
    }

    protected void addFromSession(DataControllerRequest request, Param param, String paramName, boolean encodeValue, String endPointUrl, Service service, Map<String, Object> inputMap) throws ConnectorException {
        String serviceId = request.getParameter("serviceID");
        Session session = request.getSession(false);
        if (session == null) {
            LOGGER.error((Object)("Error Code: MW6000: Session expired or doesnt exist where as source is mentioned as session for the param - " + paramName));
            throw new ConnectorException(service.getServiceType(), "6000", "Session expired or doesnt exist where as source is mentioned as session " + paramName + "  for service " + serviceId);
        }
        Object paramValue = session.getAttribute(paramName);
        if (paramValue == null && StringUtils.isNotBlank((String)param.getDefaultValue())) {
            paramValue = param.getDefaultValue();
        }
        if (paramValue == null) {
            LOGGER.error((Object)("Error MW6001: Value in session doesn't exist where as  source is mentioned as session  or defaultvalue is null in service def " + paramName));
            throw new ConnectorException("BaseInput :", "6001", "Value in session doesn't exist where as  source is mentioned as session for service or defaultvalue is null in service def " + serviceId);
        }
        if (paramValue instanceof String && encodeValue && StringUtils.isNotBlank((String)endPointUrl) && endPointUrl.contains("$" + paramName)) {
            paramValue = EncodeUtils.encode((String)((String)paramValue));
        }
        inputMap.put(paramName, paramValue);
    }

    protected void addFromIdentity(DataControllerRequest request, Param param, String paramName, boolean encodeValue, String endPointUrl, Map<String, Object> inputMap) throws ConnectorException {
        Gateway gateway = MiddlewareMBaasUtils.getGatewayFromDCR(request);
        Object paramValue = super.processIdentityParam(param, gateway);
        if (paramValue == null && StringUtils.isNotBlank((String)param.getDefaultValue())) {
            paramValue = param.getDefaultValue();
        }
        if (paramValue instanceof String && encodeValue && StringUtils.isNotBlank((String)endPointUrl) && endPointUrl.contains("$" + paramName)) {
            paramValue = EncodeUtils.encode((String)((String)paramValue));
        }
        inputMap.put(paramName, paramValue);
    }
}

