/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.io;

import com.konylabs.middleware.connectors.XPathEngine;
import com.konylabs.middleware.connectors.XPathEngineImpl;
import com.konylabs.middleware.connectors.io.BaseOutputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ServiceOutputHandler
extends BaseOutputHandler {
    private static final Logger LOGGER = Logger.getLogger(ServiceOutputHandler.class);
    private static final String INT_CONST = "int";
    private static final String OPSTATUS = "opstatus";
    private static final String HTTP_STATUS_CODE = "httpStatusCode";
    private static final String STRING_CONST = "string";
    private static final String ERR_MSG = "errmsg";

    @Override
    public void processOutput(Service service, DataControllerRequest request, DataControllerResponse response, Result result) throws ConnectorException {
        block4: {
            LOGGER.debug((Object)("WSOutput - START TIME (ms): " + System.currentTimeMillis()));
            super.processOutput(service, request, response, result);
            String responseStr = response.getResponse();
            String respStr = MiddlewareUtils.maskResponse(responseStr);
            String logRes = ConfigUtility.getProperty((String)"logResponse");
            if (logRes != null && (logRes.equalsIgnoreCase("true") || logRes.equalsIgnoreCase("yes"))) {
                request.setAttribute("RESPONSE_MSG", (Object)respStr);
            }
            if (responseStr == null || responseStr.trim().length() == 0) {
                result.addParam(new Param(OPSTATUS, response.getStatusCode() == 204 ? "0" : "8005", INT_CONST));
                result.addParam(new Param(HTTP_STATUS_CODE, String.valueOf(response.getStatusCode()), INT_CONST));
                result.addParam(new Param(ERR_MSG, "empty response received", STRING_CONST));
                return;
            }
            LOGGER.debug((Object)("Response Message is " + respStr));
            try {
                responseStr = this.unescapeXML(responseStr, service);
                XPathEngineImpl entity = new XPathEngineImpl(responseStr, response.getCharsetEncoding());
                this.buildResult(service, entity, result, request, response);
            }
            catch (ConnectorException pe) {
                MiddlewareUtils.maskTrace(pe.getErrorCode(), pe.getMessage() + " for service " + service.getId(), (Exception)((Object)pe));
                result.addParam(new Param(OPSTATUS, "777777", INT_CONST));
                if (!ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) break block4;
                result.addParam(new Param(ERR_MSG, "Cannot parse. Invalid xml of service " + service.getId(), STRING_CONST));
            }
        }
        result.addParam(new Param(HTTP_STATUS_CODE, String.valueOf(response.getStatusCode()), INT_CONST));
        LOGGER.debug((Object)("WSOutput - END TIME (ms): " + System.currentTimeMillis()));
    }

    protected void buildResult(Service service, XPathEngine entity, Result result, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        try {
            List<Dataset> datasetList;
            List<Record> recordsList;
            ArrayList params = service.getServiceOutput().getParams();
            LOGGER.debug((Object)(" params - " + params.size()));
            if (params.size() > 0) {
                entity.fillParams(result, params, request);
            }
            ArrayList records = service.getServiceOutput().getRecords();
            LOGGER.debug((Object)(" records - " + records.size()));
            if (records.size() > 0 && (recordsList = entity.fillRecords(records)) != null) {
                result.addAllRecords(recordsList);
            }
            ArrayList datasets = service.getServiceOutput().getDatasets();
            LOGGER.debug((Object)(" datasets - " + datasets.size()));
            if (datasets.size() > 0 && (datasetList = entity.fillDatasets(datasets)) != null) {
                result.addAllDatasets(datasetList);
            }
            result.addParam(new Param(OPSTATUS, request.getAttribute(OPSTATUS) != null ? (String)request.getAttribute(OPSTATUS) : "0", INT_CONST));
            Param errmsgParam = result.getParamByName(ERR_MSG);
            if (errmsgParam != null && "".equals(errmsgParam.getValue())) {
                result.removeParam(errmsgParam);
            }
            if (request.getAttribute(ERR_MSG) != null && (errmsgParam == null || "".equals(errmsgParam.getValue()))) {
                result.addParam(new Param(ERR_MSG, (String)request.getAttribute(ERR_MSG), STRING_CONST));
            }
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            MaskUtils.maskTrace((String)ex.getMessage(), (Throwable)ex);
            throw new ConnectorException("plainxmlserviceConnector", "8006", "Invalid XML Response of service " + service.getId() + " " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected String unescapeXML(String responseStr, Service service) {
        if (StringUtils.isNotBlank((String)responseStr) && this.isEmbeddedXMLPresent(service)) {
            int begin = responseStr.indexOf("&lt;?xml");
            if (begin != -1) {
                int end = responseStr.indexOf("&gt;", begin);
                String beforePI = responseStr.substring(0, begin);
                String afterPI = responseStr.substring(end + 4, responseStr.length());
                responseStr = beforePI + afterPI;
            }
            responseStr = StringEscapeUtils.unescapeXml((String)responseStr);
            responseStr = responseStr.replaceAll("&#[X|x][A|a|D|d|9](0)?;", "");
            return responseStr.replaceAll("&", "&amp;");
        }
        return responseStr;
    }

    private boolean isEmbeddedXMLPresent(Service service) {
        boolean isPresent = false;
        ArrayList cparams = service.getServiceConfig().getServiceConfig();
        for (ConfigParam param : cparams) {
            if (!param.getName().equals("isembedxmlpresent")) continue;
            String value = param.getValue();
            if (!"true".equals(value)) break;
            isPresent = true;
            break;
        }
        return isPresent;
    }
}

