/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.jms;

import com.konylabs.middleware.common.PropertiesHelper;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConfigManager {
    public static final String JMS_CONSUMER_TIMEOUT = "jms.consumer.timeout";
    public static final long JMS_CONSUMER_TIMEOUT_DEFAULT = 10000L;
    public static final String JMS_DESTINATION_TYPE = "jms.destination.type";
    public static final String JMS_SOURCE_TYPE = "jms.source.type";
    public static final String JMS_DS_PROVIDERURL = "jms.ds.providerurl";
    public static final String JMS_DS_LOOKUP_FACTORY = "jms.ds.lookup.factory";
    public static final String JMS_DS_LOOKUP_DESTINATION = "jms.ds.lookup.destination";
    public static final String JMS_WMQ_HOST = "jms.wmq.host";
    public static final String JMS_WMQ_PORT = "jms.wmq.port";
    public static final String JMS_WMQ_CHANNEL = "jms.wmq.channel";
    public static final String JMS_WMQ_CONNMODE = "jms.wmq.connmode";
    public static final String JMS_WMQ_QUEUEMANAGER = "jms.wmq.queuemanager";
    public static final String JMS_WMQ_DESTINATION = "jms.wmq.destination";
    public static final String JMS_WMQ_CHANNEL_DEFAULT = "SYSTEM.DEF.SVRCONN";
    public static final String JMS_SOURCE_TYPE_LDAP = "ldap";
    public static final String JMS_SOURCE_TYPE_FSDS = "fsds";
    private static final String JMS_SOURCE_TYPE_WMQ = "wmq";
    public static final String JMS_DESTINATION_TYPE_TOPIC = "topic";
    public static final String DS_LDAP_PREFIX = "ldap://";
    private static final String DS_FS_PREFIX = "file:/";
    private static final String JMS_PROPERTIES_PREFIX = "jms_";
    public static Map<String, Properties> CACHE = new HashMap<String, Properties>();
    private static Logger LOGGER = Logger.getLogger((String)ConfigManager.class.getName());

    public static void init() {
        System.out.println("JmsConnector: Loading JMS properties file from appregistry dir...");
        String appRegDirStr = ConfigPathUtil.getMiddlewareHome() + "/middleware/middleware-bootconfig/" + ConfigUtility.getProperty((String)"appregistry.dir");
        File appRegDir = new File(appRegDirStr);
        for (File file : appRegDir.listFiles()) {
            if (!(file.getName().startsWith(JMS_PROPERTIES_PREFIX) & file.getName().endsWith("properties"))) continue;
            ConfigManager.loadConfig(file);
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private static void loadConfig(File propsFile) {
        LOGGER.debug((Object)("Loading JMS properties file: " + propsFile));
        Properties props = PropertiesHelper.loadQuietlyFromFile((File)propsFile);
        if (!ConfigManager.validateConfig(props)) {
            throw new RuntimeException("Invalid JMS properties file: " + propsFile);
        }
        CACHE.put(propsFile.getName(), props);
    }

    private static boolean validateConfig(Properties props) {
        Set<String> groups = ConfigManager.getPropertyGroups(props);
        LOGGER.debug((Object)("MQ groups found: " + groups));
        for (String group : groups) {
            if (!ConfigManager.validateRequiredProperites(props, group + JMS_SOURCE_TYPE, group + JMS_DESTINATION_TYPE)) {
                return false;
            }
            String jmsSourceType = props.getProperty(group + JMS_SOURCE_TYPE);
            if (JMS_SOURCE_TYPE_LDAP.equalsIgnoreCase(jmsSourceType) || JMS_SOURCE_TYPE_FSDS.equalsIgnoreCase(jmsSourceType)) {
                if (!ConfigManager.validateRequiredProperites(props, group + JMS_DS_PROVIDERURL, group + JMS_DS_LOOKUP_FACTORY, group + JMS_DS_LOOKUP_DESTINATION)) {
                    return false;
                }
                if (JMS_SOURCE_TYPE_LDAP.equalsIgnoreCase(jmsSourceType)) {
                    if (props.getProperty(group + JMS_DS_PROVIDERURL).startsWith(DS_LDAP_PREFIX)) continue;
                    LOGGER.debug((Object)"LDAP provider URL should start with ldap://");
                    return false;
                }
                if (props.getProperty(group + JMS_DS_PROVIDERURL).startsWith(DS_FS_PREFIX)) continue;
                LOGGER.debug((Object)"Filesystem DS provider URL should start with file:/");
                return false;
            }
            if (JMS_SOURCE_TYPE_WMQ.equalsIgnoreCase(jmsSourceType)) {
                if (ConfigManager.validateRequiredProperites(props, group + JMS_WMQ_HOST, group + JMS_WMQ_PORT, group + JMS_WMQ_QUEUEMANAGER, group + JMS_WMQ_DESTINATION)) continue;
                return false;
            }
            LOGGER.debug((Object)("Unsupported jms.source.type: " + jmsSourceType));
            return false;
        }
        return true;
    }

    public static Set<String> getPropertyGroups(Properties props) {
        HashSet<String> set = new HashSet<String>();
        Enumeration<?> keys = props.propertyNames();
        String key = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            set.add(key.split("\\.")[0] + ".");
        }
        return set;
    }

    private static boolean validateRequiredProperites(Properties props, String ... keys) {
        for (String key : keys) {
            if (!StringUtils.isEmpty((String)props.getProperty(key))) continue;
            LOGGER.debug((Object)("Required property " + key + " is empty"));
            return false;
        }
        return true;
    }
}

