/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.jms;

import com.ibm.msg.client.jms.JmsConnectionFactory;
import com.ibm.msg.client.jms.JmsFactoryFactory;
import com.konylabs.middleware.connectors.jms.ConfigManager;
import com.konylabs.middleware.connectors.jms.ConnectionObject;
import com.konylabs.middleware.exceptions.ConnectorException;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public final class JmsConnectionUtils {
    private static final String DS_FS_FACTORY = "com.sun.jndi.fscontext.RefFSContextFactory";
    private static final String DS_LDAP_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final Logger LOGGER = Logger.getLogger((String)JmsConnectionUtils.class.getName());

    public static ConnectionObject getConnectionObject(String propertiesFile, String mqConfig) throws ConnectorException {
        mqConfig = mqConfig + ".";
        File propsFile = new File(propertiesFile);
        Properties props = ConfigManager.CACHE.get(propsFile.getName());
        if (props == null) {
            LOGGER.error((Object)(propertiesFile + "Proprties not loaded at server start (is listener present in web.xml?): "));
            throw new ConnectorException("jmsConnector", "8903", "Proprties not loaded at server start: " + propertiesFile);
        }
        if (ConfigManager.getPropertyGroups(props).contains(mqConfig)) {
            String jmsSourceType = props.getProperty(mqConfig + "jms.source.type");
            if ("ldap".equalsIgnoreCase(jmsSourceType) || "fsds".equalsIgnoreCase(jmsSourceType)) {
                return JmsConnectionUtils.getConnectionObjectFromDS(props, mqConfig);
            }
            return JmsConnectionUtils.createWMQConnectionObject(props, mqConfig);
        }
        throw new ConnectorException("jmsConnector", "8904", "Invalid MQ config name: " + mqConfig);
    }

    private static ConnectionObject getConnectionObjectFromDS(Properties props, String mqConfig) throws ConnectorException {
        String providerUrl = props.getProperty(mqConfig + "jms.ds.providerurl");
        String factoryLookup = props.getProperty(mqConfig + "jms.ds.lookup.factory");
        String destLookup = props.getProperty(mqConfig + "jms.ds.lookup.destination");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", providerUrl.startsWith("ldap://") ? DS_LDAP_FACTORY : DS_FS_FACTORY);
        env.put("java.naming.provider.url", providerUrl);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            ctx = new InitialDirContext(env);
            ConnectionFactory factory = (ConnectionFactory)ctx.lookup(factoryLookup);
            Destination destination = (Destination)ctx.lookup(destLookup);
            String timeoutStr = props.getProperty(mqConfig + "jms.consumer.timeout");
            long timeout = NumberUtils.toLong((String)timeoutStr, (long)10000L);
            return new ConnectionObject(factory, destination, timeout);
        }
        catch (NamingException e) {
            LOGGER.debug((Object)"Exception while getting objects from DS", (Throwable)e);
            ConnectorException ex = new ConnectorException("jmsConnector", "8905", "Exception while getting objects from DS", (Throwable)e);
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    private static ConnectionObject createWMQConnectionObject(Properties props, String mqConfig) throws ConnectorException {
        int wmqPort = 0;
        String wmqPortStr = props.getProperty(mqConfig + "jms.wmq.port");
        try {
            wmqPort = Integer.parseInt(wmqPortStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid WMQ port: " + wmqPortStr);
        }
        try {
            JmsFactoryFactory ff = JmsFactoryFactory.getInstance((String)"com.ibm.msg.client.wmq");
            JmsConnectionFactory factory = ff.createConnectionFactory();
            factory.setStringProperty("XMSC_WMQ_HOST_NAME", props.getProperty(mqConfig + "jms.wmq.host"));
            factory.setIntProperty("XMSC_WMQ_PORT", wmqPort);
            String channel = props.getProperty(mqConfig + "jms.wmq.channel");
            if (channel == null || channel.length() == 0) {
                channel = "SYSTEM.DEF.SVRCONN";
            }
            factory.setStringProperty("XMSC_WMQ_CHANNEL", channel);
            factory.setIntProperty("XMSC_WMQ_CONNECTION_MODE", Integer.parseInt(props.getProperty(mqConfig + "jms.wmq.connmode", "0")));
            factory.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", props.getProperty(mqConfig + "jms.wmq.queuemanager"));
            Connection connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            Object destination = null;
            destination = "topic".equalsIgnoreCase(props.getProperty(mqConfig + "jms.destination.type")) ? session.createTopic(props.getProperty(mqConfig + "jms.wmq.destination")) : session.createQueue(props.getProperty(mqConfig + "jms.wmq.destination"));
            String timeoutStr = props.getProperty(mqConfig + "jms.consumer.timeout");
            long timeout = NumberUtils.toLong((String)timeoutStr, (long)10000L);
            return new ConnectionObject((ConnectionFactory)factory, (Destination)destination, timeout);
        }
        catch (JMSException e) {
            LOGGER.debug((Object)"Exception while creating WMQ objects", (Throwable)e);
            ConnectorException ex = new ConnectorException("jmsConnector", "8906", "Exception while creating WMQ objects", (Throwable)e);
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    private JmsConnectionUtils() {
    }
}

