/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.jms;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.ConnectorJsonUtils;
import com.konylabs.middleware.connectors.jms.ConnectionObject;
import com.konylabs.middleware.connectors.jms.JmsConnectionUtils;
import com.konylabs.middleware.connectors.jms.MessageUtils;
import com.konylabs.middleware.connectors.postprocessor.PostProcessUtils;
import com.konylabs.middleware.connectors.preprocessor.PreProcessUtils;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JmsConnector
implements Connector {
    public static final String JMS_CONNECTOR = "jmsConnector";
    private static final Logger LOGGER = Logger.getLogger((String)JmsConnector.class.getName());

    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        AppVersion appVersion;
        Result result;
        Map<String, Object> config;
        block20: {
            HashMap<String, Object> inputParams;
            ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
            config = MiddlewareUtils.populateConfigMap(service, serviceMetadata);
            boolean excuteService = PreProcessUtils.execute(service, config, inputParams = new ConnectorJsonUtils(JMS_CONNECTOR).processInputParam(service, request), request, response, result = new Result(), appVersion = MiddlewareUtils.getAppVersionFromService(service));
            if (!excuteService) {
                LOGGER.debug((Object)"Pre processor returned false; returning result");
                return result;
            }
            String opCode = (String)config.get("opcode");
            String propsFile = (String)config.get("propertiesfile");
            String mqConfig = (String)config.get("mqconfig");
            if (StringUtils.isBlank((String)opCode) || StringUtils.isBlank((String)propsFile) || StringUtils.isBlank((String)mqConfig)) {
                throw new ConnectorException(JMS_CONNECTOR, "8901", "JMS opcode/propertiesfile/mqconfig can't be empty");
            }
            try {
                LOGGER.debug((Object)("JMS operation - opcode: " + opCode));
                if ("send".equalsIgnoreCase(opCode)) {
                    boolean isSent = JmsConnector.sendMessage(propsFile, mqConfig, (String)inputParams.get("message"), Boolean.parseBoolean((String)inputParams.get("istransacted")));
                    if (isSent) {
                        this.buildResult(result, "Message sent successfully");
                    } else {
                        this.buildResult(result, "Message sending failed");
                    }
                    break block20;
                }
                if ("receive".equalsIgnoreCase(opCode)) {
                    Message message = JmsConnector.receiveMessage(propsFile, mqConfig, (String)inputParams.get("selector"), Boolean.parseBoolean((String)inputParams.get("istransacted")));
                    if (message != null) {
                        result = this.createResultFromJmsMessage(message);
                    } else {
                        this.buildResult(result, "Null message received or failed to receive");
                    }
                    break block20;
                }
                if ("send_receive".equalsIgnoreCase(opCode)) {
                    String mqConfigReceive = (String)config.get("mqconfig_receive");
                    Message message = JmsConnector.sendReceiveMessage(propsFile, mqConfig, mqConfigReceive, (String)inputParams.get("message"), Boolean.parseBoolean((String)inputParams.get("istransacted")));
                    if (message != null) {
                        result = this.createResultFromJmsMessage(message);
                    } else {
                        this.buildResult(result, "Null message received or failed to receive");
                    }
                    break block20;
                }
                if ("publish".equalsIgnoreCase(opCode)) {
                    boolean isSent = JmsConnector.sendMessage(propsFile, mqConfig, (String)inputParams.get("message"), Boolean.parseBoolean((String)inputParams.get("istransacted")));
                    if (isSent) {
                        this.buildResult(result, "Message sent successfully");
                    } else {
                        this.buildResult(result, "Message sending failed");
                    }
                    break block20;
                }
                if ("subscribe".equalsIgnoreCase(opCode)) {
                    Message message = JmsConnector.receiveMessage(propsFile, mqConfig, (String)inputParams.get("selector"), Boolean.parseBoolean((String)inputParams.get("istransacted")));
                    if (message != null) {
                        result = this.createResultFromJmsMessage(message);
                    } else {
                        this.buildResult(result, "Null message received or failed to receive");
                    }
                    break block20;
                }
                throw new ConnectorException(JMS_CONNECTOR, "8902", "Invalid JMS opcode: " + opCode);
            }
            catch (Exception e) {
                LOGGER.error((Object)("JMS connector exception: " + opCode), (Throwable)e);
                throw new ConnectorException(JMS_CONNECTOR, "8907", "JMS connector exception: opcode=" + opCode + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (result != null) {
            result = PostProcessUtils.execute(service, config, result, request, response, appVersion);
        }
        return result;
    }

    public static boolean sendMessage(String propertiesFile, String mqConfig, String message, boolean isTransacted) throws ConnectorException {
        ConnectionObject conObj = JmsConnectionUtils.getConnectionObject(propertiesFile, mqConfig);
        Message sentMsg = MessageUtils.send(conObj, message, isTransacted);
        return sentMsg != null;
    }

    public static Message receiveMessage(String propertiesFile, String mqConfig, String selector, boolean isTransacted) throws ConnectorException {
        ConnectionObject conObj = JmsConnectionUtils.getConnectionObject(propertiesFile, mqConfig);
        return MessageUtils.receive(conObj, selector, isTransacted);
    }

    public static Message sendReceiveMessage(String propertiesFile, String mqConfig, String mqConfigReceive, String message, boolean isTransacted) throws ConnectorException {
        ConnectionObject sendConObj = JmsConnectionUtils.getConnectionObject(propertiesFile, mqConfig);
        ConnectionObject recConObj = JmsConnectionUtils.getConnectionObject(propertiesFile, mqConfigReceive);
        Message sentMsg = MessageUtils.send(sendConObj, message, isTransacted, recConObj.destination);
        if (sentMsg == null) {
            throw new ConnectorException(JMS_CONNECTOR, "8908", "Failed to send message to: " + mqConfig);
        }
        String jmsMessageId = null;
        try {
            jmsMessageId = sentMsg.getJMSMessageID();
        }
        catch (JMSException e) {
            throw new ConnectorException(JMS_CONNECTOR, "8909", "MQ inernal error: message sent, but couldn't get message id", (Throwable)e);
        }
        return MessageUtils.receive(recConObj, "JMSCorrelationID = '" + jmsMessageId + "'", isTransacted);
    }

    private Result createResultFromJmsMessage(Message message) throws JMSException, ConnectorException {
        Result result = new Result();
        Record headers = new Record();
        headers.setId("headers");
        result.addRecord(headers);
        headers.addParam(new Param("JMSCorrelationID", message.getJMSCorrelationID(), "string"));
        headers.addParam(new Param("JMSDeliveryMode", message.getJMSDeliveryMode() + "", "string"));
        headers.addParam(new Param("JMSDestination", message.getJMSDestination().toString(), "string"));
        headers.addParam(new Param("JMSExpiration", message.getJMSExpiration() + "", "string"));
        headers.addParam(new Param("JMSMessageID", message.getJMSMessageID(), "string"));
        headers.addParam(new Param("JMSPriority", message.getJMSPriority() + "", "string"));
        headers.addParam(new Param("JMSRedelivered", String.valueOf(message.getJMSRedelivered()), "string"));
        headers.addParam(new Param("JMSReplyTo", String.valueOf(message.getJMSReplyTo()), "string"));
        headers.addParam(new Param("JMSTimestamp", message.getJMSTimestamp() + "", "string"));
        headers.addParam(new Param("JMSType", message.getJMSType(), "string"));
        headers.addParam(new Param("JMSXDeliveryCount", message.getStringProperty("JMSXDeliveryCount"), "string"));
        Record props = new Record();
        props.setId("properties");
        result.addRecord(props);
        Enumeration propNames = message.getPropertyNames();
        String propName = null;
        Object propValue = null;
        while (propNames.hasMoreElements()) {
            propName = (String)propNames.nextElement();
            propValue = message.getObjectProperty(propName);
            props.addParam(new Param(propName, String.valueOf(propValue), "string"));
        }
        Record body = new Record();
        body.setId("body");
        result.addRecord(body);
        if (message instanceof TextMessage) {
            body.addParam(new Param("text", ((TextMessage)message).getText(), "String"));
        } else if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            Enumeration mapNames = mapMessage.getMapNames();
            String key = null;
            while (mapNames.hasMoreElements()) {
                key = (String)mapNames.nextElement();
                body.addParam(new Param(key, String.valueOf(mapMessage.getObject(key)), "string"));
            }
        } else {
            if (message instanceof StreamMessage) {
                throw new ConnectorException(JMS_CONNECTOR, "8910", "JMS StreamMessage type is not handled yet");
            }
            if (message instanceof ObjectMessage) {
                throw new ConnectorException(JMS_CONNECTOR, "8910", "JMS ObjectMessage type is not handled yet");
            }
            if (message instanceof BytesMessage) {
                throw new ConnectorException(JMS_CONNECTOR, "8910", "JMS ByteMessage type is not handled yet");
            }
        }
        return result;
    }

    private void buildResult(Result result, String message) {
        Record record = new Record();
        record.setId("RETURN");
        record.addParam(new Param("result", message, "string"));
        result.addRecord(record);
    }

    @Override
    public void setCallingProcessor(Processor processor) {
    }
}

