/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.jms;

import com.konylabs.middleware.connectors.jms.ConnectionObject;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

public final class MessageUtils {
    private static Logger LOGGER = Logger.getLogger(MessageUtils.class);

    public static Message send(ConnectionObject conObj, String message, boolean isTransacted) {
        return MessageUtils.send(conObj, message, isTransacted, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message send(ConnectionObject conObj, String message, boolean isTransacted, Destination replyTo) {
        Connection connection = null;
        Session session = null;
        MessageProducer producer = null;
        try {
            connection = conObj.factory.createConnection();
            if (isTransacted) {
                LOGGER.debug((Object)"Creating new JMS transaction");
                session = connection.createSession(true, 0);
            } else {
                session = connection.createSession(false, 1);
            }
            Destination destination = conObj.destination;
            producer = session.createProducer(destination);
            TextMessage textMessage = session.createTextMessage(message);
            if (replyTo != null) {
                textMessage.setJMSReplyTo(replyTo);
            }
            connection.start();
            producer.send((Message)textMessage);
            LOGGER.debug((Object)("Message sent: " + textMessage.getJMSMessageID()));
            if (isTransacted) {
                session.commit();
                LOGGER.debug((Object)"Transaction committed");
            }
            TextMessage textMessage2 = textMessage;
            return textMessage2;
        }
        catch (JMSException e) {
            try {
                if (session != null && session.getTransacted()) {
                    session.rollback();
                }
            }
            catch (JMSException e1) {
                LOGGER.debug((Object)"Exception when rollbacking the JMS transaction", (Throwable)e);
            }
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    LOGGER.debug((Object)"JMS Producer could not be closed", (Throwable)e);
                }
            }
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    LOGGER.debug((Object)"JMS Session could not be closed", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    LOGGER.debug((Object)"JMS Connection could not be closed", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message receive(ConnectionObject conObj, String selector, boolean isTransacted) {
        Connection connection = null;
        Session session = null;
        MessageConsumer consumer = null;
        try {
            connection = conObj.factory.createConnection();
            if (isTransacted) {
                LOGGER.debug((Object)"Creating new JMS transaction");
                session = connection.createSession(true, 0);
            } else {
                session = connection.createSession(false, 1);
            }
            Destination destination = conObj.destination;
            consumer = selector != null ? session.createConsumer(destination, selector) : session.createConsumer(destination);
            connection.start();
            Message message = consumer.receive(conObj.timeout);
            LOGGER.debug((Object)(message != null ? "Message received: " + message.getJMSMessageID() : "Message receive failed"));
            if (isTransacted) {
                session.commit();
                LOGGER.debug((Object)"Transaction committed");
            }
            Message message2 = message;
            return message2;
        }
        catch (JMSException e) {
            try {
                if (session != null && session.getTransacted()) {
                    session.rollback();
                }
            }
            catch (JMSException e1) {
                LOGGER.debug((Object)"Exception when rollbacking the JMS transaction", (Throwable)e);
            }
            LOGGER.error((Object)"Exception in JMS receive", (Throwable)e);
        }
        finally {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    LOGGER.debug((Object)"JMS Consumer could not be closed", (Throwable)e);
                }
            }
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    LOGGER.debug((Object)"JMS Session could not be closed", (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    LOGGER.debug((Object)"JMS Connection could not be closed", (Throwable)e);
                }
            }
        }
        return null;
    }

    private MessageUtils() {
    }
}

