/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.json;

import com.konylabs.middleware.connectors.io.ServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class JSONInputHandler
extends ServiceInputHandler {
    private static final Logger LOGGER = Logger.getLogger(JSONInputHandler.class);

    protected String fillMessageForString(String tvalue, String key, String value, Map configMap, boolean encode, boolean escape) {
        LOGGER.debug((Object)("encode value for fillMessage String " + encode));
        if (escape) {
            value = this.escapeJSON(value);
        }
        if (encode) {
            value = EncodeUtils.encode((String)value);
        }
        return value;
    }

    private String escapeJSON(String value) {
        if (value == null) {
            return value;
        }
        String quotedString = JSONObject.quote((String)value);
        return quotedString.substring(1, quotedString.length() - 1);
    }

    @Override
    public Map<String, String> getHeaders(DataControllerRequest request, Map configMap, Service service) throws ConnectorException {
        Map<String, String> map = super.getHeaders(request, configMap, service);
        if (!MiddlewareUtils.isHeadersPassThrough(service) && !map.containsKey("Accept")) {
            map.put("Accept", "application/json");
        }
        String contentType = MiddlewareUtils.getContentType(map, null);
        LOGGER.debug((Object)("JSON Content type " + contentType));
        if (StringUtils.isBlank((String)contentType)) {
            map.put("Content-Type", "application/json");
        }
        return map;
    }
}

