/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.json;

import com.konylabs.middleware.connectors.io.BaseOutputHandler;
import com.konylabs.middleware.connectors.json.JsonPathEngine;
import com.konylabs.middleware.connectors.json.JsonPathEngineImpl;
import com.konylabs.middleware.connectors.json.JsonPathFromXpathEngineImpl;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.json.JSONException;

public class JSONOutputHandler
extends BaseOutputHandler {
    private static final Logger logger = Logger.getLogger(JSONOutputHandler.class);
    private static final String INT_CONST = "int";
    private static final String OPSTATUS = "opstatus";
    private static final String HTTP_STATUS_CODE = "httpStatusCode";
    private static final String STRING_CONST = "string";
    private static final String ERR_MSG = "errmsg";

    @Override
    public void processOutput(Service service, DataControllerRequest request, DataControllerResponse response, Result result) throws ConnectorException {
        String responseStr = response.getResponse();
        super.processOutput(service, request, response, result);
        if (responseStr == null || responseStr.trim().length() == 0) {
            result.addParam(new Param(OPSTATUS, response.getStatusCode() == 204 ? "0" : "8005", INT_CONST));
            result.addParam(new Param(HTTP_STATUS_CODE, String.valueOf(response.getStatusCode()), INT_CONST));
            result.addParam(new Param(ERR_MSG, "empty response received", STRING_CONST));
            return;
        }
        String serviceId = service.getId();
        JsonPathEngine engine = this.validateAndGetEngine(service, response, responseStr, serviceId);
        try {
            Object opstatus;
            List datasetList;
            ArrayList params = service.getServiceOutput().getParams();
            if (params.size() > 0) {
                result.addAllParams((Collection)engine.fillParams((List)params, request, null));
            }
            ArrayList records = service.getServiceOutput().getRecords();
            result.addAllRecords((Collection)engine.fillRecords((List)records, request, null));
            ArrayList datasets = service.getServiceOutput().getDatasets();
            if (datasets.size() > 0 && (datasetList = engine.fillDatasets((List)datasets, request, null)) != null && datasetList.size() > 0) {
                result.addAllDatasets((Collection)datasetList);
            }
            result.addParam(new Param(OPSTATUS, (opstatus = request.getAttribute(OPSTATUS)) != null ? (String)opstatus : "0", INT_CONST));
            Param errmsgParam = result.getParamByName(ERR_MSG);
            if (errmsgParam != null && "".equals(errmsgParam.getValue())) {
                result.removeParam(errmsgParam);
            }
            if (request.getAttribute(ERR_MSG) != null && (errmsgParam == null || "".equals(errmsgParam.getValue()))) {
                result.addParam(new Param(ERR_MSG, (String)request.getAttribute(ERR_MSG), STRING_CONST));
            }
        }
        catch (XPathExpressionException xe) {
            MiddlewareUtils.maskTrace("5008", "Error parsing the JSON path.", xe);
            result.addParam(new Param(OPSTATUS, "5008", INT_CONST));
            if (ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) {
                result.addParam(new Param(ERR_MSG, "Invalid JSON path expression specified for " + serviceId, STRING_CONST));
            }
        }
        catch (JSONException t) {
            MiddlewareUtils.maskTrace("5007", "Error parsing the JSON response.", (Exception)((Object)t));
            result.addParam(new Param(OPSTATUS, "777777", INT_CONST));
            if (ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) {
                result.addParam(new Param(ERR_MSG, "Cannot parse. Invalid JSON for " + serviceId, STRING_CONST));
            }
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            MaskUtils.maskTrace((String)ex.getMessage(), (Throwable)ex);
            throw new ConnectorException("JsonConnector", "5006", "Invalid JSON Response for " + serviceId + ". " + ex.getMessage(), (Throwable)ex);
        }
        result.addParam(new Param(HTTP_STATUS_CODE, String.valueOf(response.getStatusCode()), INT_CONST));
    }

    private JsonPathEngine validateAndGetEngine(Service service, DataControllerResponse response, String responseStr, String serviceId) throws ConnectorException {
        JsonPathFromXpathEngineImpl engine;
        if (!responseStr.startsWith("{") && !responseStr.startsWith("[")) {
            logger.error((Object)("Invalid JSON Response from Service: " + serviceId + " " + responseStr));
            throw new ConnectorException("JsonConnector", "5001", response.getStatusCode(), "Invalid JSON Response: response is not starting with { or [ for " + serviceId);
        }
        try {
            ConfigParam isJsonPathConfigParam = service.getServiceConfig().getConfigParam("jsonpath");
            engine = isJsonPathConfigParam != null && Boolean.valueOf(isJsonPathConfigParam.getValue()) != false ? new JsonPathEngineImpl(responseStr) : new JsonPathFromXpathEngineImpl(responseStr);
        }
        catch (Exception e) {
            MiddlewareUtils.maskTrace("5002", "Malformed JSON Response for ", e);
            throw new ConnectorException("JsonConnector", "5002", "Malformed JSON Response for " + e);
        }
        return engine;
    }
}

