/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.logservice;

import com.konylabs.middleware.cloud.CloudUtils;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.connectors.logservice.QueueService;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractQueueService
implements QueueService {
    private static final Logger LOGGER = Logger.getLogger(AbstractQueueService.class);

    protected List<JSONArray> splitEventsIntoBatches(JSONArray events) {
        ArrayList<JSONArray> eventList = new ArrayList<JSONArray>();
        if (events != null && events.length() > 0) {
            eventList.add(events);
        }
        return eventList;
    }

    @Override
    public void pushEventsWithRequestMetrics(JSONObject konyreportingparams, JSONObject props) throws Exception {
        List<JSONArray> eventsList = this.splitEventsIntoBatches(MetricsUtils.getEventsArray(konyreportingparams));
        if (!MetricsUtils.isNullOrEmpty(eventsList)) {
            for (int i = 0; i < eventsList.size(); ++i) {
                props.put("events", (Object)eventsList.get(i));
                if (i > 0) {
                    props.put("svcid", (Object)"sendEvents");
                    props.put("fid", (Object)"");
                    props.put("metrics", (Object)new JSONArray());
                    props.put("ts", (Object)CloudUtils.getDateUTCString(new Date()));
                    LOGGER.debug((Object)"Pushing sendEvents message with events");
                } else {
                    LOGGER.debug((Object)"Pushing service message with events");
                }
                if (!props.has("sid")) {
                    LOGGER.error((Object)"sid is missing ");
                }
                MetricsUtils.logEventsForDebugging(props);
            }
        }
        this.pushMessage(props);
    }

    @Override
    public String sendRegistrationMetrics(JSONObject reportsParams, long currentTime, TenantBean<AppCache> tenantBean) throws Exception {
        String result = "Success";
        JSONObject props = new JSONObject();
        MetricsUtils.setEnvironmentDetails(props, tenantBean);
        this.setReportParams(reportsParams, props, currentTime);
        if (!MetricsUtils.copyValueIfPresentAndNotEmpty("svcid", reportsParams, props)) {
            props.put("svcid", (Object)"RegisterKonySession");
        }
        List<JSONArray> eventsJsonList = this.splitEventsIntoBatches(MetricsUtils.getEventsArray(reportsParams));
        JSONArray datesArray = MetricsUtils.getDates("launchDates", reportsParams, eventsJsonList);
        for (int i = 0; i < datesArray.length(); ++i) {
            JSONArray arrObj = datesArray.getJSONArray(i);
            LOGGER.debug((Object)("LaunchDate  " + arrObj));
            if (arrObj.length() <= 1) continue;
            props.put("fid", (Object)"");
            String rsID = arrObj.getString(0);
            if (StringUtils.isBlank((String)rsID)) {
                rsID = reportsParams.getString("sid");
            }
            if (StringUtils.isNotBlank((String)rsID)) {
                props.put("sid", (Object)rsID);
            } else {
                LOGGER.error((Object)"sid is missing ");
            }
            MetricsUtils.addTimestamp(props, arrObj);
            if (arrObj.length() > 2) {
                props.put("sessiontype", arrObj.get(2));
            }
            props.put("metrics", (Object)new JSONArray());
            if (!MetricsUtils.isNullOrEmpty(eventsJsonList)) {
                props.put("events", (Object)eventsJsonList.remove(0));
            }
            if (this.pushMessage(props)) continue;
            result = "Failure";
        }
        if (!MetricsUtils.isNullOrEmpty(eventsJsonList)) {
            result = this.prepareEventBatchEntries(reportsParams, props, eventsJsonList, result);
        }
        return result;
    }

    @Override
    public String sendCustomMetrics(JSONObject reportsParams, long currentTime, TenantBean<AppCache> tenantBean) throws Exception {
        String result = "Success";
        JSONObject props = new JSONObject();
        MetricsUtils.setEnvironmentDetails(props, tenantBean);
        this.setReportParams(reportsParams, props, currentTime);
        if (!MetricsUtils.copyValueIfPresentAndNotEmpty("svcid", reportsParams, props)) {
            props.put("svcid", (Object)"capturekonycustommetrics");
        }
        List<JSONArray> eventsJsonList = this.splitEventsIntoBatches(MetricsUtils.getEventsArray(reportsParams));
        JSONArray reportDataArray = MetricsUtils.getDates("reportData", reportsParams, eventsJsonList);
        for (int i = 0; i < reportDataArray.length(); ++i) {
            JSONObject repotJSONObject = reportDataArray.getJSONObject(i);
            String rsID = repotJSONObject.getString("rsid");
            if (StringUtils.isBlank((String)rsID)) {
                rsID = reportsParams.getString("sid");
            }
            if (StringUtils.isNotBlank((String)rsID)) {
                props.put("sid", (Object)rsID);
            } else {
                LOGGER.error((Object)"sid is missing ");
            }
            props.put("fid", (Object)repotJSONObject.getString("fid"));
            props.put("ts", (Object)repotJSONObject.getString("ts"));
            props.put("metrics", repotJSONObject.get("metrics"));
            if (!MetricsUtils.isNullOrEmpty(eventsJsonList)) {
                props.put("events", (Object)eventsJsonList.remove(0));
            }
            if (this.pushMessage(props)) continue;
            result = "Failure";
        }
        if (!MetricsUtils.isNullOrEmpty(eventsJsonList)) {
            result = this.prepareEventBatchEntries(reportsParams, props, eventsJsonList, result);
        }
        return result;
    }

    private void setReportParams(JSONObject src, JSONObject dest, long timeInMillis) throws JSONException {
        MetricsUtils.copyValueIfPresentElseSetEmpty("chnl", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("plat", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("atype", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("aid", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("aname", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("did", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("os", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("ua", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("stype", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("dm", src, dest);
        dest.put("svcgroup", src.get("aid"));
        MetricsUtils.copyHashKeyIfPresentElseSetEmpty("kuid", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("aver", src, dest);
        MetricsUtils.copyValueIfPresentElseSetEmpty("sid", src, dest);
        if (src.has("rid") && StringUtils.isNotBlank((String)src.getString("rid"))) {
            dest.put("rid", (Object)src.getString("rid"));
        } else {
            dest.put("rid", (Object)UUID.randomUUID().toString());
        }
        MetricsUtils.copyValueIfPresentWithoutEmpty("sdktype", src, dest);
        MetricsUtils.copyValueIfPresentWithoutEmpty("sdkversion", src, dest);
        MetricsUtils.copyValueIfPresentWithoutEmpty("mfaid", src, dest);
        MetricsUtils.copyValueIfPresentWithoutEmpty("mfbaseid", src, dest);
        MetricsUtils.copyValueIfPresentWithoutEmpty("mfaname", src, dest);
        long duration = System.currentTimeMillis() - timeInMillis;
        dest.put("tdur", duration);
        dest.put("idur", duration);
        dest.put("exdur", 0);
        dest.put("postdur", 0);
        dest.put("prsdur", 0);
        dest.put("predur", 0);
        MetricsUtils.copyValueIfPresentElseSetEmpty("rip", src, dest);
    }

    private String prepareEventBatchEntries(JSONObject json, JSONObject props, List<JSONArray> eventsJsonList, String result) throws JSONException, IOException {
        props.put("svcid", (Object)"sendEvents");
        props.put("fid", (Object)"");
        props.put("metrics", (Object)new JSONArray());
        MetricsUtils.logEventsForDebugging(json);
        for (JSONArray jsonArray : eventsJsonList) {
            MetricsUtils.setEventRelatedParams(json, props, jsonArray);
            props.put("events", (Object)jsonArray);
            if (this.pushMessage(props)) continue;
            result = "Failure";
        }
        return result;
    }

    @Override
    public void pushJobNotificationMessage(String jobNotification) {
    }

    @Override
    public boolean isJobsNotificationQueueConfigured() {
        return false;
    }

    @Override
    public void destroy() {
    }
}

