/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.logservice;

import com.kony.mobilefabric.util.RetryCommand;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.connectors.logservice.AbstractQueueService;
import com.konylabs.middleware.connectors.logservice.JMSProvider;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.json.JSONObject;

public class JMSLogService
extends AbstractQueueService {
    private static final Logger LOGGER = Logger.getLogger(JMSLogService.class);
    private int totalSetupRetryCount;
    private JMSProvider provider;
    private static JMSLogService jmslogService;

    private JMSLogService() {
        this.setUpJMSWithRetry();
    }

    public static JMSLogService getInstance() {
        if (jmslogService == null) {
            jmslogService = new JMSLogService();
        }
        return jmslogService;
    }

    @Override
    public boolean pushMessage(JSONObject message) {
        return this.publishMessage(message);
    }

    private void setUpJMSWithRetry() {
        int numberOfTriesInThisBatch = Math.min(MetricsUtils.getMetricsRetryCount() - this.totalSetupRetryCount, MetricsUtils.getMetricsFailoverRetryCount());
        if (numberOfTriesInThisBatch <= 0) {
            LOGGER.error((Object)("JMS setup failed. Exceeded total retry limit " + this.totalSetupRetryCount + ". Retry is disabled."));
            return;
        }
        RetryCommand<Boolean> setupCmd = new RetryCommand<Boolean>("setupJMS", numberOfTriesInThisBatch, (long)MetricsUtils.getMetricsFailoverDuration()){

            protected Boolean perform() throws Exception {
                return JMSLogService.this.init();
            }

            protected Boolean handleAllRetryFailed(Exception e) {
                LOGGER.info((Object)("JMS setup failed even after retrying for " + this.getMaxNumberOfTries() + " times. Will try again later."));
                return false;
            }
        };
        setupCmd.performWithRetry();
    }

    public boolean init() throws NamingException, JMSException {
        ++this.totalSetupRetryCount;
        String initialContextFactoryName = MetricsUtils.getMetricsIntialContextFactory();
        Context initialContext = JMSProvider.getInitialContext(initialContextFactoryName, MetricsUtils.getMetricsProviderUrl(), MetricsUtils.getMetricsUrlPackagePrefixes(), MetricsUtils.getMetricsSecurityPrincipalName(), MetricsUtils.getSecurityCredentials());
        try {
            this.provider = JMSProvider.create(initialContextFactoryName, initialContext);
        }
        finally {
            Closer.closeQuietly((Context)initialContext);
        }
        return true;
    }

    private boolean publishMessage(JSONObject message) {
        try {
            if (this.isSetupPending() && MetricsUtils.getMetricsRetryCount() - this.totalSetupRetryCount >= 0) {
                this.init();
            }
        }
        catch (Exception ex) {
            LOGGER.debug((Object)"Error while setting up JMS", (Throwable)ex);
        }
        if (this.isSetupPending()) {
            return false;
        }
        JMSLogService.addLogLevelOverride(message);
        String msg = message.toString();
        LOGGER.debug((Object)("service reporting pushing into message destination : " + msg));
        try {
            return this.provider.send(msg);
        }
        catch (IllegalStateException | JMSException isEx) {
            LOGGER.debug((Object)"connection error while setting up JMS", isEx);
            try {
                this.init();
                return this.provider.send(msg);
            }
            catch (NamingException nEx) {
                LOGGER.error((Object)"Error while setting up JMS, encountered NamingException", (Throwable)nEx);
            }
            catch (JMSException jmsEx) {
                LOGGER.error((Object)"Error while setting up JMS, Encountered JMS Exception", (Throwable)jmsEx);
            }
            return false;
        }
        catch (Exception ex) {
            LOGGER.debug((Object)"Error while pushing message to JMS destination ", (Throwable)ex);
            return false;
        }
    }

    private static void addLogLevelOverride(JSONObject message) {
        String overrideLevel = ThreadContext.get((String)"KONY_SERVER_DYNAMIC_LOG_LEVEL");
        if (StringUtils.isNotBlank((String)overrideLevel)) {
            message.put("dynamicloglevel", (Object)overrideLevel);
        }
    }

    public boolean isSetupPending() {
        return this.provider == null;
    }

    @Override
    public void shutdownQueueClient() {
    }
}

