/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.logservice;

import com.konylabs.middleware.common.EncryptDecryptText;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

abstract class JMSProvider {
    private static final Logger LOGGER = Logger.getLogger(JMSProvider.class);
    private static final String METRICS_TOPIC_NAME = "metrics.TopicName";
    private static final String METRICS_TOPIC_CONNECTION_FACTORY = "metrics.TopicConnectionFactoryName";
    private static final String ACTIVEMQ_INITIAL_CONTEXTFACTORY_CLASS = "org.apache.activemq.jndi.ActiveMQInitialContextFactory";
    private final String topicFactoryName = ConfigUtility.getProperty((String)"metrics.TopicConnectionFactoryName");
    protected final String topicName = ConfigUtility.getProperty((String)"metrics.TopicName");
    private static final String METRICS_USER_NAME = "metrics.userName";
    private static final String METRICS_PD = "metrics.password";
    private final boolean isEncrypted = Boolean.parseBoolean(ConfigUtility.getProperty((String)"use.encryption"));
    private final String userName = ConfigUtility.getProperty((String)"metrics.userName");
    private final String password = this.isEncrypted ? EncryptDecryptText.decryptText((String)ConfigUtility.getProperty((String)"metrics.password")) : ConfigUtility.getProperty((String)"metrics.password");
    protected ConnectionFactory connectionFactory;

    public static JMSProvider create(String contextFactoryName, Context context) throws NamingException {
        LOGGER.debug((Object)("Create JMSProvider for " + contextFactoryName));
        return ACTIVEMQ_INITIAL_CONTEXTFACTORY_CLASS.equalsIgnoreCase(contextFactoryName) ? new ActiveMQJMSProvider(context) : new JBossJMSProvider(context);
    }

    protected JMSProvider(Context context) throws NamingException {
        LOGGER.debug((Object)("Looking up [" + this.topicFactoryName + "]"));
        this.connectionFactory = (ConnectionFactory)context.lookup(this.topicFactoryName);
    }

    public boolean send(String message) throws JMSException {
        LOGGER.debug((Object)"Message about to send. ");
        Connection connection = null;
        try {
            LOGGER.debug((Object)"Creating connection.");
            connection = this.getConnection(this.userName, this.password);
            connection.start();
            this.sendCore(connection, message);
            LOGGER.debug((Object)"Message successfully sent.");
            this.closeConnectionQuietly(connection);
        }
        catch (Throwable throwable) {
            this.closeConnectionQuietly(connection);
            throw throwable;
        }
        return true;
    }

    protected static void safeClose(MessageProducer producer, Session session) {
        try {
            producer.close();
            session.close();
        }
        catch (JMSException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
    }

    protected abstract void sendCore(Connection var1, String var2) throws JMSException;

    public static Context getInitialContext(String initialContextFactoryName, String providerURL, String urlPkgPrefixes, String securityPrincipalName, String securityCredentials) throws NamingException {
        InitialContext jndi;
        LOGGER.debug((Object)"Getting initial context.");
        if (initialContextFactoryName != null) {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", initialContextFactoryName);
            if (providerURL != null) {
                env.put("java.naming.provider.url", providerURL);
            } else {
                LOGGER.warn((Object)"You have set InitialContextFactoryName option but not the ProviderURL. This is likely to cause problems.");
            }
            if (urlPkgPrefixes != null) {
                env.put("java.naming.factory.url.pkgs", urlPkgPrefixes);
            }
            if (securityPrincipalName != null) {
                env.put("java.naming.security.principal", securityPrincipalName);
                if (securityCredentials != null) {
                    env.put("java.naming.security.credentials", securityCredentials);
                } else {
                    LOGGER.warn((Object)"You have set SecurityPrincipalName option but not the SecurityCredentials. This is likely to cause problems.");
                }
            }
            jndi = new InitialContext(env);
        } else {
            jndi = new InitialContext();
        }
        return jndi;
    }

    private Connection getConnection(String userName, String password) throws JMSException {
        if (userName != null) {
            return this.connectionFactory.createConnection(userName, password);
        }
        return this.connectionFactory.createConnection();
    }

    private void closeConnectionQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unable to close.", (Throwable)e);
            }
        }
    }

    private static class ActiveMQJMSProvider
    extends JMSProvider {
        public ActiveMQJMSProvider(Context context) throws NamingException {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void sendCore(Connection connection, String message) throws JMSException {
            LOGGER.debug((Object)"Creating JMS Session.");
            Session session = connection.createSession(false, 2);
            LOGGER.debug((Object)"Creating MessageProducer.");
            Topic destination = session.createTopic(this.topicName);
            MessageProducer producer = session.createProducer((Destination)destination);
            try {
                producer.send((Message)session.createTextMessage(message));
            }
            finally {
                ActiveMQJMSProvider.safeClose(producer, session);
            }
        }
    }

    private static class JBossJMSProvider
    extends JMSProvider {
        private Topic topic;

        public JBossJMSProvider(Context context) throws NamingException {
            super(context);
            LOGGER.debug((Object)("Looking up topic name [" + this.topicName + "]."));
            this.topic = (Topic)context.lookup(this.topicName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void sendCore(Connection connection, String message) throws JMSException {
            LOGGER.debug((Object)"Creating JMS Session.");
            Session session = connection.createSession(false, 1);
            LOGGER.debug((Object)"Creating TopicPublisher.");
            MessageProducer producer = session.createProducer((Destination)this.topic);
            try {
                producer.send((Message)session.createTextMessage(message));
            }
            finally {
                JBossJMSProvider.safeClose(producer, session);
            }
        }
    }
}

