/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.logservice;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.cloud.CloudUtils;
import com.konylabs.middleware.common.EncryptDecryptText;
import com.konylabs.middleware.common.S3Config;
import com.konylabs.middleware.connectors.logservice.DataAdapterNames;
import com.konylabs.middleware.connectors.logservice.QueueService;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.identityproviders.MBaaSIdentityProvider;
import com.konylabs.middleware.metrics.KonyCustomMetrics;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MetricsBeanUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.CRC32;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MetricsUtils {
    private static final Logger LOGGER = Logger.getLogger(MetricsUtils.class);

    public static boolean isDateInFuture(String date) {
        if (date == null) {
            return true;
        }
        try {
            Date clientDate = MetricsUtils.getDateFormatter().parse(date);
            return clientDate.after(new Date());
        }
        catch (ParseException e) {
            LOGGER.warn((Object)"Unable to parse client timestamp", (Throwable)e);
            return true;
        }
    }

    public static List<JSONArray> splitEventsIntoBatches(JSONArray events, long batchSizeInBytes) {
        ArrayList<JSONArray> eventList = new ArrayList<JSONArray>();
        if (events == null || events.length() == 0) {
            return eventList;
        }
        if ((long)events.toString().length() <= batchSizeInBytes) {
            eventList.add(events);
            return eventList;
        }
        int arrayBracketSize = "[]".getBytes().length;
        int commaSize = ",".getBytes().length;
        JSONArray currentArray = new JSONArray();
        int currentArraySize = arrayBracketSize;
        int currentIndex = 0;
        for (int i = 0; i < events.length(); ++i) {
            JSONObject currentEvent = events.getJSONObject(i);
            int currentEventSize = currentEvent.toString().getBytes().length;
            if ((long)currentEventSize > batchSizeInBytes) {
                LOGGER.error((Object)("Exceeded maximum size of the event in a message: " + currentEvent.toString()));
                continue;
            }
            if ((long)(currentEventSize + currentArraySize) >= batchSizeInBytes) {
                eventList.add(currentArray);
                currentArray = new JSONArray();
                currentArraySize = commaSize;
                currentIndex = 0;
            }
            currentArray.put(currentIndex, (Object)currentEvent);
            currentArraySize += currentEventSize + commaSize;
            ++currentIndex;
        }
        if (currentArray.length() > 0) {
            eventList.add(currentArray);
        }
        return eventList;
    }

    private static SimpleDateFormat getDateFormatter() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(utc);
        return formatter;
    }

    public static Boolean isMetricsEnabled() {
        return Boolean.valueOf(ConfigUtility.getProperty((String)"metrics.logging", (String)"true")) != false && !MiddlewareUtils.isWebApp();
    }

    public static String getMetricsProviderUrl() {
        return ConfigUtility.getProperty((String)"metrics.providerURL");
    }

    public static String getMetricsUrlPackagePrefixes() {
        return ConfigUtility.getProperty((String)"metrics.URLPkgPrefixes");
    }

    public static String getMetricsIntialContextFactory() {
        return ConfigUtility.getProperty((String)"metrics.initialContextFactoryName");
    }

    public static String getMetricsSecurityPrincipalName() {
        return ConfigUtility.getProperty((String)"metrics.securityPrincipalName");
    }

    public static Boolean isSeurityCredentialsEncrypted() {
        return Boolean.valueOf(ConfigUtility.getProperty((String)"use.encryption"));
    }

    public static String getSecurityCredentials() {
        if (MetricsUtils.isSeurityCredentialsEncrypted().booleanValue()) {
            return EncryptDecryptText.decryptText((String)ConfigUtility.getProperty((String)"metrics.securityCredentials"));
        }
        return ConfigUtility.getProperty((String)"metrics.securityCredentials");
    }

    public static int getMetricsRetryCount() {
        return ConfigUtility.getIntProperty((String)"METRICS_MAX_RETRY_COUNT_LIMIT", (int)25, (int)1);
    }

    public static int getMetricsFailoverRetryCount() {
        return ConfigUtility.getIntProperty((String)"metrics.FailoverRetries", (int)3, (int)1, (int)MetricsUtils.getMetricsRetryCount());
    }

    public static int getMetricsFailoverDuration() {
        return ConfigUtility.getIntProperty((String)"metrics.FailoverDuration", (int)5000, (int)1);
    }

    public static boolean isMetricsLogClientEventsEnabled() {
        return Boolean.valueOf(ConfigUtility.getProperty((String)"metrics.LogClientEvents", (String)"false"));
    }

    public static boolean isMetricsLogClientCrashEventsEnabled() {
        return Boolean.valueOf(ConfigUtility.getProperty((String)"metrics.LogClientCrashEvents", (String)"true"));
    }

    public static void addUserAgent(HttpServletRequest request, JSONObject reportsParams) {
        if (!reportsParams.has("ua") && StringUtils.isNotBlank((String)request.getHeader("user-agent"))) {
            reportsParams.put("ua", (Object)request.getHeader("user-agent"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParamToMetricsBean(DataControllerRequest request, String paramKey, Object paramValue) {
        MetricsBean metricsBean = null;
        DataControllerRequest dataControllerRequest = request;
        synchronized (dataControllerRequest) {
            metricsBean = (MetricsBean)request.getAttribute("metricsBean");
        }
        if (metricsBean != null) {
            metricsBean.addParam(paramKey, paramValue);
        }
    }

    public static void logDetailsToQueue(HttpServletRequest request, long timeTakenInMillis) {
        if (request == null && EnvironmentFactory.getEnvironment() == null) {
            return;
        }
        try {
            JSONObject json;
            QueueService queueService = EnvironmentFactory.getEnvironment().getQueueService();
            TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromRequest((ServletRequest)request);
            MetricsBean metricsBean = (MetricsBean)request.getAttribute("metricsBean");
            JSONObject props = new JSONObject();
            MetricsUtils.copyAWSEnvironmentValues(props, tenantBean);
            MetricsUtils.putIfNotNull("rid", MiddlewareUtils.getRequestId(request), props);
            RequestData requestData = (RequestData)request.getAttribute("requestdata");
            if (metricsBean != null) {
                MetricsUtils.addServiceData(metricsBean, props);
                MetricsUtils.addCustomMetricsData(metricsBean, props);
                MetricsUtils.addServiceTypeAndConnectorType(props, requestData, request, metricsBean);
                MetricsUtils.getInternalDurationAndAddDurationDataToJsonIfNotNull(timeTakenInMillis, metricsBean, props);
                MetricsUtils.addResponseData(metricsBean, props);
            } else {
                LOGGER.error((Object)"metrics bean is null , so unable to log duration data to metrics");
            }
            props.put("rip", (Object)MetricsUtils.getRemoteIp(request, props));
            String jsonString = MiddlewareUtils.getReportingParams(request, false);
            JSONObject jSONObject = json = StringUtils.isNotBlank((String)jsonString) ? new JSONObject(jsonString) : MetricsUtils.addReportingParamsForAPI(metricsBean);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Reporting params json : " + json.toString()));
            }
            MetricsUtils.copyReportingParams(request, json, props);
            queueService.pushEventsWithRequestMetrics(json, props);
        }
        catch (JSONException joex) {
            LOGGER.error((Object)"error while converting json request to JSON object ", (Throwable)joex);
        }
        catch (Exception e) {
            LOGGER.error((Object)"ERROR : Can not generate metrics. Attribute values are missing", (Throwable)e);
        }
    }

    public static JSONObject addReportingParamsForAPI(MetricsBean metricsBean) {
        JSONObject apiJson = new JSONObject();
        apiJson.put("stype", (Object)"b2c");
        apiJson.put("sdktype", (Object)"API");
        apiJson.put("sdkversion", (Object)"");
        MetricsUtils.copyValueIfPresentElseSetEmptyString("aid", metricsBean.getParam("aid"), apiJson);
        MetricsUtils.copyValueIfPresentElseSetEmptyString("mfaid", metricsBean.getParam("mfaid"), apiJson);
        MetricsUtils.copyValueIfPresentElseSetEmptyString("aname", metricsBean.getParam("aname"), apiJson);
        MetricsUtils.copyValueIfPresentElseSetEmptyString("mfaname", metricsBean.getParam("mfaname"), apiJson);
        MetricsUtils.copyValueIfPresentElseSetEmptyString("mfbaseid", metricsBean.getParam("mfbaseid"), apiJson);
        return apiJson;
    }

    public static void copyValueIfPresentElseSetEmptyString(String key, Object srcValue, JSONObject dest) {
        dest.put(key, srcValue != null ? srcValue : "");
    }

    public static boolean isEncodePIIEnabled() {
        return Boolean.valueOf(ConfigUtility.getProperty((String)"encode.pII"));
    }

    public static String getRemoteIp(HttpServletRequest request, JSONObject reportsParams) {
        if (!MetricsUtils.isEncodePIIEnabled()) {
            String remoteIp = reportsParams.has("rip") && reportsParams.get("rip") != null ? reportsParams.get("rip").toString() : request.getRemoteAddr();
            return MetricsUtils.getXForwardedIP(request, remoteIp);
        }
        return "";
    }

    public static String getCRC32Hash(String input) {
        CRC32 crc32 = new CRC32();
        crc32.update(input.getBytes());
        return String.valueOf(crc32.getValue());
    }

    public static void addTimestamp(JSONObject props, JSONArray arrObj) {
        if (MetricsUtils.isDateInFuture(arrObj.getString(1))) {
            props.put("ts", (Object)CloudUtils.getDateUTCString(new Date()));
        } else {
            props.put("ts", arrObj.get(1));
        }
    }

    public static long getInternalDurationAndAddDurationDataToJsonIfNotNull(long timeTakenInMillis, MetricsBean metricsBean, JSONObject props) {
        long internalDuration;
        long parsingDuration;
        long requestMapperDuration = metricsBean.getParamValueAsLong("reqmapdur");
        long responseMapperDuration = metricsBean.getParamValueAsLong("respmapdur");
        long backendRequestDuration = metricsBean.getParamValueAsLong("serviceTimeInMillis");
        long preProcessorDuration = metricsBean.getParamValueAsLong("preProcessorDur");
        long postProcessorDuration = metricsBean.getParamValueAsLong("postProcessorDur");
        long urlProviderDuration = metricsBean.getParamValueAsLong("urlProviderDur");
        long totalExternalDuration = requestMapperDuration + responseMapperDuration + backendRequestDuration + (preProcessorDuration += urlProviderDuration) + postProcessorDuration + (parsingDuration = metricsBean.getParamValueAsLong("prsdur").longValue());
        long l = internalDuration = timeTakenInMillis - totalExternalDuration < 0L ? 0L : timeTakenInMillis - totalExternalDuration;
        if (props != null) {
            MetricsUtils.putIfNotNull("reqmapdur", requestMapperDuration, props);
            MetricsUtils.putIfNotNull("respmapdur", responseMapperDuration, props);
            props.put("tdur", timeTakenInMillis);
            props.put("exdur", backendRequestDuration);
            props.put("predur", preProcessorDuration);
            props.put("postdur", postProcessorDuration);
            props.put("prsdur", parsingDuration);
            props.put("idur", internalDuration);
        }
        return internalDuration;
    }

    private static void addResponseData(MetricsBean metricsBean, JSONObject props) {
        MetricsUtils.putIfNotNull("httpStatusCode", metricsBean.getParam("httpStatusCode"), props);
        if (metricsBean.getParam("mw_response_context_data") != null) {
            String responseString = (String)metricsBean.getParam("mw_response_context_data");
            if (StringUtils.isNotBlank((String)responseString)) {
                JSONObject responseJSON = new JSONObject(responseString);
                MetricsUtils.copyLongValueIfPresentElseSet0(responseJSON, props, "opstatus");
                MetricsUtils.copyLongValueIfPresentElseSet0(responseJSON, props, "httpStatusCode");
                MetricsUtils.copyValueIfPresent("errmsg", responseJSON, props);
            }
        } else {
            props.put("opstatus", 0L);
        }
        boolean isError = metricsBean.getParam("iserror") != null ? (Boolean)metricsBean.getParam("iserror") : (Long)props.get("opstatus") != 0L;
        MetricsUtils.putIfNotNull("respbytes", metricsBean.getParam("respbytes"), props);
        MetricsUtils.putIfNotNull("trecords", metricsBean.getParam("trecords"), props);
        MetricsUtils.putIfNotNull("cnfcnt", metricsBean.getParam("cnfcnt"), props);
        MetricsUtils.putIfNotNull("iserror", isError, props);
        MetricsUtils.putIfNotNull("respprsdur", metricsBean.getParam("respprsdur"), props);
        MetricsUtils.putIfNotNull("errstack", metricsBean.getParam("errstack"), props);
        MetricsUtils.putIfNotNull("errmsg", metricsBean.getParam("errmsg"), props);
        Object errorCode = metricsBean.getParam("errcode") != null ? metricsBean.getParam("errcode") : ((Long)props.get("opstatus") != 0L ? props.get("opstatus") : null);
        MetricsUtils.putIfNotNull("errcode", errorCode, props);
    }

    private static void addCustomMetricsData(MetricsBean metricsBean, JSONObject props) {
        props.put("metrics", (Object)new JSONArray());
        KonyCustomMetrics customMetrics = metricsBean.getKonyCustomMetrics();
        String metricsStr = customMetrics.getCustomMetricsJSON();
        if (StringUtils.isNotBlank((String)metricsStr)) {
            JSONArray metricsObj = new JSONArray(metricsStr);
            props.put("metrics", (Object)metricsObj);
        }
    }

    private static void addServiceData(MetricsBean metricsBean, JSONObject props) {
        MetricsUtils.putIfNotNull("svcid", metricsBean.getParam("svcid"), props);
        MetricsUtils.putIfNotNull("svcgroup", metricsBean.getParam("svcgroup"), props);
        MetricsUtils.putIfNotNull("oname", metricsBean.getParam("oname"), props);
        MetricsUtils.putIfNotNull("omethod", metricsBean.getParam("omethod"), props);
        MetricsUtils.putIfNotNull("svcver", metricsBean.getParam("svcver"), props);
        MetricsUtils.putIfNotNull("rver", metricsBean.getParam("rver"), props);
        MetricsUtils.putIfNotNull("reqtype", metricsBean.getParam("reqtype"), props);
        MetricsUtils.putIfNotNull("reqbytes", metricsBean.getParam("reqbytes"), props);
        MetricsUtils.putIfNotNull("reqprsdur", metricsBean.getParam("reqprsdur"), props);
    }

    private static void copyLongValueIfPresentElseSet0(JSONObject src, JSONObject dest, String key) {
        dest.put(key, 0);
        if (src.has(key)) {
            try {
                dest.put(key, Long.parseLong(src.get(key).toString()));
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("Invalid " + key + " value found in response"), (Throwable)e);
            }
        }
    }

    private static boolean putIfNotNull(String key, Object srcValue, JSONObject dest) {
        if (srcValue != null) {
            dest.put(key, srcValue);
            return true;
        }
        return false;
    }

    private static void copyAWSEnvironmentValues(JSONObject props, TenantBean<AppCache> tenantBean) {
        MetricsUtils.copyEnvironmentValueIfPresentElseSetEmpty(tenantBean, EnvironmentProperties.KONY_ACCOUNT_ID.name(), "kaid", props);
        MetricsUtils.copyEnvironmentValueIfPresentElseSetEmpty(tenantBean, EnvironmentProperties.ENVIRONMENT_ID.name(), "eid", props);
        MetricsUtils.copyEnvironmentValueIfPresentElseSetEmpty(tenantBean, S3Config.AMAZON_ACCOUNT_ID.name(), "awsid", props);
        MetricsUtils.copyEnvironmentValueIfPresentElseSetEmpty(tenantBean, S3Config.AMAZON_EBS_ID.name(), "ebid", props);
    }

    private static void copyReportingParams(HttpServletRequest request, JSONObject src, JSONObject dest) {
        MetricsUtils.copyValueIfPresent("aid", src, dest, true);
        MetricsUtils.copyValueIfPresent("aname", src, dest, true);
        MetricsUtils.copyValueIfPresent("chnl", src, dest, true);
        MetricsUtils.copyValueIfPresent("did", src, dest, true);
        MetricsUtils.copyValueIfPresent("atype", src, dest, true);
        MetricsUtils.copyValueIfPresent("plat", src, dest, true);
        MetricsUtils.copyValueIfPresent("xmode", src, dest, true);
        dest.put("fid", (Object)"");
        MetricsUtils.copyValueIfPresent("fid", src, dest);
        dest.put("ts", (Object)CloudUtils.getDateUTCString(new Date()));
        MetricsUtils.copyValueIfPresent("dm", src, dest, true);
        MetricsUtils.copyValueIfPresent("os", src, dest, true);
        String sid = CloudUtils.getCloudSID(request, src);
        if (StringUtils.isNotBlank((String)sid)) {
            dest.put("sid", (Object)sid);
        } else {
            LOGGER.debug((Object)"sid missing in service logging ");
        }
        MetricsUtils.copyHashKeyIfPresentElseSetEmpty("kuid", src, dest);
        if (src.has("ua") && src.getString("ua").length() > 0) {
            dest.put("ua", src.get("ua"));
        } else if (request.getHeader("user-agent") != null) {
            dest.put("ua", (Object)request.getHeader("user-agent"));
        } else {
            LOGGER.debug((Object)"ua missing in service logging ");
        }
        MetricsUtils.copyValueIfPresent("stype", src, dest, true);
        MetricsUtils.copyValueIfPresent("aver", src, dest, true);
        MetricsUtils.copyValueIfPresent("sdktype", src, dest);
        MetricsUtils.copyValueIfPresent("sdkversion", src, dest);
        MetricsUtils.copyValueIfPresent("mfaid", src, dest);
        MetricsUtils.copyValueIfPresent("mfbaseid", src, dest);
        MetricsUtils.copyValueIfPresent("mfaname", src, dest);
        MetricsUtils.copyValueIfPresent("sessiontype", src, dest);
    }

    private static void copyValueIfPresent(String key, JSONObject src, JSONObject dest) {
        MetricsUtils.copyValueIfPresent(key, src, dest, false);
    }

    private static void copyValueIfPresent(String key, JSONObject src, JSONObject dest, boolean logOnMissing) {
        if (src.has(key)) {
            dest.put(key, src.get(key));
        } else if (logOnMissing) {
            LOGGER.debug((Object)(key + " is missing"));
        }
    }

    public static void copyValueIfPresentElseSetEmpty(String key, JSONObject src, JSONObject dest) {
        if (!MetricsUtils.copyValueIfPresentWithoutEmpty(key, src, dest)) {
            dest.put(key, (Object)"");
            LOGGER.debug((Object)(key + " is missing"));
        }
    }

    public static boolean copyValueIfPresentWithoutEmpty(String key, JSONObject src, JSONObject dest) {
        if (src.has(key)) {
            dest.put(key, src.get(key));
            return true;
        }
        return false;
    }

    public static boolean copyValueIfPresentAndNotEmpty(String key, JSONObject src, JSONObject dest) {
        String value = src.optString(key);
        if (StringUtils.isNotBlank((String)value)) {
            dest.put(key, (Object)value);
            return true;
        }
        return false;
    }

    private static void copyEnvironmentValueIfPresentElseSetEmpty(TenantBean<AppCache> tenantBean, String srcKey, String destKey, JSONObject dest) {
        String value = tenantBean.getEnvProperty(srcKey);
        if (value != null) {
            dest.put(destKey, (Object)value);
        } else {
            dest.put(destKey, (Object)"");
            LOGGER.debug((Object)(destKey + " is missing"));
        }
    }

    public static void copyHashKeyIfPresentElseSetEmpty(String key, JSONObject src, JSONObject dest) {
        if (!MetricsUtils.copyHashValueIfPresent(key, src, dest)) {
            dest.put(key, (Object)"");
            LOGGER.debug((Object)(key + " is missing"));
        }
    }

    private static boolean copyHashValueIfPresent(String key, JSONObject src, JSONObject dest) {
        if (src.has(key)) {
            if (MetricsUtils.isEncodePIIEnabled()) {
                dest.put(key, (Object)MetricsUtils.getCRC32Hash((String)src.get(key)));
            } else {
                dest.put(key, src.get(key));
            }
            return true;
        }
        return false;
    }

    static void addServiceTypeAndConnectorType(JSONObject props, RequestData requestData, HttpServletRequest request, MetricsBean metricsBean) {
        block6: {
            block7: {
                ServiceMetadata serviceMetadata;
                block5: {
                    serviceMetadata = requestData.getServiceMetadata();
                    if (StringUtils.isNotBlank((String)((String)metricsBean.getParam("svctype")))) {
                        props.put("svctype", metricsBean.getParam("svctype"));
                    }
                    if (metricsBean.getParam("oname") == null || !"not applicable".equalsIgnoreCase(metricsBean.getParam("oname").toString())) break block5;
                    LOGGER.debug((Object)"contype is set to not applicable as the service metadata is not available for object service level call");
                    props.put("contype", (Object)"not applicable");
                    break block6;
                }
                if (serviceMetadata == null) break block7;
                String conType = serviceMetadata.getService().getServiceType();
                switch (MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.valueOf(conType)) {
                    case dataAdapterConnector: {
                        String daShortName = MetricsUtils.getDAShortName((String)metricsBean.getParam("contype"));
                        if (StringUtils.isNotBlank((String)daShortName)) {
                            props.put("contype", (Object)daShortName);
                            break;
                        }
                        break block6;
                    }
                    default: {
                        props.put("contype", (Object)MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.valueOf(conType).getShortName());
                        break;
                    }
                }
                break block6;
            }
            LOGGER.error((Object)"contype will not be sent to metrics as service metadata will be null");
        }
    }

    private static String getDAShortName(String attribute) {
        if (StringUtils.isNotBlank((String)attribute)) {
            for (DataAdapterNames dataAdapter : DataAdapterNames.values()) {
                String[] adapterNames = dataAdapter.getAdapterNames();
                attribute = Arrays.asList(adapterNames).contains(attribute) ? dataAdapter.name() : attribute;
            }
        }
        return attribute;
    }

    public static String getMetricsBatchEntryId(UUID guid) {
        String guidStr = guid.toString().replaceAll("\\-", "");
        String str36 = new BigInteger(guidStr, 16).toString(36);
        return StringUtils.leftPad((String)str36, (int)25, (String)"0");
    }

    private static String getXForwardedIP(HttpServletRequest request, String remote_ip) {
        String xff = request.getHeader("X-Forwarded-For");
        return xff != null ? xff.split("[\\s,]+")[0] : remote_ip;
    }

    public static JSONArray getDates(String key, JSONObject json, List<JSONArray> eventsJsonList) throws Exception {
        JSONArray datesArray = new JSONArray();
        if (json != null && json.has(key)) {
            datesArray = json.getJSONArray(key);
            LOGGER.debug((Object)(key + " dates size " + datesArray.length()));
        } else if (MetricsUtils.isNullOrEmpty(eventsJsonList)) {
            throw new Exception("Cloud session and event logging report is null. ");
        }
        return datesArray;
    }

    public static <T> boolean isNullOrEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    public static JSONArray getEventsArray(JSONObject json) throws JSONException {
        return json != null && json.has("events") ? json.getJSONArray("events") : null;
    }

    public static void setEventRelatedParams(JSONObject json, JSONObject props, JSONArray jsonArray) throws JSONException {
        String currentSID = props.getString("sid");
        String rsID = MetricsUtils.getEventCloudSID(json);
        if (StringUtils.isNotBlank((String)rsID)) {
            props.put("sid", (Object)rsID);
        } else if (StringUtils.isEmpty((String)currentSID)) {
            LOGGER.error((Object)"sid is missing ");
        }
        props.put("ts", (Object)CloudUtils.getDateUTCString(new Date()));
    }

    private static String getEventCloudSID(JSONObject json) throws JSONException {
        String sid = null;
        if (json.has("rsid")) {
            sid = json.getString("rsid");
        }
        if (StringUtils.isBlank(sid) && json.has("sid")) {
            sid = json.getString("sid");
        }
        return sid;
    }

    public static void logEventsForDebugging(JSONObject props) {
        String clientIp = props.optString("rip", "unknown client");
        String deviceId = props.optString("did", "unknown device");
        JSONArray events = props.getJSONArray("events");
        for (int i = 0; i < events.length(); ++i) {
            JSONObject event = events.getJSONObject(i);
            String eventType = event.optString("evttype");
            if ((MetricsUtils.isMetricsLogClientCrashEventsEnabled() || MetricsUtils.isMetricsLogClientEventsEnabled()) && "crash".equalsIgnoreCase(eventType)) {
                LOGGER.error((Object)String.format("Client crash from IP=%s, Device=%s: %s", clientIp, deviceId, event));
                continue;
            }
            if (!MetricsUtils.isMetricsLogClientEventsEnabled() || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)String.format("Client event from IP=%s, Device=%s: %s", clientIp, deviceId, event));
        }
    }

    public static void setEnvironmentDetails(JSONObject props, TenantBean<AppCache> tenantBean) throws JSONException {
        MetricsUtils.copyEnvironmentValueIfPresentElseSetEmpty(tenantBean, EnvironmentProperties.KONY_ACCOUNT_ID.name(), "kaid", props);
        MetricsUtils.copyEnvironmentValueIfPresentElseSetEmpty(tenantBean, EnvironmentProperties.ENVIRONMENT_ID.name(), "eid", props);
        MetricsUtils.copyEnvironmentValueIfPresentElseSetEmpty(tenantBean, S3Config.AMAZON_ACCOUNT_ID.name(), "awsid", props);
        MetricsUtils.copyEnvironmentValueIfPresentElseSetEmpty(tenantBean, S3Config.AMAZON_EBS_ID.name(), "ebid", props);
    }

    public static void addResponseInfoToMetricsBean(HttpServletRequest request, long startTimeOfResponseProcessing, JsonObject responseJson, int totalRecords, String errMessage, String stackTrace) {
        LOGGER.debug((Object)"adding response attributes to the metrics bean");
        MetricsBean metricsBean = (MetricsBean)request.getAttribute("metricsBean");
        if (startTimeOfResponseProcessing > 0L && metricsBean != null) {
            metricsBean.incrementParamValue("respprsdur", System.currentTimeMillis() - startTimeOfResponseProcessing);
        }
        if (responseJson != null) {
            if (metricsBean != null) {
                metricsBean.incrementParamValue("respbytes", (long)new Gson().toJson((JsonElement)responseJson).getBytes().length);
            }
            boolean isError = false;
            String opstatus = "";
            if (responseJson.has("opstatus") && responseJson.get("opstatus").getAsInt() != 0) {
                isError = true;
                totalRecords = 0;
                opstatus = responseJson.get("opstatus");
            }
            MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"iserror", (Object)isError);
            MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"errcode", (Object)opstatus);
        }
        if (errMessage != null) {
            MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"errmsg", (Object)errMessage);
            MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"errstack", (Object)stackTrace);
        }
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"trecords", (Object)totalRecords);
    }

    private MetricsUtils() {
    }
}

