/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.logservice;

import com.kony.mobilefabric.cloudqueue.CloudQueue;
import com.kony.mobilefabric.cloudqueue.impl.AWSCloudQueue;
import com.konylabs.middleware.common.S3Config;
import com.konylabs.middleware.connectors.logservice.AbstractQueueService;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SQSLogService
extends AbstractQueueService {
    private static final Logger LOGGER = Logger.getLogger(SQSLogService.class);
    private final String sqsQueueUrl = ConfigUtility.getProperty((String)S3Config.SQS_QUEUE_URL.name());
    private final long batchSizeInBytes;
    private final CloudQueue metricsQueue;
    private CloudQueue jobNotifcationQueue;

    private SQSLogService() {
        String batchSizeProp = ConfigUtility.getProperty((String)S3Config.EVENTS_MAXSIZE_BYTES.name());
        this.batchSizeInBytes = NumberUtils.toLong((String)batchSizeProp, (long)204800L);
        this.metricsQueue = new AWSCloudQueue(this.sqsQueueUrl);
        this.metricsQueue.startAsyncThread();
        String jobNotificationSQSUrl = ConfigUtility.getProperty((String)S3Config.JOB_NOTIFICATION_SQS_QUEUE_URL.name());
        if (StringUtils.isNotBlank((String)jobNotificationSQSUrl)) {
            this.jobNotifcationQueue = new AWSCloudQueue(jobNotificationSQSUrl);
        }
    }

    public static SQSLogService getInstance() {
        return SQSLogServiceHolder.instance;
    }

    @Override
    public boolean isJobsNotificationQueueConfigured() {
        return this.jobNotifcationQueue != null;
    }

    @Override
    public boolean pushMessage(JSONObject message) {
        try {
            String requestId = MetricsUtils.getMetricsBatchEntryId(UUID.randomUUID());
            String body = message.toString();
            LOGGER.debug((Object)("service reporting pushing into MessageQueue with requestid : " + requestId + " and message : " + body));
            this.metricsQueue.prepareQueueForAsyncSendMessage(body, requestId);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while pushing message into queue with name " + this.sqsQueueUrl), (Throwable)e);
        }
        return true;
    }

    @Override
    protected List<JSONArray> splitEventsIntoBatches(JSONArray events) {
        return MetricsUtils.splitEventsIntoBatches(events, this.batchSizeInBytes);
    }

    @Override
    public void pushJobNotificationMessage(String jobNotification) {
        try {
            LOGGER.debug((Object)("Job Notification Message : " + jobNotification));
            String messageId = this.jobNotifcationQueue.sendMessage(jobNotification);
            if (StringUtils.isNotBlank((String)messageId)) {
                LOGGER.debug((Object)("Successfully placed your message and message id : " + messageId));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while pushing job notification message to job queue ", (Throwable)e);
        }
    }

    @Override
    public void shutdownQueueClient() {
        this.metricsQueue.shutdownClient();
        if (this.jobNotifcationQueue != null) {
            this.jobNotifcationQueue.shutdownClient();
        }
    }

    @Override
    public void destroy() {
        this.metricsQueue.stopAsyncThread();
    }

    private static class SQSLogServiceHolder {
        private static SQSLogService instance = new SQSLogService();

        private SQSLogServiceHolder() {
        }
    }
}

