/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.postprocessor;

import com.kony.mapper.javascript.JavaScriptEngineWrapper;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.cloud.CloudUtils;
import com.konylabs.middleware.connectors.postprocessor.PostProcessor;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.js.JavaScriptExecutorUtil;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.util.Map;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class PostProcessUtils {
    private static final Logger LOGGER = Logger.getLogger(PostProcessor.class);

    public static Result execute(Service service, Map<String, Object> config, Result results, DataControllerRequest request, DataControllerResponse response, AppVersion appVersion) throws ConnectorException {
        Result newResults = results;
        if (CloudUtils.isCustomCodeEnabled()) {
            LOGGER.debug((Object)"PostProcessUtils Called");
            String processorName = (String)config.get("postprocessorname");
            String postProcessorJavaScript = (String)config.get("postprocessorJS");
            boolean foundJavaPostProc = false;
            boolean foundJavaScriptPostProc = false;
            if (StringUtils.isNotBlank((String)postProcessorJavaScript)) {
                foundJavaScriptPostProc = true;
                LOGGER.debug((Object)"Found JavaScript for post processor");
                Object resultObj = null;
                try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.POST_PROCESSOR, "postProcessorDur");){
                    JavaScriptEngineWrapper jsEngineWrapper = TenantUtilities.getJavaScriptEngineFromRequest(request);
                    ScriptContext scriptContext = JavaScriptExecutorUtil.createScriptContext(request, response, newResults, null, LOGGER);
                    resultObj = JavaScriptExecutorUtil.execute(jsEngineWrapper, appVersion, postProcessorJavaScript, scriptContext);
                }
                if (resultObj != null && resultObj instanceof Result) {
                    newResults = (Result)resultObj;
                }
            }
            if (StringUtils.isNotBlank((String)processorName)) {
                foundJavaPostProc = true;
                LOGGER.debug((Object)("postprocessorname :" + processorName));
                newResults = PostProcessor.getInstance().execute(service, processorName, results, request, response);
            }
            if (!foundJavaPostProc && !foundJavaScriptPostProc) {
                LOGGER.debug((Object)"Could not find Java / JavaScript post processor");
            }
        }
        return newResults;
    }

    private PostProcessUtils() {
    }
}

