/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.postprocessor;

import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.middleware.classloader.ClassLoaderUtils;
import com.konylabs.middleware.common.DataPostProcessor;
import com.konylabs.middleware.common.DataPostProcessor2;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.MetricsException;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import org.apache.log4j.Logger;

public class PostProcessor {
    private static final Logger LOGGER = Logger.getLogger(PostProcessor.class);
    private static final PostProcessor _postProcessor = new PostProcessor();

    private PostProcessor() {
    }

    public static PostProcessor getInstance() {
        return _postProcessor;
    }

    public Result execute(Service service, String className, Result results, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        String jarModule;
        Object dataPostProcessorObj;
        LOGGER.debug((Object)"PostProcessor Service Called");
        int httpStatusCode = -1;
        String serviceId = null;
        if (request != null) {
            serviceId = request.getParameter("serviceID");
        }
        if (response != null && response.getStatusCode() != 0) {
            httpStatusCode = response.getStatusCode();
        }
        if ((dataPostProcessorObj = ClassLoaderUtils.getCustomClassInstance(serviceId, jarModule = MiddlewareUtils.getJarModuleNameFromService(service), className)) == null) {
            LOGGER.error((Object)("Unable to create object for classname:" + className));
            throw new ConnectorException("PostProcessor", "8018", httpStatusCode, "Unable to instantiate Object for service " + serviceId);
        }
        Object resultObj = null;
        try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.POST_PROCESSOR, "postProcessorDur");){
            if (dataPostProcessorObj instanceof DataPostProcessor) {
                resultObj = ((DataPostProcessor)dataPostProcessorObj).execute(results, request);
            } else if (dataPostProcessorObj instanceof DataPostProcessor2) {
                resultObj = ((DataPostProcessor2)dataPostProcessorObj).execute(results, request, response);
            }
        }
        catch (MetricsException mex) {
            MaskUtils.maskTrace((String)("Metrics Exception while invoking the post processor, " + mex.getErrorCode()), (Throwable)mex);
            throw new ConnectorException("PostProcessor", mex.getErrorCode(), httpStatusCode, mex.getMessage(), (Throwable)mex);
        }
        catch (Throwable ex) {
            MaskUtils.maskTrace((String)("MW8004: Error occurred while invoking the post processor: " + ex.getMessage()), (Throwable)ex);
            throw new ConnectorException("PostProcessor", "8004", httpStatusCode, "Error occurred while invoking the post processor for service " + serviceId, ex);
        }
        Result newResults = null;
        try {
            newResults = (Result)resultObj;
        }
        catch (ClassCastException ex) {
            LOGGER.error((Object)("MW8008: Invalid Result object: " + ex.getMessage()), (Throwable)ex);
            throw new ConnectorException("PostProcessor", "8008", httpStatusCode, "Invalid Result object returned on method invocation for service " + serviceId, (Throwable)ex);
        }
        return newResults;
    }
}

