/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.preprocessor;

import com.kony.mapper.javascript.JavaScriptEngineWrapper;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.cloud.CloudUtils;
import com.konylabs.middleware.connectors.preprocessor.PreProcessor;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.js.JavaScriptExecutorUtil;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class PreProcessUtils {
    private static final Logger LOGGER = Logger.getLogger(PreProcessUtils.class);

    public static boolean execute(Service service, Map<String, Object> config, Map<String, Object> inputMap, DataControllerRequest request, DataControllerResponse response, Result result, AppVersion appVersion) throws ConnectorException {
        boolean valid = true;
        if (CloudUtils.isCustomCodeEnabled()) {
            LOGGER.debug((Object)"PreProcessUtils Called");
            String processorName = (String)config.get("preprocessorname");
            String preProcessorJavaScript = (String)config.get("preprocessorJS");
            boolean foundJavaPreProc = false;
            boolean foundJavaScriptPreProc = false;
            if (StringUtils.isNotBlank((String)preProcessorJavaScript)) {
                foundJavaScriptPreProc = true;
                Object retFlag = null;
                LOGGER.debug((Object)"Found Java Script for PreProcessor");
                try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.PRE_PROCESSOR, "preProcessorDur");){
                    JavaScriptEngineWrapper jsEngineWrapper = TenantUtilities.getJavaScriptEngineFromRequest(request);
                    ScriptContext scriptContext = JavaScriptExecutorUtil.createScriptContext(request, response, result, inputMap, LOGGER);
                    retFlag = JavaScriptExecutorUtil.execute(jsEngineWrapper, appVersion, preProcessorJavaScript, scriptContext);
                }
                if (Boolean.FALSE.equals(retFlag)) {
                    LOGGER.debug((Object)"PreProcessor JS returned false ...Aborting the Execution of the Service Invokation");
                    return false;
                }
            }
            if (StringUtils.isNotBlank((String)processorName)) {
                foundJavaPreProc = true;
                LOGGER.debug((Object)("preprocessorname :" + processorName));
                if (inputMap instanceof HashMap) {
                    valid = PreProcessor.getInstance().execute(service, processorName, (HashMap)inputMap, request, response, result);
                }
            }
            if (!foundJavaPreProc && !foundJavaScriptPreProc) {
                LOGGER.debug((Object)"Could not find Java / Java Script Preprocessors");
            }
        }
        return valid;
    }

    private PreProcessUtils() {
    }
}

