/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.preprocessor;

import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.middleware.classloader.ClassLoaderUtils;
import com.konylabs.middleware.common.DataPreProcessor;
import com.konylabs.middleware.common.DataPreProcessor2;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.MetricsException;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PreProcessor {
    private static final Logger LOGGER = Logger.getLogger(PreProcessor.class);
    private static final PreProcessor _preProcessor = new PreProcessor();

    private PreProcessor() {
    }

    public static PreProcessor getInstance() {
        return _preProcessor;
    }

    public boolean execute(Service service, String className, HashMap<String, Object> inputMap, DataControllerRequest request, DataControllerResponse response, Result result) throws ConnectorException {
        String jarModule;
        Object dataPreProcessorObj;
        LOGGER.debug((Object)"PreProcessor Service Called");
        boolean valid = false;
        String serviceId = null;
        if (request != null) {
            serviceId = request.getParameter("serviceID");
        }
        if ((dataPreProcessorObj = ClassLoaderUtils.getCustomClassInstance(serviceId, jarModule = MiddlewareUtils.getJarModuleNameFromService(service), className)) == null) {
            LOGGER.error((Object)("8018: Unable to instantiate object for classname:" + className));
            throw new ConnectorException("PreProcessor", "8018", "Unable to instantiate Object for service " + serviceId);
        }
        try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.PRE_PROCESSOR, "preProcessorDur");){
            if (dataPreProcessorObj instanceof DataPreProcessor) {
                valid = ((DataPreProcessor)dataPreProcessorObj).execute(inputMap, request, result);
            } else if (dataPreProcessorObj instanceof DataPreProcessor2) {
                valid = ((DataPreProcessor2)dataPreProcessorObj).execute(inputMap, request, response, result);
            }
        }
        catch (MetricsException mex) {
            MaskUtils.maskTrace((String)("Metrics Exception while invoking the pre processor, " + mex.getErrorCode()), (Throwable)mex);
            throw new ConnectorException("PreProcessor", mex.getErrorCode(), mex.getMessage(), (Throwable)mex);
        }
        catch (Throwable ex) {
            MaskUtils.maskTrace((String)"MW8004: Error occurred while invoking the pre processor.", (Throwable)ex);
            throw new ConnectorException("PreProcessor", "8004", "Error occurred while invoking the pre processor for service " + serviceId, ex);
        }
        return valid;
    }
}

