/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.sap;

import com.konylabs.middleware.utilities.DigestUtil;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class Provider
implements DestinationDataProvider {
    private static final Map<String, Properties> _properties = new HashMap<String, Properties>();
    private static DestinationDataProvider provider = null;
    private DestinationDataEventListener destinationDataEventListener;

    private Provider() {
    }

    public static boolean addDestination(Properties properties) {
        String key = Provider.prepareDestKey(properties);
        Properties addedProp = _properties.put(key, properties);
        return addedProp != null;
    }

    public Properties getDestinationProperties(String name) {
        return _properties.get(name) != null ? (Properties)_properties.get(name).clone() : null;
    }

    public static DestinationDataProvider getInstance() {
        if (provider == null) {
            provider = new Provider();
        }
        return provider;
    }

    public void setDestinationDataEventListener(DestinationDataEventListener listener) {
        this.destinationDataEventListener = listener;
    }

    public DestinationDataEventListener getDestinationDataEventListener() {
        return this.destinationDataEventListener;
    }

    public boolean supportsEvents() {
        return false;
    }

    public void changeProperties(Properties localProperties) {
        if (localProperties != null) {
            String key = Provider.prepareDestKey(localProperties);
            _properties.put(key, localProperties);
        }
    }

    public static String prepareDestKey(Map<Object, Object> props) {
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(props);
        return DigestUtil.digest(((Object)treeMap).toString());
    }
}

