/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.sap;

import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.asset.AssetType;
import com.konylabs.middleware.common.Base64Coder;
import com.konylabs.middleware.config.DatasourcePayloadLogger;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.postprocessor.PostProcessUtils;
import com.konylabs.middleware.connectors.preprocessor.PreProcessUtils;
import com.konylabs.middleware.connectors.sap.Provider;
import com.konylabs.middleware.connectors.sap.SAPConnectorUtils;
import com.konylabs.middleware.connectors.sap.VtiIdentityServiceForSapSsoToken;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Dataset;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Record;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.registry.vo.ServiceInput;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.AnnotationUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecordFieldIterator;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.BasicRepository;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SAPConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(SAPConnector.class);
    public boolean isSSOEnabled = false;
    public static String reqSAPSSOToken = null;
    private static final String TRANSACTION_COMMIT_BAPI = "BAPI_TRANSACTION_COMMIT";
    private static final String TRANSACTION_ROLLBACK_BAPI = "BAPI_TRANSACTION_ROLLBACK";

    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        long serviceTime = 0L;
        long startTime = 0L;
        long tempTime = 0L;
        Map<String, Object> config = MiddlewareUtils.populateConfigMap(service);
        String propertiesFile = (String)config.get("sapserverfile");
        if (StringUtils.isBlank((String)propertiesFile)) {
            LOGGER.debug((Object)"'sapserverfile' config value is missing in service config");
            throw new ConnectorException("SAPConnector", "8710", "SAP server properties are missing from server configuration.");
        }
        JCoDestination dest = null;
        Properties defaultConfig = null;
        ApplicationMetadata appMetadata = ObjectServiceUtil.getApplicationMetadataFromService(service);
        if (appMetadata != null) {
            defaultConfig = (Properties)appMetadata.getAssetByName(AssetType.SAPJCO.getType(), propertiesFile);
        }
        if (defaultConfig == null) {
            defaultConfig = SAPConnectorUtils.getProperties(propertiesFile);
        }
        if (defaultConfig == null) {
            LOGGER.error((Object)"SAP server properties are missing for connecting to SAP system.");
            throw new ConnectorException("SAPConnector", "8713", "SAP server properties are missing for connecting to SAP system.");
        }
        this.isSSOEnabled = Boolean.valueOf(defaultConfig.getProperty("ssotoken_enabled"));
        String username = null;
        String password = null;
        Result result = new Result();
        com.konylabs.middleware.dataobject.Param logInParam = new com.konylabs.middleware.dataobject.Param();
        logInParam.setName(service.getId());
        HashMap<String, Object> inputParams = this.processInputParam(service, request);
        String userDestKey = MiddlewareUtils.prepareDestKey(defaultConfig);
        Session session = request.getSession();
        if ("login".equals(config.get("opcode"))) {
            username = request.getParameter("username");
            password = request.getParameter("password");
            if (StringUtils.isBlank((String)username) && StringUtils.isBlank((String)password)) {
                username = (String)inputParams.get("username");
                password = (String)inputParams.get("password");
            }
            defaultConfig = this.addToDestination(defaultConfig, username, password);
            BasicRepository repository = null;
            try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis");){
                dest = this.getDestination(session, defaultConfig, username, password, userDestKey);
                repository = (BasicRepository)dest.getRepository();
                if (repository != null) {
                    session.setAttribute(userDestKey, (Object)dest);
                    result.addParam(new com.konylabs.middleware.dataobject.Param("opstatus", "0", "int"));
                    result.addParam(new com.konylabs.middleware.dataobject.Param("httpStatusCode", "200", "int"));
                    logInParam.setValue("logged in successfully");
                }
            }
            catch (JCoException ex) {
                AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, (Exception)((Object)ex));
                MaskUtils.maskTrace((String)"JCO Exception occurred:", (Throwable)ex);
                LOGGER.error((Object)ex.getKey(), (Throwable)ex);
                throw new ConnectorException("SAPConnector", "8703", ex.getMessage(), (Throwable)ex);
            }
            catch (IOException ex) {
                AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, ex);
                MaskUtils.maskTrace((String)"IO Exception occurred:", (Throwable)ex);
                LOGGER.error((Object)"IO Exception Occurred", (Throwable)ex);
                return result;
            }
            result.addParam(logInParam);
            return result;
        }
        if ("logout".equals(config.get("opcode"))) {
            LOGGER.debug((Object)"LOGOUT is invoked and remove SAP Destination from session");
            com.konylabs.middleware.dataobject.Param logOutParam = new com.konylabs.middleware.dataobject.Param();
            logOutParam.setName(service.getId());
            if (session.getAttribute(userDestKey) == null) {
                LOGGER.debug((Object)"Loggout failed due. No user logged in the current session");
                throw new ConnectorException("SAPConnector", "8718", "Session Expired or User needs to be logged in, to perform log out!");
            }
            session.removeAttribute(userDestKey);
            session.removeAttribute("SAP_SSOTOKEN".concat(userDestKey));
            result.addParam(new com.konylabs.middleware.dataobject.Param("opstatus", "0", "int"));
            result.addParam(new com.konylabs.middleware.dataobject.Param("httpStatusCode", "200", "int"));
            logOutParam.setValue("logout successfully");
            result.addParam(logOutParam);
            return result;
        }
        AppVersion appVersion = MiddlewareUtils.getAppVersionFromService(service);
        try {
            boolean excuteService;
            dest = (JCoDestination)session.getAttribute(userDestKey);
            if (dest == null) {
                LOGGER.debug((Object)"Unable to find the user session");
                if (this.isSSOEnabled()) {
                    throw new ConnectorException("SAPConnector", "8716", "User session not found. Please login first inorder to use the services");
                }
                LOGGER.debug((Object)"Going to backward compatability");
                username = request.getParameter("username");
                password = request.getParameter("password");
                defaultConfig = this.addToDestination(defaultConfig, username, password);
                startTime = System.currentTimeMillis();
                dest = this.getDestination(session, defaultConfig, username, password, null);
                tempTime = System.currentTimeMillis() - startTime;
            }
            if (!(excuteService = PreProcessUtils.execute(service, config, inputParams, request, response, result, appVersion))) {
                Result result2 = result;
                return result2;
            }
            inputParams.remove("username");
            inputParams.remove("password");
            startTime = System.currentTimeMillis();
            DatasourcePayloadLogger.log("SAPConnector Datasource Payload request for Service Id : %s", service.getId());
            DatasourcePayloadLogger.log("SAPConnector Datasource Payload request input parameters : %s ", inputParams);
            result = this.invoke(service.getId(), inputParams, dest, service.getServiceConfig().getServiceConfig());
        }
        catch (AbapException ex) {
            AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, (Exception)((Object)ex));
            MaskUtils.maskTrace((String)"ABAP Exception occurred:", (Throwable)ex);
            throw new ConnectorException("SAPConnector", "8704", "Request failed with Abap Exception: " + ex.getMessage(), (Throwable)ex);
        }
        catch (JCoException ex) {
            AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, (Exception)((Object)ex));
            MaskUtils.maskTrace((String)"JCO Exception occurred:", (Throwable)ex);
            LOGGER.error((Object)ex.getKey(), (Throwable)ex);
            throw new ConnectorException("SAPConnector", "8703", ex.getMessage(), (Throwable)ex);
        }
        catch (JCoRuntimeException ex) {
            AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, (Exception)((Object)ex));
            MaskUtils.maskTrace((String)"JCoRuntimeException occurred:", (Throwable)ex);
            throw new ConnectorException("SAPConnector", "8705", "Request failed with JCoRuntimeException: " + ex.getMessage(), (Throwable)ex);
        }
        catch (ConnectorException ex) {
            AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, ex);
            MaskUtils.maskTrace((String)"Request failed with exception", (Throwable)ex);
            LOGGER.error((Object)"Exception occurred in SAP system, while processing BAPI function module. ", (Throwable)ex);
            throw new ConnectorException("SAPConnector", "8702", "Exception occurred in SAP system, while processing BAPI function module. ", (Throwable)ex);
        }
        finally {
            serviceTime = tempTime + System.currentTimeMillis() - startTime;
            MWMetricsTimer.manualUpdate(request, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis", serviceTime);
        }
        if (result != null) {
            result = PostProcessUtils.execute(service, config, result, request, response, appVersion);
            if (this.isSSOEnabled) {
                String ssotoken = (String)session.getAttribute("SAP_SSOTOKEN".concat(userDestKey));
                if (ssotoken != null) {
                    com.konylabs.middleware.dataobject.Param ssoParam = new com.konylabs.middleware.dataobject.Param();
                    ssoParam.setName("SAP_SSOTOKEN");
                    ssoParam.setValue(ssotoken);
                    result.addParam(ssoParam);
                } else {
                    LOGGER.error((Object)"SSO Token doesn't not exists in the session");
                    throw new ConnectorException("SAPConnector", "8720", -1, "SSO Token doesn't not exists in the session");
                }
            }
        }
        return result;
    }

    private JCoDestination getDestination(Session session, Properties defaultConfig, String username, String password, String userDestKey) throws JCoException, IOException, ConnectorException {
        JCoDestination dest = null;
        String SSOToken = null;
        if (this.isSSOEnabled()) {
            SSOToken = this.getSSOToken(session, defaultConfig, username, password, userDestKey);
            String host = defaultConfig.getProperty("jco.client.ashost");
            String sysnum = defaultConfig.getProperty("jco.client.sysnr");
            String client = defaultConfig.getProperty("jco.client.client");
            String lang = defaultConfig.getProperty("jco.client.lang");
            dest = VtiIdentityServiceForSapSsoToken.createJcoDestination(SSOToken, host, sysnum, client, username, lang);
        } else {
            String key = Provider.prepareDestKey(defaultConfig);
            dest = JCoDestinationManager.getDestination((String)key);
        }
        return dest;
    }

    private String getSSOToken(Session session, Properties defaultConfig, String username, String password, String userDestKey) throws ConnectorException {
        String SSOToken = null;
        SSOToken = VtiIdentityServiceForSapSsoToken.getSsoTokenFromPortal(defaultConfig.getProperty("ssotoken_portalHost"), defaultConfig.getProperty("ssotoken_portalPort"), username, password);
        if (SSOToken == null) {
            LOGGER.error((Object)("Problem in getting the SSO Token - Either User/Password/SSO Token/Certificate is not specified for " + defaultConfig.getProperty("ssotoken_portalHost")));
            throw new ConnectorException("SAPConnector", "8717", "Either User/Password/SSO Token/Certificate is not specified for " + defaultConfig.getProperty("ssotoken_portalHost"));
        }
        session.setAttribute("SAP_SSOTOKEN".concat(userDestKey), (Object)SSOToken);
        return SSOToken;
    }

    private Properties addToDestination(Properties defaultConfig, String username, String password) throws ConnectorException {
        if (StringUtils.isBlank((String)username) && StringUtils.isBlank((String)password)) {
            LOGGER.debug((Object)"Provide 'username' and 'password' as a request param");
            throw new ConnectorException("SAPConnector", "8722", "Provide 'username' and 'password' as request params");
        }
        if (StringUtils.isBlank((String)username)) {
            LOGGER.debug((Object)"Provide 'username' as a request param");
            throw new ConnectorException("SAPConnector", "8711", "Please provide SAP server 'username' as a request param");
        }
        if (StringUtils.isBlank((String)password)) {
            LOGGER.debug((Object)"Provide 'password' as a request param.");
            throw new ConnectorException("SAPConnector", "8712", "Please provide SAP server 'password' as a request param.");
        }
        Properties clonedProps = (Properties)defaultConfig.clone();
        clonedProps.put("jco.client.user", username);
        clonedProps.put("jco.client.passwd", password);
        Provider.addDestination(clonedProps);
        return clonedProps;
    }

    private HashMap<String, Object> processInputParam(Service service, DataControllerRequest request) throws ConnectorException {
        ServiceInput serviceInput = service.getServiceInput();
        ArrayList params = serviceInput.getParams();
        ArrayList records = serviceInput.getRecords();
        ArrayList datasets = serviceInput.getDatasets();
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        LOGGER.debug((Object)("Param Size : " + params.size()));
        LOGGER.debug((Object)("Record Size : " + records.size()));
        LOGGER.debug((Object)("Dataset Size : " + datasets.size()));
        try {
            this.populateParams(request, params, inputMap);
            this.populateRecords(request, records, inputMap);
            this.populateDatasets(request, datasets, inputMap);
        }
        catch (ConnectorException e) {
            LOGGER.error((Object)"connector exception occurred", (Throwable)e);
            throw new ConnectorException("SAPConnector", "8714", e.getMessage());
        }
        return inputMap;
    }

    private void populateParams(DataControllerRequest request, ArrayList<Param> params, HashMap<String, Object> inputMap) throws ConnectorException {
        Session session = request.getSession(false);
        if (session == null) {
            LOGGER.error((Object)"Very rare scenario. Did not find an exisitng session when in scrapping connector.");
        }
        for (Param param : params) {
            String source = param.getSource();
            String paramName = param.getName();
            String paramValue = null;
            LOGGER.debug((Object)("Param Source : " + source + " Name: " + paramName));
            if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                paramValue = request.getParameter(paramName);
                MaskUtils.logDebugWithMasking((String)"Param Value", (String)paramName, (String)paramValue);
            } else if ("session".equals(source)) {
                paramValue = (String)session.getAttribute(paramName);
                MaskUtils.logDebugWithMasking((String)"Record Value", (String)paramName, (String)String.valueOf(paramValue));
            } else {
                LOGGER.debug((Object)("Invalid source type " + source + " while preparing request for scraping service"));
                throw new ConnectorException("sapConnector", "8701", "Invalid source to the param for  " + paramName);
            }
            if (StringUtils.isBlank((String)paramValue)) {
                paramValue = param.getValue();
            }
            inputMap.put(paramName, paramValue);
        }
    }

    private void populateRecords(DataControllerRequest request, ArrayList<Record> records, HashMap<String, Object> inputMap) throws ConnectorException {
        Session session = request.getSession(false);
        if (session == null) {
            LOGGER.error((Object)"Very rare scenario. Did not find an exisitng session when in scrapping connector.");
        }
        for (Record record : records) {
            Object paramValue;
            String source = record.getSource();
            String paramName = record.getId();
            LOGGER.debug((Object)("Record Source : " + source + " Name: " + paramName));
            if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                paramValue = request.getParameter(paramName);
                MaskUtils.logDebugWithMasking((String)"Record Value", (String)paramName, (String)paramValue);
                com.konylabs.middleware.dataobject.Record convertedRecord = this.convertJSON2Record((String)paramValue, record.getId());
                inputMap.put(paramName, convertedRecord);
                continue;
            }
            if ("session".equals(source)) {
                paramValue = session.getAttribute(paramName);
                MaskUtils.logDebugWithMasking((String)"Record Value", (String)paramName, (String)String.valueOf(paramValue));
                inputMap.put(paramName, paramValue);
                continue;
            }
            LOGGER.debug((Object)("Invalid source type " + source + " while preparing request for scraping service"));
            throw new ConnectorException("sapConnector", "8701", "Invalid source to the param for  " + paramName);
        }
    }

    private com.konylabs.middleware.dataobject.Record convertJSON2Record(String jsonString, String id) {
        com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
        record.setId(id);
        try {
            if (StringUtils.isBlank((String)jsonString)) {
                jsonString = "{}";
            }
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                record.addParam(new com.konylabs.middleware.dataobject.Param(key, jsonObject.getString(key)));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error occurred while converting JSON to record", (Throwable)ex);
        }
        return record;
    }

    public com.konylabs.middleware.dataobject.Dataset convertJSON2Dataset(String jsonString, String id) {
        com.konylabs.middleware.dataobject.Dataset dataset = new com.konylabs.middleware.dataobject.Dataset();
        dataset.setId(id);
        try {
            JSONArray jsonArray;
            if (StringUtils.isBlank((String)jsonString)) {
                jsonString = "[]";
            }
            if ((jsonArray = new JSONArray(jsonString)) != null) {
                for (int idx = 0; idx < jsonArray.length(); ++idx) {
                    JSONObject jsonObj = (JSONObject)jsonArray.get(idx);
                    com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
                    Iterator it = jsonObj.keys();
                    while (it.hasNext()) {
                        String chKey = (String)it.next();
                        Object obj = jsonObj.get(chKey);
                        if (obj instanceof JSONArray) {
                            com.konylabs.middleware.dataobject.Dataset dset = new com.konylabs.middleware.dataobject.Dataset();
                            dset.setId(chKey);
                            com.konylabs.middleware.dataobject.Record rec = new com.konylabs.middleware.dataobject.Record();
                            for (int i = 0; i < ((JSONArray)obj).length(); ++i) {
                                rec = new com.konylabs.middleware.dataobject.Record();
                                JSONObject jsonOb = (JSONObject)((JSONArray)obj).get(i);
                                Iterator j = jsonOb.keys();
                                while (j.hasNext()) {
                                    String chhKey = (String)j.next();
                                    rec.addParam(new com.konylabs.middleware.dataobject.Param(chhKey, jsonOb.getString(chhKey)));
                                }
                                if (rec.getAllParams().size() <= 0) continue;
                                dset.addRecord(rec);
                            }
                            record.addDataset(dset);
                            continue;
                        }
                        record.addParam(new com.konylabs.middleware.dataobject.Param(chKey, jsonObj.getString(chKey)));
                    }
                    dataset.addRecord(record);
                }
            }
        }
        catch (JSONException jExe) {
            LOGGER.error((Object)"error while converting JSON to dataset", (Throwable)jExe);
        }
        return dataset;
    }

    private void populateDatasets(DataControllerRequest request, ArrayList<Dataset> datasets, HashMap<String, Object> inputMap) throws ConnectorException {
        Session session = request.getSession(false);
        if (session == null) {
            LOGGER.error((Object)"Very rare scenario. Did not find an exisitng session when in scrapping connector.");
        }
        for (Dataset dataset : datasets) {
            Object paramValue;
            String source = dataset.getSource();
            String paramName = dataset.getId();
            LOGGER.debug((Object)("Record Source : " + source + " Name: " + paramName));
            if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                paramValue = request.getParameter(paramName);
                MaskUtils.logDebugWithMasking((String)"Record Value", (String)paramName, (String)paramValue);
                com.konylabs.middleware.dataobject.Dataset convertedDataset = this.convertJSON2Dataset((String)paramValue, paramName);
                inputMap.put(paramName, convertedDataset);
                continue;
            }
            if ("session".equals(source)) {
                paramValue = session.getAttribute(paramName);
                MaskUtils.logDebugWithMasking((String)"Record Value", (String)paramName, (String)String.valueOf(paramValue));
                inputMap.put(paramName, paramValue);
                continue;
            }
            LOGGER.debug((Object)("Invalid source type " + source + " while preparing request for scraping service"));
            throw new ConnectorException("sapConnector", "8701", "Invalid source to the param for  " + paramName);
        }
    }

    public Result invoke(String function, HashMap<String, Object> inputParams, JCoDestination dest, List<ConfigParam> configParams) throws JCoException, ConnectorException {
        JCoParameterList tableParameterList;
        BasicRepository repository = (BasicRepository)dest.getRepository();
        JCoFunction function2 = repository.getFunction(function);
        if (inputParams != null && inputParams.size() > 0) {
            for (Map.Entry<String, Object> next : inputParams.entrySet()) {
                if (next.getValue() instanceof com.konylabs.middleware.dataobject.Record) {
                    com.konylabs.middleware.dataobject.Record rec = (com.konylabs.middleware.dataobject.Record)next.getValue();
                    JCoStructure structure = function2.getImportParameterList().getStructure(rec.getId());
                    SAPConnector.create(rec, structure);
                    continue;
                }
                if (next.getValue() instanceof com.konylabs.middleware.dataobject.Dataset) {
                    com.konylabs.middleware.dataobject.Dataset dataset = (com.konylabs.middleware.dataobject.Dataset)next.getValue();
                    SAPConnector.create(dataset, function2);
                    continue;
                }
                function2.getImportParameterList().setValue(next.getKey(), next.getValue());
            }
        }
        if (JCoContext.isStateful((JCoDestination)dest) || !this.autoCommitEnabled(configParams)) {
            function2.execute(dest);
        } else {
            this.executeAutoCommit(repository, dest, function2);
        }
        Result set = new Result();
        JCoParameterList returned = function2.getExportParameterList();
        if (returned != null) {
            SAPConnector.copyFrom(returned, set);
        }
        if ((tableParameterList = function2.getTableParameterList()) != null) {
            SAPConnector.copyFrom(tableParameterList, set);
        }
        return set;
    }

    private boolean autoCommitEnabled(List<ConfigParam> configParams) {
        for (ConfigParam configParam : configParams) {
            if (!"isAutoCommitEnabled".equals(configParam.getName()) || !StringUtils.isNotBlank((String)configParam.getValue())) continue;
            LOGGER.debug((Object)"AUTO_COMMIT_ENABLED");
            return Boolean.valueOf(configParam.getValue());
        }
        return false;
    }

    private void executeAutoCommit(BasicRepository repository, JCoDestination dest, JCoFunction function2) throws ConnectorException, JCoException {
        LOGGER.debug((Object)"Inside executeAutCommit");
        try {
            JCoFunction bapiTransactionCommit = repository.getFunction(TRANSACTION_COMMIT_BAPI);
            JCoContext.begin((JCoDestination)dest);
            function2.execute(dest);
            bapiTransactionCommit.execute(dest);
        }
        catch (JCoException e) {
            MaskUtils.maskTrace((String)"JCO Exception occurred while executeAutCommit:", (Throwable)e);
            throw new ConnectorException("SAPConnector", "8715", "Auto commit failed with JCO Exception: " + e.getMessage());
        }
        finally {
            JCoContext.end((JCoDestination)dest);
        }
    }

    private static void create(com.konylabs.middleware.dataobject.Record rec, JCoStructure structure) {
        for (com.konylabs.middleware.dataobject.Param param : rec.getAllParams()) {
            structure.setValue(param.getName(), param.getObjectValue());
        }
        for (com.konylabs.middleware.dataobject.Record record : rec.getAllRecords()) {
            JCoStructure structure2 = structure.getStructure(record.getId());
            SAPConnector.create(record, structure2);
        }
        for (com.konylabs.middleware.dataobject.Dataset d : rec.getAllDatasets()) {
            SAPConnector.create(d, structure);
        }
    }

    private static void create(com.konylabs.middleware.dataobject.Dataset dataset, JCoStructure structure) {
        JCoTable table = structure.getTable(dataset.getId());
        SAPConnector.create(dataset, table);
    }

    private static void create(com.konylabs.middleware.dataobject.Dataset dataset, JCoFunction function2) {
        JCoTable table = function2.getTableParameterList().getMetaData().hasField(dataset.getId()) ? function2.getTableParameterList().getTable(dataset.getId()) : function2.getImportParameterList().getTable(dataset.getId());
        SAPConnector.create(dataset, table);
    }

    private static void create(com.konylabs.middleware.dataobject.Dataset dataset, JCoTable table) {
        List records = dataset.getAllRecords();
        table.appendRows(records.size());
        for (com.konylabs.middleware.dataobject.Record record : records) {
            for (com.konylabs.middleware.dataobject.Param param : record.getAllParams()) {
                table.setValue(param.getName(), param.getValue());
            }
            for (com.konylabs.middleware.dataobject.Record rec : record.getAllRecords()) {
                JCoStructure structure2 = table.getStructure(rec.getId());
                SAPConnector.create(rec, structure2);
            }
            for (com.konylabs.middleware.dataobject.Dataset d : record.getAllDatasets()) {
                SAPConnector.create(d, table.getTable(d.getId()));
            }
            table.nextRow();
        }
    }

    private static com.konylabs.middleware.dataobject.Record copyFromStucture(JCoField nextField, com.konylabs.middleware.dataobject.Record record) {
        if (record == null) {
            record = new com.konylabs.middleware.dataobject.Record();
            record.setId(nextField.getName());
        }
        JCoStructure structure = nextField.getStructure();
        JCoRecordFieldIterator fieldIterator2 = structure.getRecordFieldIterator();
        while (fieldIterator2.hasNextField()) {
            JCoField nextField2 = fieldIterator2.nextField();
            if (nextField2.isStructure()) {
                ArrayList<com.konylabs.middleware.dataobject.Record> recs = new ArrayList<com.konylabs.middleware.dataobject.Record>();
                recs.add(SAPConnector.copyFromStucture(nextField2, null));
                record.clearRecords();
                record.addAllRecords(recs);
                continue;
            }
            if (nextField2.isTable()) {
                record.addDataset(SAPConnector.copyFromTable(nextField2));
                continue;
            }
            record.addParam(SAPConnector.createParamFromField(nextField2));
        }
        return record;
    }

    private static com.konylabs.middleware.dataobject.Param createParamFromField(JCoField field) {
        com.konylabs.middleware.dataobject.Param param = new com.konylabs.middleware.dataobject.Param();
        param.setName(field.getName());
        if (field.getValue() != null) {
            Object val = field.getValue();
            if (val instanceof Date) {
                param.setObjectValue(val);
            } else if (val instanceof InputStream) {
                try {
                    byte[] byteArray = IOUtils.toByteArray((InputStream)((InputStream)val));
                    param.setValue(Base64Coder.encodeString((String)new String(byteArray)));
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)"error while converting inputsteam to base64 encoded string ", (Throwable)ioe);
                }
            } else if (val instanceof Reader) {
                try {
                    byte[] byteArray = IOUtils.toByteArray((Reader)((Reader)val));
                    param.setValue(Base64Coder.encodeString((String)new String(byteArray)));
                }
                catch (IOException ioe) {
                    LOGGER.error((Object)"error while converting inputsteam to base64 encoded string ", (Throwable)ioe);
                }
            } else if (val instanceof byte[]) {
                byte[] bytea = (byte[])val;
                param.setValue(String.valueOf(Base64Coder.encode((byte[])bytea)));
            } else {
                param.setValue(String.valueOf(val));
            }
        } else {
            LOGGER.debug((Object)("value null for :" + field.getName()));
        }
        return param;
    }

    private static com.konylabs.middleware.dataobject.Dataset copyFromTable(JCoField nextField) {
        JCoTable table = nextField.getTable();
        com.konylabs.middleware.dataobject.Dataset dataset = new com.konylabs.middleware.dataobject.Dataset();
        dataset.setId(nextField.getName());
        for (int i = 0; i < table.getNumRows(); ++i) {
            table.setRow(i);
            com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
            record.setId(table.getMetaData().getName());
            JCoRecordFieldIterator tableFieldIterator = table.getRecordFieldIterator();
            while (tableFieldIterator.hasNextField()) {
                JCoField nextParamField = tableFieldIterator.nextField();
                if (nextParamField.isStructure()) {
                    SAPConnector.copyFromStucture(nextParamField, record);
                    continue;
                }
                if (nextParamField.isTable()) {
                    record.addDataset(SAPConnector.copyFromTable(nextParamField));
                    continue;
                }
                record.addParam(SAPConnector.createParamFromField(nextParamField));
            }
            dataset.addRecord(record);
        }
        return dataset;
    }

    private static void copyFrom(JCoParameterList parameters, Result result) {
        if (parameters != null) {
            JCoFieldIterator fieldIterator = parameters.getFieldIterator();
            while (fieldIterator.hasNextField()) {
                JCoField nextField = fieldIterator.nextField();
                if (nextField.isStructure()) {
                    result.addRecord(SAPConnector.copyFromStucture(nextField, null));
                    continue;
                }
                if (nextField.isTable()) {
                    result.addDataset(SAPConnector.copyFromTable(nextField));
                    continue;
                }
                result.addParam(SAPConnector.createParamFromField(nextField));
            }
        }
    }

    @Override
    public void setCallingProcessor(Processor processor) {
    }

    public boolean isSSOEnabled() {
        return this.isSSOEnabled;
    }

    public void setSSOEnabled(boolean isSSOEnabled) {
        this.isSSOEnabled = isSSOEnabled;
    }

    public boolean beginTransaction(JCoDestination dest) {
        JCoContext.begin((JCoDestination)dest);
        return JCoContext.isStateful((JCoDestination)dest);
    }

    public boolean commitTransaction(JCoDestination dest) throws JCoException {
        return this.endTransaction(dest, TRANSACTION_COMMIT_BAPI);
    }

    public boolean rollBackTransaction(JCoDestination dest) throws JCoException {
        return this.endTransaction(dest, TRANSACTION_ROLLBACK_BAPI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean endTransaction(JCoDestination dest, String standardBAPIname) throws JCoException {
        boolean success = false;
        try {
            JCoRepository repository = dest.getRepository();
            JCoFunction aStandradFn = repository.getFunction(standardBAPIname);
            aStandradFn.execute(dest);
            success = true;
        }
        finally {
            try {
                JCoContext.end((JCoDestination)dest);
            }
            catch (JCoException ex) {
                LOGGER.warn((Object)"Jco exception while ending the transaction", (Throwable)ex);
            }
        }
        return success;
    }
}

