/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.sap;

import com.konylabs.middleware.common.PropertiesHelper;
import com.konylabs.middleware.connectors.sap.FileListFilter;
import com.konylabs.middleware.connectors.sap.Provider;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class SAPConnectorUtils {
    private static final Logger LOGGER = Logger.getLogger(SAPConnectorUtils.class);
    private static final Map<String, Properties> _propertyLoaderMap = new HashMap<String, Properties>();
    private static final String SAP_CONFIG_DIR = System.getProperty("sap.config.dir");

    public static void initialize(boolean isCmdLine) {
        if (!isCmdLine) {
            SAPConnectorUtils.loadSapProperties();
            SAPConnectorUtils.registerSapDestinationProvider();
        } else {
            SAPConnectorUtils.cmdLineLoadProps();
            SAPConnectorUtils.registerSapDestinationProvider();
        }
    }

    private static void cmdLineLoadProps() {
        LOGGER.debug((Object)"Initalizing SAP Connector utils");
        File _appRegistryFolder = new File(SAP_CONFIG_DIR);
        if (_appRegistryFolder.exists() && _appRegistryFolder.isDirectory()) {
            File[] listFiles;
            for (File file : listFiles = _appRegistryFolder.listFiles()) {
                String fileName = file.getName();
                if (!StringUtils.isNotEmpty((String)fileName)) continue;
                LOGGER.debug((Object)("Loading.." + fileName));
                Properties prop = PropertiesHelper.loadQuietlyFromFile((File)file);
                LOGGER.debug((Object)("Loaded..." + fileName));
                Provider.addDestination(prop);
                _propertyLoaderMap.put(file.getName(), prop);
                LOGGER.debug((Object)"Putting in to stream");
            }
        }
    }

    public static Properties getProperties(String fileName) {
        return _propertyLoaderMap.get(fileName);
    }

    public static void putProperties(String fileName, Properties properties) {
        _propertyLoaderMap.put(fileName, properties);
    }

    public static void loadSapProperties() {
        LOGGER.debug((Object)"Initalizing SAP Connector utils");
        String appRegistryDir = ConfigPathUtil.getAppRegistryDirPath();
        File _appRegistryFolder = new File(appRegistryDir);
        if (_appRegistryFolder.exists() && _appRegistryFolder.isDirectory()) {
            File[] listFiles;
            for (File file : listFiles = _appRegistryFolder.listFiles(new FileListFilter())) {
                String fileName = file.getName();
                if (!StringUtils.isNotEmpty((String)fileName)) continue;
                LOGGER.debug((Object)("Loading.." + fileName));
                Properties prop = PropertiesHelper.loadQuietlyFromFile((File)file);
                LOGGER.debug((Object)("Loaded..." + fileName));
                _propertyLoaderMap.put(file.getName(), prop);
                LOGGER.debug((Object)"Putting in to stream");
            }
        }
    }

    public static void clearProperties() {
        _propertyLoaderMap.clear();
    }

    public static void shutdown() {
        SAPConnectorUtils.clearProperties();
        SAPConnectorUtils.unregisterSapDestinationProvider();
    }

    private SAPConnectorUtils() {
    }

    public static void registerSapDestinationProvider() {
        if (!Environment.isDestinationDataProviderRegistered()) {
            LOGGER.debug((Object)"Registering the Data Provider as it isn't registered");
            Environment.registerDestinationDataProvider((DestinationDataProvider)Provider.getInstance());
        }
    }

    public static void unregisterSapDestinationProvider() {
        Environment.unregisterDestinationDataProvider((DestinationDataProvider)Provider.getInstance());
    }
}

