/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.sap;

import com.konylabs.middleware.common.Base64Coder;
import com.konylabs.middleware.connectors.sap.Provider;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public final class VtiIdentityServiceForSapSsoToken {
    private static final Logger logger = Logger.getLogger(VtiIdentityServiceForSapSsoToken.class);
    private static final String IE6_USER_AGENT_STRING = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)";
    private static DestinationDataProvider jKonyProvider = Provider.getInstance();

    public static String getSsoTokenFromPortal(String portalHost, String portalPort, String user, String paswd) throws ConnectorException {
        String headerKey;
        HttpURLConnection conn = VtiIdentityServiceForSapSsoToken.getUrlString(portalHost, portalPort, user, paswd);
        String sso2Token = null;
        int index = 0;
        block0: while ((headerKey = conn.getHeaderFieldKey(++index)) != null) {
            if (!headerKey.equalsIgnoreCase("Set-Cookie")) continue;
            String cookie = conn.getHeaderField(index);
            StringTokenizer strTok = new StringTokenizer(cookie, ";");
            while (strTok.hasMoreTokens()) {
                String cookieName;
                String token = strTok.nextToken();
                int equalsPos = token.indexOf(61);
                if (equalsPos < 0 || !(cookieName = token.substring(0, equalsPos).trim()).equals("MYSAPSSO2")) continue;
                String cookieValue = equalsPos >= token.length() - 1 ? "" : token.substring(equalsPos + 1).trim();
                sso2Token = EncodeUtils.decode((String)cookieValue);
                break block0;
            }
        }
        return sso2Token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpURLConnection getUrlString(String portalHost, String portalPort, String user, String paswd) throws ConnectorException {
        String urlString = VtiIdentityServiceForSapSsoToken.getSsoUrl(portalHost, portalPort);
        try {
            int responseCode;
            while (true) {
                URL url = new URL(urlString);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", IE6_USER_AGENT_STRING);
                conn.setRequestProperty("Authorization", "Basic " + VtiIdentityServiceForSapSsoToken.getBasicString(user, paswd));
                conn.setInstanceFollowRedirects(false);
                responseCode = conn.getResponseCode();
                if (responseCode == 200) return conn;
                if (responseCode != 301 && responseCode != 302) break;
                String redirectLocation = conn.getHeaderField("Location");
                if (redirectLocation == null || redirectLocation.length() == 0) {
                    logger.error((Object)"!VTI_MSGFMT_PORTAL_REDIRECT_TO_NOWHERE");
                    return null;
                }
                urlString = redirectLocation.replace(' ', '+');
            }
            if (responseCode == 401) return null;
            logger.error((Object)("!VTI_MSGFMT_PORTAL_HTTP_ERROR_RESPONSE " + String.valueOf(responseCode)));
            return null;
        }
        catch (IOException ioe) {
            logger.error((Object)("Problem with network connection, while connecting to given SAP system " + portalHost), (Throwable)ioe);
            throw new ConnectorException("sapConnector", "8719", "Problem with network connection, while connecting to given SAP system  " + portalHost, (Throwable)ioe);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception occurred in connecting to  " + portalHost), (Throwable)ex);
            throw new ConnectorException("sapConnector", "8721", "Problem while connecting to SAP System : " + portalHost, (Throwable)ex);
        }
    }

    static String getBasicString(String user, String paswd) {
        String basicString = user + ":" + paswd;
        return Base64Coder.encodeString((String)basicString);
    }

    static String getSsoUrl(String portalHost, String portalPort) {
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        sb.append(portalHost);
        sb.append(':');
        sb.append(portalPort);
        sb.append("/nwa");
        sb.append("?login_submit=on");
        sb.append("&login_do_redirect=1");
        sb.append("&no_cert_storing=on");
        sb.append("&j_authscheme=default");
        sb.append("&uidPasswordLogon=Log+on");
        return sb.toString();
    }

    public static Properties createProperties(String userId, String ssoToken, String password, String host, String sysNr, String client, String language) {
        if (ssoToken == null) {
            ssoToken = "";
        }
        Properties props = new Properties();
        props.put("jco.client.ashost", host);
        props.put("jco.client.sysnr", sysNr);
        props.put("jco.client.client", client);
        props.put("jco.client.mysapsso2", ssoToken);
        props.put("jco.destination.user_id", userId);
        props.put("jco.client.lang", language);
        return props;
    }

    public static JCoDestination createJcoDestination(String ssoToken, String host, String sysNr, String client, String userId, String language) throws IOException, JCoException {
        JCoDestination destination = null;
        try {
            Properties connectProperties = VtiIdentityServiceForSapSsoToken.createProperties(userId, ssoToken, null, host, sysNr, client, language);
            if (!Environment.isDestinationDataProviderRegistered()) {
                Environment.registerDestinationDataProvider((DestinationDataProvider)Provider.getInstance());
            }
            ((Provider)jKonyProvider).changeProperties(connectProperties);
            String key = Provider.prepareDestKey(connectProperties);
            destination = JCoDestinationManager.getDestination((String)key);
        }
        catch (JCoException e) {
            logger.error((Object)"Exception while calling createJcoDestination() with the given parameters ", (Throwable)e);
            throw e;
        }
        return destination;
    }

    private VtiIdentityServiceForSapSsoToken() {
    }
}

