/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.siebel;

import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.siebel.SiebelConnectorUtils;
import com.konylabs.middleware.connectors.siebel.SiebelConnectorUtilsCallback;
import com.konylabs.middleware.connectors.siebel.SiebelField;
import com.konylabs.middleware.connectors.siebel.SiebelRecord;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Record;
import com.konylabs.middleware.registry.vo.Service;
import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class SiebelConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(SiebelConnector.class);
    public static final String OPCODE_LOGIN = "login";
    public static final String OPCODE_LOGOUT = "logout";
    public static final String OPCODE_CREATE = "create";
    public static final String OPCODE_UPDATE = "update";
    public static final String OPCODE_DELETE = "delete";
    public static final String OPCODE_QUERY = "query";
    public static final String OPCODE_SERVICE = "service";
    public static final String OPCODE_META_REPO_BO = "REPO_BO";
    public static final String OPCODE_META_REPO_BC = "REPO_BC";
    public static final String QUERY_FIELDS = "fields";
    public static final String QUERY_INARGS = "inargs";
    SiebelConnectorUtils siebelConnectorUtils = SiebelConnectorUtils.newInstance(null);

    /*
     * Exception decompiling
     */
    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SiebelRecord getSiebelRecordFromServiceInputDef(Service service, String queryParam, boolean isSelectFields) {
        ArrayList inRecords = service.getServiceInput().getRecords();
        Record fieldsRecord = null;
        for (Record inRecord : inRecords) {
            if (!queryParam.equals(inRecord.getId())) continue;
            fieldsRecord = inRecord;
        }
        if (fieldsRecord == null) {
            return null;
        }
        SiebelRecord siebelRecord = new SiebelRecord();
        if (isSelectFields) {
            this.setQueryFieldAsSelectedSiebelRecord(fieldsRecord, siebelRecord);
        } else {
            this.setQueryFieldAsMultiSiebelRecord(fieldsRecord, siebelRecord);
        }
        return siebelRecord;
    }

    private void setQueryFieldAsSelectedSiebelRecord(Record selectFieldsRecord, SiebelRecord siebelRecord) {
        ArrayList params = selectFieldsRecord.getParams();
        for (Param param : params) {
            siebelRecord.fields.add(new SiebelField(param.getName(), param.getValue()));
        }
        SiebelField mvField = null;
        ArrayList records = selectFieldsRecord.getRecords();
        for (Record record : records) {
            mvField = new SiebelField();
            mvField.isMultiValued = true;
            mvField.name = record.getId();
            mvField.record = new SiebelRecord();
            siebelRecord.fields.add(mvField);
            this.setQueryFieldAsSelectedSiebelRecord(record, mvField.record);
        }
    }

    private void setQueryFieldAsMultiSiebelRecord(Record mwRecord, SiebelRecord siebelRecord) {
        ArrayList mwParams = mwRecord.getParams();
        for (Param mwParam : mwParams) {
            siebelRecord.fields.add(new SiebelField(mwParam.getName(), mwParam.getValue()));
        }
        SiebelField siebelField = null;
        ArrayList mwRecords = mwRecord.getRecords();
        for (Record record : mwRecords) {
            siebelField = new SiebelField();
            siebelField.isMultiValued = true;
            siebelField.type = record.getId();
            siebelField.record = new SiebelRecord();
            siebelRecord.fields.add(siebelField);
            this.setQueryFieldAsMultiSiebelRecord(record, siebelField.record);
        }
    }

    private void buildSuccessResult(Result result, String message) {
        com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
        record.setId("RETURN");
        record.addParam(new com.konylabs.middleware.dataobject.Param("result", message, "string"));
        result.addRecord(record);
    }

    private void buildErrorResult(Result result, String message) {
        com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
        record.setId("RETURN");
        record.addParam(new com.konylabs.middleware.dataobject.Param("result", message, "string"));
        result.addRecord(record);
    }

    private SiebelPropertySet convertRecordToPropertySet(com.konylabs.middleware.dataobject.Record record) {
        SiebelPropertySet propertySet = new SiebelPropertySet();
        for (com.konylabs.middleware.dataobject.Param param : record.getAllParams()) {
            propertySet.setProperty(param.getName(), param.getValue());
        }
        return propertySet;
    }

    public String login(String url, String username, String password) throws ConnectorException, SiebelException {
        SiebelDataBean dataBean = this.siebelConnectorUtils.login(url, username, password, null);
        return this.siebelConnectorUtils.getSessionId(dataBean);
    }

    public void logout(String sessionId) throws SiebelException, ConnectorException {
        this.siebelConnectorUtils.logoff(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result queryRecords(String sessionId, Result result, String bo, String bc, String nameFilter, String searchSpec, String sortSpec, String viewMode, SiebelRecord queryRecord) throws ConnectorException, SiebelException {
        SiebelDataBean dataBean = this.siebelConnectorUtils.login(sessionId);
        try {
            List<SiebelRecord> records = this.siebelConnectorUtils.queryBusinessComponentRecords(dataBean, bo, bc, nameFilter, searchSpec, sortSpec, viewMode, queryRecord);
            Dataset dataset = new Dataset();
            dataset.setId("RETURN");
            for (SiebelRecord record : records) {
                dataset.addRecord(this.createDatasetFromSeibelRecord(record));
            }
            result.addDataset(dataset);
            Result result2 = result;
            return result2;
        }
        finally {
            if (dataBean != null) {
                dataBean.detach();
            }
        }
    }

    private com.konylabs.middleware.dataobject.Record createDatasetFromSeibelRecord(SiebelRecord siebelRecord) {
        Dataset dataset = null;
        com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
        for (SiebelField siebelField : siebelRecord.fields) {
            if (siebelField.isMultiValued) {
                dataset = new Dataset();
                dataset.setId(siebelField.name);
                List<SiebelRecord> mvRecords = siebelField.mValue;
                for (SiebelRecord mvRecord : mvRecords) {
                    dataset.addRecord(this.createDatasetFromSeibelRecord(mvRecord));
                }
                record.addDataset(dataset);
                continue;
            }
            record.addParam(new com.konylabs.middleware.dataobject.Param(siebelField.name, siebelField.value, siebelField.type));
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRecord(String sessionId, Result result, String bo, String bc, Dataset dataset) throws ConnectorException, SiebelException {
        SiebelDataBean dataBean = this.siebelConnectorUtils.login(sessionId);
        com.konylabs.middleware.dataobject.Record record = dataset.getRecord(0);
        SiebelPropertySet propertySet = this.convertRecordToPropertySet(record);
        com.konylabs.middleware.dataobject.Record filteredRecord = this.filterInputRecordParams(record);
        SiebelPropertySet filteredPropertySet = this.convertRecordToPropertySet(filteredRecord);
        try {
            SiebelRecord siebelRecord = this.siebelConnectorUtils.createRecord(dataBean, bo, bc, filteredPropertySet, propertySet);
            if (siebelRecord != null) {
                LOGGER.debug((Object)("New record created, in BO=" + bo + ", BC=" + bc));
                this.buildSuccessResult(result, "New record created, in BO=" + bo + ", BC=" + bc);
                com.konylabs.middleware.dataobject.Record dataRecord = this.createRecordFromSeibelRecord(siebelRecord);
                dataRecord.setId("DATA");
                result.addRecord(dataRecord);
            } else {
                LOGGER.debug((Object)("Failed to create new record, in BO=" + bo + ", BC=" + bc));
                this.buildErrorResult(result, "Failed to create new record, in BO=" + bo + ", BC=" + bc);
            }
        }
        finally {
            if (dataBean != null) {
                dataBean.detach();
            }
        }
    }

    private com.konylabs.middleware.dataobject.Record createRecordFromSeibelRecord(SiebelRecord siebelRecord) {
        com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
        for (SiebelField siebelField : siebelRecord.fields) {
            record.addParam(new com.konylabs.middleware.dataobject.Param(siebelField.name, siebelField.value, siebelField.type));
        }
        return record;
    }

    private com.konylabs.middleware.dataobject.Record filterInputRecordParams(com.konylabs.middleware.dataobject.Record record) {
        com.konylabs.middleware.dataobject.Record filteredRecord = new com.konylabs.middleware.dataobject.Record();
        for (com.konylabs.middleware.dataobject.Param param : record.getAllParams()) {
            boolean ignoreParam = false;
            for (String accessType : param.getAccessType().split(",")) {
                if (!"calculated".equalsIgnoreCase(accessType) && !"readonly".equalsIgnoreCase(accessType)) continue;
                ignoreParam = true;
            }
            if (ignoreParam) continue;
            filteredRecord.addParam(param);
        }
        return filteredRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(String sessionId, Result result, String bo, String bc, String searchExpr, Dataset dataset) throws SiebelException, ConnectorException {
        SiebelDataBean dataBean = this.siebelConnectorUtils.login(sessionId);
        SiebelPropertySet propertySet = this.convertRecordToPropertySet(dataset.getRecord(0));
        try {
            boolean isWrite = this.siebelConnectorUtils.updateRecord(dataBean, bo, bc, searchExpr, propertySet);
            if (isWrite) {
                LOGGER.debug((Object)("Record Updated, in BO=" + bo + ", BC=" + bc));
                this.buildSuccessResult(result, "Record Updated, in BO=" + bo + ", BC=" + bc);
            } else {
                LOGGER.debug((Object)("Failed to update record, in BO=" + bo + ", BC=" + bc));
                this.buildErrorResult(result, "Failed to uodate record, in BO=" + bo + ", BC=" + bc);
            }
        }
        finally {
            if (dataBean != null) {
                dataBean.detach();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(String sessionId, Result result, String bo, String bc, String searchExpr) throws SiebelException, ConnectorException {
        SiebelDataBean dataBean = this.siebelConnectorUtils.login(sessionId);
        try {
            boolean isDeleted = this.siebelConnectorUtils.deleteRecord(dataBean, bo, bc, searchExpr);
            if (isDeleted) {
                LOGGER.debug((Object)("Record deleted, in BO=" + bo + ", BC=" + bc));
                this.buildSuccessResult(result, "Record deleted, in BO=" + bo + ", BC=" + bc);
            } else {
                LOGGER.debug((Object)("Failed to delete record, in BO=" + bo + ", BC=" + bc));
                this.buildErrorResult(result, "Failed to delete record, in BO=" + bo + ", BC=" + bc);
            }
        }
        finally {
            if (dataBean != null) {
                dataBean.detach();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invokeService(String sessionId, Result result, String serviceName, String serviceMethod, SiebelRecord siebelRecord) throws SiebelException, ConnectorException {
        SiebelDataBean dataBean = this.siebelConnectorUtils.login(sessionId);
        try {
            SiebelPropertySet output = this.siebelConnectorUtils.executeService(dataBean, serviceName, serviceMethod, siebelRecord);
            Dataset dataset = new Dataset();
            dataset.setId("RETURN");
            this.iteratePropertySetGraph(output, dataset);
            result.addDataset(dataset);
            Result result2 = result;
            return result2;
        }
        finally {
            if (dataBean != null) {
                dataBean.detach();
            }
        }
    }

    private void iteratePropertySetGraph(SiebelPropertySet ps, Dataset dataset) {
        com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
        dataset.addRecord(record);
        if (ps.getType() != null && ps.getType().length() > 0) {
            record.setId(ps.getType());
        } else {
            record.setId("CHILD");
        }
        record.addParam(new com.konylabs.middleware.dataobject.Param("value", ps.getValue(), ps.getType()));
        record.addParam(new com.konylabs.middleware.dataobject.Param("type", ps.getType(), ps.getType()));
        Enumeration propertyNames = ps.getPropertyNames();
        String propName = null;
        while (propertyNames.hasMoreElements()) {
            propName = (String)propertyNames.nextElement();
            record.addParam(new com.konylabs.middleware.dataobject.Param(propName, ps.getProperty(propName), ps.getType()));
        }
        int childCount = ps.getChildCount();
        if (childCount > 0) {
            Dataset dataset2 = new Dataset();
            if (ps.getType() != null && ps.getType().length() > 0) {
                dataset2.setId(ps.getType());
            } else {
                dataset2.setId("CHILD");
            }
            record.addDataset(dataset2);
            SiebelPropertySet child = null;
            for (int i = 0; i < childCount; ++i) {
                child = ps.getChild(i);
                this.iteratePropertySetGraph(child, dataset2);
            }
        }
    }

    public void setSiebelConnectorUtilsCallback(SiebelConnectorUtilsCallback callback) {
        this.siebelConnectorUtils.setCallBack(callback);
    }

    @Override
    public void setCallingProcessor(Processor processor) {
    }
}

