/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.siebel;

import com.konylabs.middleware.connectors.siebel.SiebelConnectorUtilsCallback;
import com.konylabs.middleware.connectors.siebel.SiebelField;
import com.konylabs.middleware.connectors.siebel.SiebelRecord;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.siebel.data.SiebelBusComp;
import com.siebel.data.SiebelBusObject;
import com.siebel.data.SiebelDataBean;
import com.siebel.data.SiebelException;
import com.siebel.data.SiebelPropertySet;
import com.siebel.data.SiebelService;
import com.siebel.integration.util.SiebelHierarchyImpl;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SiebelConnectorUtils {
    public static final String SIEBEL_INPUT_PARAM_TYPE = "Input";
    public static final String SIEBEL_OUTPUT_PARAM_TYPE = "Output";
    public static final String ID = "Id";
    public static final String REPOSITORY_DETAILS = "Repository Details";
    public static final String REPOSITORY_BUSINESS_OBJECT_COMPONENT = "Repository Business Object Component";
    public static final String REPOSITORY_BUSINESS_OBJECT = "Repository Business Object";
    public static final String REPOSITORY_BUSINESS_COMPONENT = "Repository Business Component";
    public static final String REPOSITORY_FIELD = "Repository Field";
    public static final String REPOSITORY_BUSINESS_SERVICE = "Repository Business Service";
    public static final String REPOSITORY_BUSINESS_SERVICE_METHOD = "Repository Business Service Method";
    public static final String REPOSITORY_BUSINESS_SERVICE_METHOD_ARG = "Repository Business Service Method Arg";
    public static final String[] REPOSITORY_FIELD_ATTRIB = new String[]{"Name", "Type", "Text Length", "Multi Valued", "Multi Value Link", "Calculated", "Required", "Read Only", "Inactive", "Hidden"};
    public static final String[] BUSINESS_COMPONENT_VIEW_MODES = new String[]{"SalesRepView", "ManagerView", "PersonalView", "AllView", "NoneSetView", "OrganizationView", "ContactView", "GroupView", "CatalogView", "SubOrganizationView"};
    public static final String[] SERVICE_METHOD_ARG_ATTRIB = new String[]{"Name", "Parent Id", "Parent Name", "Data Type", "Storage Type", "Type", "Optional", "Inactive", "Hidden"};
    public static final int ATTRIB_DATATYPE_INDEX = 3;
    public static final int ATTRIB_PARAM_TYPE_INDEX = 5;
    public static final String FIELD_PARENT_NAME = "Parent Name";
    public static final String FIELD_BUSCOMP = "BusComp";
    public static final String FIELD_NAME = "Name";
    public static final String SIEBEL_CONNECTOR = "siebelConnector";
    private static final Logger LOGGER = Logger.getLogger(SiebelConnectorUtils.class);
    private SiebelConnectorUtilsCallback callBack;

    public static SiebelConnectorUtils newInstance(SiebelConnectorUtilsCallback callBack) {
        SiebelConnectorUtils connectorUtils = new SiebelConnectorUtils();
        if (callBack == null) {
            callBack = SiebelConnectorUtilsCallback.Stub;
        }
        connectorUtils.setCallBack(callBack);
        return connectorUtils;
    }

    public SiebelConnectorUtilsCallback getCallBack() {
        return this.callBack;
    }

    public void setCallBack(SiebelConnectorUtilsCallback callBack) {
        this.callBack = callBack;
    }

    public SiebelDataBean login(String connUrl, String username, String password, String lang) throws SiebelException, ConnectorException {
        if (StringUtils.isBlank((String)connUrl) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
            throw new ConnectorException(SIEBEL_CONNECTOR, "8804", "Invalid connection URL or username or password");
        }
        if (lang == null || lang.length() == 0) {
            lang = "enu";
        }
        LOGGER.debug((Object)("Connecting to " + connUrl + ", username: " + username));
        SiebelDataBean dataBean = new SiebelDataBean();
        dataBean.login(connUrl, username, password, lang);
        return dataBean;
    }

    public SiebelDataBean login(String sessionId) throws ConnectorException, SiebelException {
        if (StringUtils.isBlank((String)sessionId)) {
            throw new ConnectorException(SIEBEL_CONNECTOR, "8805", "Invalid session id");
        }
        LOGGER.debug((Object)("Attaching to existing Siebel sesion, with session id " + sessionId));
        SiebelDataBean dataBean = new SiebelDataBean();
        dataBean.attach(sessionId);
        return dataBean;
    }

    public String getSessionId(SiebelDataBean dataBean) throws SiebelException {
        return dataBean.detach();
    }

    public void logoff(String sessionId) throws SiebelException, ConnectorException {
        if (StringUtils.isBlank((String)sessionId)) {
            throw new ConnectorException(SIEBEL_CONNECTOR, "8805", "Invalid session id");
        }
        LOGGER.debug((Object)("Disconneting from Siebel sesion, with session id" + sessionId));
        SiebelDataBean dataBean = new SiebelDataBean();
        dataBean.attach(sessionId);
        dataBean.logoff();
    }

    public SiebelRecord createRecord(SiebelDataBean dataBean, String bo, String bc, SiebelPropertySet filteredPropertySet, SiebelPropertySet propertySet) throws SiebelException, ConnectorException {
        SiebelBusObject busObject = dataBean.getBusObject(bo);
        SiebelBusComp busComp = busObject.getBusComp(bc);
        busComp.newRecord(false);
        busComp.setMultipleFieldValues(filteredPropertySet);
        boolean isWrite = busComp.writeRecord();
        if (!isWrite) {
            return null;
        }
        SiebelRecord siebelRecord = new SiebelRecord();
        String newRecordId = busComp.getFieldValue(ID);
        busComp.clearToQuery();
        busComp.activateMultipleFields(propertySet);
        Enumeration propertyNames = null;
        busComp.setSearchSpec(ID, newRecordId);
        busComp.executeQuery(true);
        boolean isRecord = busComp.firstRecord();
        if (isRecord) {
            String propertyName = null;
            propertyNames = propertySet.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                propertyName = (String)propertyNames.nextElement();
                siebelRecord.fields.add(new SiebelField(propertyName, busComp.getFieldValue(propertyName)));
            }
        }
        busComp.release();
        busObject.release();
        return siebelRecord;
    }

    public boolean updateRecord(SiebelDataBean dataBean, String bo, String bc, String searchExpr, SiebelPropertySet propertySet) throws SiebelException {
        SiebelBusObject busObject = dataBean.getBusObject(bo);
        SiebelBusComp busComp = busObject.getBusComp(bc);
        busComp.activateMultipleFields(propertySet);
        busComp.setSearchExpr(searchExpr);
        busComp.executeQuery(false);
        boolean isRecord = busComp.firstRecord();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<String> fieldValues = new ArrayList<String>();
        Enumeration propertyNames = propertySet.getPropertyNames();
        String propertyName = null;
        while (propertyNames.hasMoreElements()) {
            propertyName = (String)propertyNames.nextElement();
            fieldNames.add(propertyName);
            fieldValues.add(propertySet.getProperty(propertyName));
        }
        String fieldName = null;
        String fieldValue = null;
        if (isRecord) {
            for (int i = 0; i < fieldNames.size(); ++i) {
                fieldName = (String)fieldNames.get(i);
                fieldValue = (String)fieldValues.get(i);
                try {
                    busComp.setFieldValue(fieldName, fieldValue);
                    continue;
                }
                catch (SiebelException e) {
                    LOGGER.debug((Object)"This might be a multi valued field - not handled yet");
                    return false;
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"Exception when updating: ", (Throwable)e);
                    return false;
                }
            }
        } else {
            return false;
        }
        boolean isWrite = busComp.writeRecord();
        busComp.release();
        busObject.release();
        return isWrite;
    }

    public boolean deleteRecord(SiebelDataBean dataBean, String bo, String bc, String searchExpr) throws SiebelException {
        SiebelBusObject busObject = dataBean.getBusObject(bo);
        SiebelBusComp busComp = busObject.getBusComp(bc);
        busComp.setSearchExpr(searchExpr);
        busComp.executeQuery(false);
        boolean isRecord = busComp.firstRecord();
        if (!isRecord) {
            return false;
        }
        while (isRecord) {
            busComp.deleteRecord();
            isRecord = busComp.nextRecord();
        }
        boolean isWrite = busComp.writeRecord();
        busComp.release();
        busObject.release();
        return isWrite;
    }

    private int getViewMode(String viewMode) {
        for (int i = 0; i < BUSINESS_COMPONENT_VIEW_MODES.length; ++i) {
            if (!BUSINESS_COMPONENT_VIEW_MODES[i].equalsIgnoreCase(viewMode)) continue;
            return i;
        }
        return -1;
    }

    public List<String[]> getBusinessComponentsByBusinessObject(SiebelDataBean dataBean, String busObject, String busComponent, String parentNameFilter, String recordNameFilter, String searchExpr, String viewMode, String ... fields) throws SiebelException {
        SiebelBusObject busObj = dataBean.getBusObject(busObject);
        SiebelBusComp busComp = busObj.getBusComp(busComponent);
        busComp.clearToQuery();
        if (viewMode != null) {
            busComp.setViewMode(this.getViewMode(viewMode));
        } else {
            busComp.setViewMode(3);
        }
        if (fields == null) {
            fields = new String[]{FIELD_NAME};
        }
        String[] fieldsFinal = fields;
        for (String field : fields) {
            busComp.activateField(field);
        }
        if (recordNameFilter != null) {
            busComp.setSearchSpec(FIELD_NAME, recordNameFilter);
        }
        if (parentNameFilter != null) {
            busComp.activateField(FIELD_PARENT_NAME);
            busComp.setSearchSpec(FIELD_PARENT_NAME, parentNameFilter);
        }
        if (searchExpr != null) {
            busComp.setSearchExpr(searchExpr);
        }
        busComp.executeQuery(true);
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] fieldVals = null;
        boolean isRecord = busComp.firstRecord();
        boolean isContinue = true;
        while (isRecord) {
            fieldVals = new String[fieldsFinal.length];
            for (int i = 0; i < fieldsFinal.length; ++i) {
                fieldVals[i] = busComp.getFieldValue(fieldsFinal[i]);
            }
            isContinue = this.callBack.newRecord(fieldVals);
            list.add(fieldVals);
            if (!isContinue) break;
            isRecord = busComp.nextRecord();
        }
        this.callBack.complete();
        busObj.release();
        busComp.release();
        return list;
    }

    private List<SiebelRecord> queryBusinessRecords(SiebelDataBean dataBean, String busObject, String busComponent, String parentNameFilter, String recordNameFilter, String searchExpr, String sortExpr, String viewMode, SiebelRecord argRecord) throws SiebelException, ConnectorException {
        SiebelBusObject busObj = dataBean.getBusObject(busObject);
        SiebelBusComp busComp = busObj.getBusComp(busComponent);
        busComp.clearToQuery();
        busComp.setViewMode(this.getViewMode(viewMode));
        if (argRecord == null) {
            argRecord = SiebelRecord.stub();
        }
        for (String field : argRecord.getAllFieldNames()) {
            busComp.activateField(field);
        }
        if (recordNameFilter != null) {
            busComp.setSearchSpec(FIELD_NAME, recordNameFilter);
        }
        if (parentNameFilter != null) {
            busComp.activateField(FIELD_PARENT_NAME);
            busComp.setSearchSpec(FIELD_PARENT_NAME, parentNameFilter);
        }
        if (searchExpr != null) {
            busComp.setSearchExpr(searchExpr);
        }
        if (sortExpr != null) {
            busComp.setSortSpec(sortExpr);
        }
        busComp.executeQuery(true);
        ArrayList<SiebelRecord> resultRecords = new ArrayList<SiebelRecord>();
        SiebelRecord siebelRecord = null;
        SiebelField siebelField = null;
        boolean isRecord = busComp.firstRecord();
        boolean isContinue = true;
        while (isRecord) {
            siebelRecord = new SiebelRecord();
            for (SiebelField selectField : argRecord.fields) {
                if (selectField.isMultiValued && selectField.record.fields.size() != 0) {
                    SiebelBusComp mvBusComp = this.getMVGBusComp(busComp, selectField);
                    siebelField = new SiebelField(selectField.name, null);
                    siebelField.isMultiValued = true;
                    siebelField.mValue = new ArrayList<SiebelRecord>();
                    siebelField.value = selectField.value;
                    siebelRecord.fields.add(siebelField);
                    this.setMultiValuedFieldValue(mvBusComp, selectField.record, siebelField.mValue);
                    continue;
                }
                siebelRecord.fields.add(new SiebelField(selectField.name, busComp.getFieldValue(selectField.name)));
            }
            resultRecords.add(siebelRecord);
            isContinue = this.callBack.newRecord(siebelRecord);
            if (!isContinue) break;
            isRecord = busComp.nextRecord();
        }
        this.callBack.complete();
        busObj.release();
        busComp.release();
        return resultRecords;
    }

    private void setMultiValuedFieldValue(SiebelBusComp busComp, SiebelRecord selectMVGRecord, List<SiebelRecord> mvgRecord) throws SiebelException, ConnectorException {
        SiebelRecord siebelRecord = null;
        SiebelField siebelField = null;
        boolean isRecord = busComp.firstRecord();
        while (isRecord) {
            siebelRecord = new SiebelRecord();
            for (SiebelField mvgField : selectMVGRecord.fields) {
                if (mvgField.isMultiValued) {
                    if (mvgField.record == null) {
                        throw new ConnectorException(SIEBEL_CONNECTOR, "8806", "Field is multi valued, but mValue is null");
                    }
                    SiebelBusComp mvBusComp = this.getMVGBusComp(busComp, mvgField);
                    siebelField = new SiebelField(mvgField.name, null);
                    siebelField.isMultiValued = true;
                    siebelField.value = mvgField.value;
                    siebelField.mValue = new ArrayList<SiebelRecord>();
                    siebelRecord.fields.add(siebelField);
                    this.setMultiValuedFieldValue(mvBusComp, mvgField.record, siebelField.mValue);
                    continue;
                }
                siebelRecord.fields.add(new SiebelField(mvgField.name, busComp.getFieldValue(mvgField.name)));
            }
            mvgRecord.add(siebelRecord);
            isRecord = busComp.nextRecord();
        }
    }

    private SiebelBusComp getMVGBusComp(SiebelBusComp busComp, SiebelField selectField) throws SiebelException {
        SiebelBusComp mvgBusComp = busComp.getMVGBusComp(selectField.name);
        mvgBusComp.activateMultipleFields(this.convertFieldNamesToPropertySet(selectField.record.getAllFieldNames()));
        if (selectField.value != null) {
            mvgBusComp.setSearchSpec(ID, selectField.value);
        }
        mvgBusComp.executeQuery(true);
        return mvgBusComp;
    }

    private SiebelPropertySet convertFieldNamesToPropertySet(String ... fieldNames) {
        SiebelPropertySet set = new SiebelPropertySet();
        for (String fieldName : fieldNames) {
            set.setProperty(fieldName, "");
        }
        return set;
    }

    private List<String[]> getBusinessComponentsMetaByBusinessObject(SiebelDataBean dataBean, String busObject, String busComponent) throws SiebelException {
        return this.getBusinessComponentsByBusinessObject(dataBean, busObject, busComponent, null, null, null, null, null);
    }

    public List<String[]> getBusinessObjectComponentsByParent(SiebelDataBean dataBean, String parentBusObj) throws SiebelException {
        return this.getBusinessComponentsByBusinessObject(dataBean, REPOSITORY_DETAILS, REPOSITORY_BUSINESS_OBJECT_COMPONENT, parentBusObj, null, null, null, null);
    }

    public List<String[]> getAllBusinessObjectsMeta(SiebelDataBean dataBean) throws SiebelException {
        return this.getBusinessComponentsMetaByBusinessObject(dataBean, REPOSITORY_BUSINESS_OBJECT, REPOSITORY_BUSINESS_OBJECT);
    }

    public List<String[]> getAllBusinessComponentsMeta(SiebelDataBean dataBean) throws SiebelException {
        return this.getBusinessComponentsMetaByBusinessObject(dataBean, REPOSITORY_BUSINESS_COMPONENT, REPOSITORY_BUSINESS_COMPONENT);
    }

    public List<String[]> getAllBusinessObjectComponentsMeta(SiebelDataBean dataBean) throws SiebelException {
        return this.getBusinessObjectComponentsByParent(dataBean, null);
    }

    public List<SiebelField> getBusinessComponentFieldsMeta(SiebelDataBean dataBean, String busObj, String busComp) throws SiebelException {
        final ArrayList<SiebelField> list = new ArrayList<SiebelField>();
        final SiebelConnectorUtilsCallback topCallBack = this.callBack;
        this.callBack = new SiebelConnectorUtilsCallback(){

            @Override
            public boolean newRecord(Object node) {
                String[] meta = (String[])node;
                SiebelField siebelField = new SiebelField(meta[0], null, null, SiebelConnectorUtils.this.parseSiebelBoolean(meta[3]), meta[4], meta[1], meta[2], SiebelConnectorUtils.this.parseSiebelBoolean(meta[5]), SiebelConnectorUtils.this.parseSiebelBoolean(meta[6]), SiebelConnectorUtils.this.parseSiebelBoolean(meta[7]), SiebelConnectorUtils.this.parseSiebelBoolean(meta[8]), SiebelConnectorUtils.this.parseSiebelBoolean(meta[9]));
                topCallBack.newRecord(siebelField);
                list.add(siebelField);
                return true;
            }

            @Override
            public void complete() {
                topCallBack.complete();
            }
        };
        this.getBusinessComponentsByBusinessObject(dataBean, REPOSITORY_BUSINESS_COMPONENT, REPOSITORY_FIELD, busComp, null, null, null, REPOSITORY_FIELD_ATTRIB);
        return list;
    }

    private boolean parseSiebelBoolean(String bool) {
        return "Y".equalsIgnoreCase(bool);
    }

    public List<String[]> getBusinessServicesMeta(SiebelDataBean dataBean) throws SiebelException {
        return this.getBusinessComponentsMetaByBusinessObject(dataBean, REPOSITORY_BUSINESS_SERVICE, REPOSITORY_BUSINESS_SERVICE);
    }

    public List<String[]> getBusinessServiceMethodsMeta(SiebelDataBean dataBean, String serviceName) throws SiebelException {
        return this.getBusinessComponentsByBusinessObject(dataBean, REPOSITORY_BUSINESS_SERVICE, REPOSITORY_BUSINESS_SERVICE_METHOD, serviceName, null, null, null, null);
    }

    public List<String[]> getBusinessServiceMethodArgsMeta(SiebelDataBean dataBean, String serviceName, String methodName) throws SiebelException, ConnectorException {
        SiebelConnectorUtilsCallback backup = this.callBack;
        this.callBack = SiebelConnectorUtilsCallback.Stub;
        List<String[]> methods = this.getBusinessComponentsByBusinessObject(dataBean, REPOSITORY_BUSINESS_SERVICE, REPOSITORY_BUSINESS_SERVICE_METHOD, serviceName, methodName, null, null, ID);
        this.callBack = backup;
        String methodId = null;
        if (methods == null || methods.size() == 0) {
            throw new ConnectorException(SIEBEL_CONNECTOR, "8807", "Service method not found in specified service: " + methodName + " in " + serviceName + " (found:" + methods.size() + ")");
        }
        methodId = methods.get(0)[0];
        return this.getBusinessComponentsByBusinessObject(dataBean, REPOSITORY_BUSINESS_SERVICE, REPOSITORY_BUSINESS_SERVICE_METHOD_ARG, methodName, null, "[Parent Id]='" + methodId + "'", null, FIELD_NAME, "Parent Id", FIELD_PARENT_NAME, "Data Type", "Storage Type", "Type", "Optional", "Inactive", "Hidden");
    }

    @Deprecated
    public List<String[]> getBusinessComponentRecords(SiebelDataBean dataBean, String busObj, String busComp, String nameFilter, String searchSpec, String viewMode, String ... fields) throws SiebelException {
        return this.getBusinessComponentsByBusinessObject(dataBean, busObj, busComp, null, nameFilter, searchSpec, viewMode, fields);
    }

    public List<SiebelRecord> queryBusinessComponentRecords(SiebelDataBean dataBean, String busObj, String busComp, String nameFilter, String searchSpec, String sortSpec, String viewMode, SiebelRecord selectFields) throws SiebelException, ConnectorException {
        return this.queryBusinessRecords(dataBean, busObj, busComp, null, nameFilter, searchSpec, sortSpec, viewMode, selectFields);
    }

    public SiebelPropertySet executeService(SiebelDataBean dataBean, String serviceName, String serviceMethod, SiebelRecord siebelRecord) throws SiebelException {
        SiebelService service = dataBean.getService(serviceName);
        SiebelPropertySet input = new SiebelPropertySet();
        SiebelConnectorUtils.createSiebelPropertySetFromSiebelRecord(siebelRecord, input);
        SiebelPropertySet output = new SiebelPropertySet();
        service.invokeMethod(serviceMethod, input, output);
        service.release();
        return output;
    }

    public static void createSiebelPropertySetFromSiebelRecord(SiebelRecord siebelRecord, SiebelPropertySet propertySet) {
        SiebelHierarchyImpl siebelHierarchy = null;
        SiebelPropertySet childPropertySet = null;
        for (SiebelField field : siebelRecord.fields) {
            if (field.isMultiValued && field.record != null) {
                childPropertySet = new SiebelPropertySet();
                if (field.type != null) {
                    childPropertySet.setType(field.type);
                }
                SiebelConnectorUtils.createSiebelPropertySetFromSiebelRecord(field.record, childPropertySet);
                siebelHierarchy = new SiebelHierarchyImpl(childPropertySet);
                propertySet.addChild(siebelHierarchy.toPropertySet());
                continue;
            }
            propertySet.setProperty(field.name, field.value);
        }
    }

    public static void printSiebelPropertySet(SiebelPropertySet ps, String padding) {
        Enumeration propertyNames = ps.getPropertyNames();
        String propName = null;
        while (propertyNames.hasMoreElements()) {
            propName = (String)propertyNames.nextElement();
            System.out.println(padding + propName + " = " + ps.getProperty(propName) + " : " + ps.getType());
        }
        int childCount = ps.getChildCount();
        if (childCount > 0) {
            System.out.println(padding + "+ CHILDREN (" + ps.getChildCount() + ") : " + ps.getType());
            SiebelPropertySet child = null;
            for (int i = 0; i < childCount; ++i) {
                child = ps.getChild(i);
                padding = padding + "    ";
                SiebelConnectorUtils.printSiebelPropertySet(child, padding);
            }
        }
    }
}

