/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.soappackets;

import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.connectors.io.ServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SoapServiceInputHandler
extends ServiceInputHandler {
    private static final Logger LOGGER = Logger.getLogger(SoapServiceInputHandler.class);

    protected String fillMessageForString(String tvalue, String key, String value, Map configMap, boolean encode, boolean escape) {
        LOGGER.debug((Object)("Template Param Encoding:" + encode + " for Param(" + key + ")"));
        if (encode) {
            LOGGER.debug((Object)("XML Encoding the value of Template Param(" + key + ")"));
            return ConnectorUtils.forXML(value);
        }
        LOGGER.debug((Object)("Not encoding the value of Template Param(" + key + ")"));
        return value;
    }

    @Override
    public Map<String, String> getHeaders(DataControllerRequest request, Map configMap, Service service) throws ConnectorException {
        Map<String, String> headers = super.getHeaders(request, configMap, service);
        if (!MiddlewareUtils.isHeadersPassThrough(service) && !headers.containsKey("Accept")) {
            headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        }
        String soapAction = (String)configMap.get("soapAction");
        soapAction = this.getSoapAction(soapAction);
        String soapVersion = (String)configMap.get("soap-version");
        LOGGER.debug((Object)("SOAP Version ********************* " + soapVersion));
        if (soapVersion != null && soapVersion.equals("1.2")) {
            String resEncoding = (String)configMap.get("responseEncoding");
            String respContentType = "application/soap+xml;charset=" + resEncoding + ";action=" + soapAction;
            headers.put("Content-Type", respContentType);
        } else {
            headers.put("SOAPAction", soapAction);
        }
        return headers;
    }

    private String getSoapAction(String soapAction) {
        if (StringUtils.isEmpty((String)soapAction)) {
            return "\"\"";
        }
        if (soapAction != null && !soapAction.startsWith("\"")) {
            soapAction = "\"" + soapAction + "\"";
        }
        return soapAction;
    }

    @Override
    public Function<String, String> getEncodeFunction() {
        return ConnectorUtils::forXML;
    }
}

