/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.soappackets;

import com.konylabs.middleware.connectors.XPathEngine;
import com.konylabs.middleware.connectors.io.ServiceOutputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.ConfigUtility;
import org.apache.log4j.Logger;

public class SoapServiceOutputHandler
extends ServiceOutputHandler {
    private static final Logger LOGGER = Logger.getLogger(SoapServiceOutputHandler.class);
    private static final String SOAP_FAULT_CODE_XPATH = "(/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='faultcode']/text()) | (/*[local-name()='Fault']/*[local-name()='faultcode']/text())";
    private static final String SOAP_FAULT_STRING_XPATH = "(/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='faultstring']/text()) | (/*[local-name()='Fault']/*[local-name()='faultstring']/text())";
    private static final String SOAP_FAULT_ERROR_CODE_XPATH = "(/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='detail']//*[local-name()='errorCode']/text()) |\t(/*[local-name()='Fault']/*[local-name()='detail']//*[local-name()='errorCode']/text()) |\t(/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='detail']//*[local-name()='errorcode']/text()) | \t(/*[local-name()='Fault']/*[local-name()='detail']//*[local-name()='errorcode']/text())";
    private static final String SOAP_FAULT_CODE_XPATH_1_2 = "(/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='Code']/*[local-name()='Value']/text()) | (/*[local-name()='Fault']/*[local-name()='Code']/*[local-name()='Value']/text())";
    private static final String SOAP_FAULT_STRING_XPATH_1_2 = "(/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='Reason']/*[local-name()='Text'][1]/text()) | (/*[local-name()='Fault']/*[local-name()='Reason']/*[local-name()='Text'][1]/text())";
    private static final String SOAP_FAULT_ERROR_CODE_DETAIL = "(/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='detail']) | (/*[local-name()='Fault']/*[local-name()='detail']) | (/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='Fault']/*[local-name()='Detail']) | (/*[local-name()='Fault']/*[local-name()='Detail'])";
    private static final String STRING_CONST = "string";
    private static final String INT_CONST = "int";
    private static final String OPSTATUS = "opstatus";
    private static final String HTTP_STATUS_CODE = "httpStatusCode";

    public SoapServiceOutputHandler() {
        this.defaultValidStatusCodes = "2.*|500";
    }

    @Override
    protected void buildResult(Service service, XPathEngine entity, Result result, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        super.buildResult(service, entity, result, request, response);
        if (this.checkSoapFault(service, entity, result, response)) {
            request.setAttribute(OPSTATUS, (Object)"8005");
        }
    }

    private boolean checkSoapFault(Service service, XPathEngine entity, Result result, DataControllerResponse response) {
        boolean exists = false;
        String retValue = null;
        String falutCode = SOAP_FAULT_CODE_XPATH;
        String faultString = SOAP_FAULT_STRING_XPATH;
        for (ConfigParam param : service.getServiceConfig().getServiceConfig()) {
            if (!"soap-version".equals(param.getName())) continue;
            if (!"1.2".equals(param.getValue())) break;
            falutCode = SOAP_FAULT_CODE_XPATH_1_2;
            faultString = SOAP_FAULT_STRING_XPATH_1_2;
            break;
        }
        if ((retValue = entity.evalXPath(falutCode)) != null) {
            exists = true;
            if (ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Fault code: " + retValue));
                }
                result.addParam(new Param("faultcode", retValue, STRING_CONST));
            }
            result.addParam(new Param(OPSTATUS, "8005", INT_CONST));
            result.addParam(new Param(HTTP_STATUS_CODE, String.valueOf(response.getStatusCode()), INT_CONST));
        }
        String string = retValue = exists ? entity.evalXPath(faultString) : null;
        if (retValue != null) {
            exists = true;
            if (ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Error message: " + retValue));
                }
                result.addParam(new Param("errmsg", retValue, STRING_CONST));
            }
        }
        String string2 = retValue = exists ? entity.evalXPath(SOAP_FAULT_ERROR_CODE_XPATH) : null;
        if (retValue != null && ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Error code: " + retValue));
            }
            result.addParam(new Param("errcode", retValue, STRING_CONST));
        }
        String string3 = retValue = exists ? entity.evalErrorDetailXPath(SOAP_FAULT_ERROR_CODE_DETAIL) : null;
        if (retValue != null && ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("fault details: " + retValue));
            }
            result.addParam(new Param("faultdetail", retValue, STRING_CONST));
        }
        return exists;
    }
}

