/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.utility;

import com.konylabs.middleware.common.CSRIssueLogger;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.utilities.ConfigUtility;

public class OrchestrationServiceHandler {
    protected OrchestrationServiceHandler() {
    }

    public static Result prepareResultOnExceptionForOrchestrationService(DataControllerRequest request, ConnectorException ex) {
        Result result = null;
        String csrID = CSRIssueLogger.generateCSRID();
        if (request.getAttribute("ResultOnException") != null) {
            result = (Result)request.getAttribute("ResultOnException");
            request.setAttribute("ResultOnException", null);
        } else {
            result = new Result();
        }
        result.addParam(new Param("opstatus", ex.getErrorCode(), "int"));
        if (ConfigUtility.getBoolean((String)"log.description.error", (boolean)true)) {
            result.addParam(new Param("errmsg", ex.getMessage(), "string"));
        }
        result.addParam(new Param("errid", csrID, "string"));
        return result;
    }

    protected static void addFailedopstatusForOrchestrationService(Result finalResult, String errorMessage) {
        Param failedOpstatus = new Param("opstatus", "1582", "int");
        Param failedErrmsg = new Param("errmsg", errorMessage, "string");
        finalResult.addParam(failedOpstatus);
        finalResult.addParam(failedErrmsg);
    }
}

