/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.xml;

import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.connectors.io.ServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.Map;
import java.util.function.Function;
import org.apache.log4j.Logger;

public class XMLServiceInputHandler
extends ServiceInputHandler {
    private static final Logger LOGGER = Logger.getLogger(XMLServiceInputHandler.class);

    protected String fillMessageForString(String tvalue, String key, String value, Map configMap, boolean encode, boolean escape) {
        String contentType;
        LOGGER.debug((Object)("XML Encoding the value of Template Param(" + key + ")"));
        boolean encodingrequired = true;
        if (tvalue != null) {
            int eqIdx = tvalue.indexOf("=");
            int lsIdx = tvalue.indexOf("<");
            if (eqIdx != -1 && (eqIdx < lsIdx || lsIdx == -1)) {
                encodingrequired = false;
            }
        }
        if (encodingrequired && (contentType = MiddlewareUtils.getContentType(configMap, "text/xml")).contains("application/x-www-form-urlencoded")) {
            super.fillMessageForString(tvalue, key, value, configMap, encode, escape);
        }
        return ConnectorUtils.forXML(value);
    }

    @Override
    public Map<String, String> getHeaders(DataControllerRequest request, Map configMap, Service service) throws ConnectorException {
        Map<String, String> headers = super.getHeaders(request, configMap, service);
        if (!MiddlewareUtils.isHeadersPassThrough(service) && !headers.containsKey("Accept")) {
            headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        }
        return headers;
    }

    @Override
    public Function<String, String> getEncodeFunction() {
        return ConnectorUtils::forXML;
    }
}

