/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.controller.impl;

import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.middleware.api.OperationData;
import com.konylabs.middleware.api.OperationDataBuilderImpl;
import com.konylabs.middleware.api.ServicesManager;
import com.konylabs.middleware.api.processor.HeadersHandler;
import com.konylabs.middleware.api.processor.manager.FabricRequestManager;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.RequestUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.log4j.Logger;

public abstract class AbstractDataControllerRequestImpl
implements DataControllerRequest {
    private static final Logger LOGGER = Logger.getLogger(AbstractDataControllerRequestImpl.class);
    protected Map<String, Cookie> cookies = new HashMap<String, Cookie>(0);

    public DataControllerRequest clone() {
        try {
            return (DataControllerRequest)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LOGGER.error((Object)"Error occurred while creating clone of DataControllerRequest", (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public ServicesManager getServicesManager() throws AppRegistryException {
        String appID = this.getParameter("current_appID");
        String serviceID = this.getParameter("current_serviceID");
        String apiVersion = this.getParameter("curent_apiVersion");
        TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromDCRequest(this);
        MetricsBean metricsBean = (MetricsBean)this.getAttribute("metricsBean");
        OperationData operationData = new OperationDataBuilderImpl((AppCache)tenantBean.getAppCache()).withServiceId(appID).withOperationId(serviceID).withVersion(apiVersion).buildQuietly();
        CacheDirector cacheDirector = (CacheDirector)this.getAttribute("cacheDirector");
        return MiddlewareUtils.createServicesManager(tenantBean, operationData, metricsBean, cacheDirector);
    }

    public String getQueryString() {
        if (this.getOriginalRequest() != null) {
            return ((HttpServletRequest)this.getOriginalRequest()).getQueryString();
        }
        return null;
    }

    protected void extractCookiesAndConvertToApacheCookies(javax.servlet.http.Cookie[] servletCookies) {
        if (servletCookies != null && servletCookies.length > 0) {
            for (javax.servlet.http.Cookie cookie : servletCookies) {
                BasicClientCookie apacheCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
                apacheCookie.setComment(cookie.getComment());
                apacheCookie.setDomain(cookie.getDomain());
                if (cookie.getMaxAge() > 0) {
                    apacheCookie.setExpiryDate(AbstractDataControllerRequestImpl.getExpiryDateForMaxAge(cookie.getMaxAge()));
                }
                apacheCookie.setPath(cookie.getPath());
                apacheCookie.setSecure(cookie.getSecure());
                apacheCookie.setVersion(cookie.getVersion());
                this.cookies.put(apacheCookie.getName(), (Cookie)apacheCookie);
            }
        }
    }

    protected void addCookies(Map<String, Cookie> cookiesMap) {
        if (cookiesMap != null && !cookiesMap.isEmpty()) {
            this.cookies.putAll(cookiesMap);
        }
    }

    protected Map<String, String> consumeHeadersFromCustomProcessor(HttpServletRequest request) {
        LOGGER.debug((Object)"Consuming custom headers added in the pre processor.");
        FabricRequestManager requestManager = (FabricRequestManager)RequestUtils.getAttribute((HttpServletRequest)request, (String)"REQUEST_MANAGER");
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        if (requestManager != null) {
            HeadersHandler requestHeadersHandler = requestManager.getHeadersHandler();
            requestHeadersHandler.getHeaderNames().stream().forEach(name -> customHeaders.put((String)name, requestHeadersHandler.getHeader(name)));
        }
        return customHeaders;
    }

    private static Date getExpiryDateForMaxAge(int maxAge) {
        return new Date(System.currentTimeMillis() + (long)maxAge * 1000L);
    }
}

