/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.controller.impl;

import com.kony.mobilefabric.util.ReflectionUtils;
import com.konylabs.middleware.cache.MemcacheProperties;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.KHttpServletRequestWrapper;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.config.DBConfigSubject;
import com.konylabs.middleware.config.DataControllerConfigDocument;
import com.konylabs.middleware.config.Observer;
import com.konylabs.middleware.controller.AsyncHandler;
import com.konylabs.middleware.controller.DataController;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerRequestFactory;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.controller.impl.DataControllerImplAsyncHandler;
import com.konylabs.middleware.controller.impl.DataControllerResponseImpl;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.exceptions.ControllerException;
import com.konylabs.middleware.exceptions.ControllerInitializationException;
import com.konylabs.middleware.exceptions.ExceptionUtil;
import com.konylabs.middleware.exceptions.MetricsException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.ProcessorInitializationException;
import com.konylabs.middleware.exceptions.SequenceException;
import com.konylabs.middleware.exceptions.SequenceInitializationException;
import com.konylabs.middleware.metrics.KonyCustomMetrics;
import com.konylabs.middleware.processor.Attribute;
import com.konylabs.middleware.processor.Configuration;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.processor.impl.ConfigurationImpl;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.parser.IRequestData;
import com.konylabs.middleware.sequence.AsyncSequence;
import com.konylabs.middleware.sequence.Sequence;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MetricsBeanUtils;
import com.konylabs.middleware.utilities.RequestUtils;
import com.konylabs.middleware.utilities.ResponseUtils;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.cookie.Cookie;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class DataControllerImpl
implements DataController {
    private static final Logger LOGGER = Logger.getLogger(DataControllerImpl.class);
    private static final DataControllerImplAsyncHandler CONTROLLER_IMPL_ASYNC_HANDLER = new DataControllerImplAsyncHandler();
    private boolean initialized = false;
    private String configFileName;
    private final HashMap<String, DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration> processorConfig = new HashMap();
    private final HashMap<String, DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration> sequenceConfig = new HashMap();
    private final HashMap<String, String> appConfig = new HashMap();
    private final HashMap<String, String> channelConfig = new HashMap();
    private final HashMap<String, Sequence> sequences = new HashMap();
    private final HashMap<String, Processor> processors = new HashMap();
    private final ClassLoader classLoader;

    public DataControllerImpl() {
        this(DataControllerImpl.class.getClassLoader());
    }

    public DataControllerImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void init() throws ControllerInitializationException {
        this.init(this.getClass().getClassLoader().getResourceAsStream("ControllerDef.xml"));
    }

    @Override
    public void init(String configFileName) throws ControllerInitializationException {
        try {
            this.configFileName = configFileName;
            this.init(new FileInputStream(configFileName));
        }
        catch (Exception e) {
            MaskUtils.maskTrace((String)e.getMessage(), (Throwable)e);
            throw new ControllerInitializationException("5000", "Controller Configuration Initialization or loading Error");
        }
    }

    public void init(InputStream controllerFileStream) throws ControllerInitializationException {
        if (!this.initialized) {
            this.load(controllerFileStream);
            this.initialized = true;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private synchronized void load(InputStream controllerFileStream) throws ControllerInitializationException {
        LOGGER.info((Object)"configuration loading started");
        try {
            DataControllerConfigDocument.DataControllerConfig.ChannelConfiguration cc;
            HashMap<String, String> nsSubst = new HashMap<String, String>();
            nsSubst.put("", "config.middleware.konylabs.com");
            XmlOptions parseOptions = new XmlOptions();
            parseOptions.setLoadSubstituteNamespaces(nsSubst);
            DataControllerConfigDocument dccd = DataControllerConfigDocument.Factory.parse((InputStream)controllerFileStream, (XmlOptions)parseOptions);
            DataControllerConfigDocument.DataControllerConfig dcd = dccd.getDataControllerConfig();
            DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration[] pc = dcd.getProcessorConfigurationArray();
            for (int i = 0; i < pc.length; ++i) {
                String name = pc[i].getName();
                LOGGER.debug((Object)("Adding Processor : " + name));
                this.processorConfig.put(name.trim(), pc[i]);
            }
            LOGGER.debug((Object)"Processor configurations loaded");
            DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration[] sc = dcd.getSequenceConfigurationArray();
            for (int i = 0; i < sc.length; ++i) {
                String name = sc[i].getName();
                LOGGER.debug((Object)("Adding Sequence : " + name));
                this.sequenceConfig.put(name.trim(), sc[i]);
            }
            LOGGER.debug((Object)"Sequence configurations loaded");
            DataControllerConfigDocument.DataControllerConfig.AppConfiguration ac = dcd.getAppConfiguration();
            if (ac != null) {
                DataControllerConfigDocument.DataControllerConfig.AppConfiguration.Application[] ap = ac.getApplicationArray();
                if (ap != null) {
                    for (int i = 0; i < ap.length; ++i) {
                        String id = ap[i].getAppid();
                        String channel = ap[i].getChannelName();
                        if (id == null || channel == null || ap[i].getSequence() == null) continue;
                        this.appConfig.put(id.trim() + ":" + channel.trim(), ap[i].getSequence().trim());
                    }
                }
                LOGGER.debug((Object)"Application configurations loaded");
            }
            if ((cc = dcd.getChannelConfiguration()) != null) {
                DataControllerConfigDocument.DataControllerConfig.ChannelConfiguration.Channel[] ch = cc.getChannelArray();
                if (ch != null) {
                    for (int i = 0; i < ch.length; ++i) {
                        String channelName = ch[i].getName();
                        LOGGER.debug((Object)("Adding Channel : " + channelName));
                        if (channelName != null && ch[i].getSequenceName() != null) {
                            this.channelConfig.put(channelName.trim(), ch[i].getSequenceName().trim());
                            continue;
                        }
                        LOGGER.debug((Object)("Either Channel is not defined or sequenceName attribute is missing for : " + channelName));
                    }
                }
                LOGGER.debug((Object)"Application configurations loaded");
            }
        }
        catch (IOException iex) {
            MaskUtils.maskTrace((String)iex.getMessage(), (Throwable)iex);
            throw new ControllerInitializationException("5000", "Controller Configuration Initialization or loading Error");
        }
        catch (XmlException xex) {
            MaskUtils.maskTrace((String)xex.getMessage(), (Throwable)xex);
            throw new ControllerInitializationException("5000", "Controller Configuration Initialization or loading Error");
        }
        LOGGER.debug((Object)"configurations loading ended");
    }

    @Override
    public synchronized void reloadConfig() throws ControllerInitializationException {
        try {
            this.processorConfig.clear();
            this.sequenceConfig.clear();
            this.appConfig.clear();
            this.channelConfig.clear();
            this.sequences.clear();
            this.processors.clear();
            if (StringUtils.isNotBlank((String)this.configFileName)) {
                this.load(new FileInputStream(this.configFileName));
            } else {
                this.load(this.getClass().getResourceAsStream("ControllerDef.xml"));
            }
            LOGGER.debug((Object)" Configuration is reloaded ");
        }
        catch (Exception e) {
            MaskUtils.maskTrace((String)e.getMessage(), (Throwable)e);
            throw new ControllerInitializationException("5000", "Controller Configuration Initialization or loading Error");
        }
    }

    public String getSequence(String appid, String channelName) {
        String key = appid + ":" + channelName;
        String seqName = this.appConfig.get(key);
        if (seqName == null && (seqName = this.channelConfig.get(channelName)) == null) {
            seqName = "default";
            LOGGER.debug((Object)("Sequence is not configured for app - " + appid + ", channel -" + channelName + " default sequence is choosen"));
        }
        return seqName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String processHttpRequest(HttpServletRequest request, HttpServletResponse response, HashMap<String, String> additionalRequestParams) throws ControllerInitializationException {
        String responseStr;
        block75: {
            DataControllerResponseImpl dresponse;
            DataControllerRequest drequest;
            String serviceId;
            IRequestData requestData;
            Object cacheObj;
            block72: {
                DataController dc = DataController.InstanceManager.getInstance();
                cacheObj = request.getAttribute("cacheid");
                if (StringUtils.isNotBlank((String)((String)MemcacheProperties.CLUSTER.getFromConfig()))) {
                    MaskUtils.logDebugWithMasking((String)"Cache id provided by memcache", (String)"cacheid", (String)String.valueOf(cacheObj));
                }
                if (!dc.isInitialized()) {
                    try {
                        String controllerDef = ConfigUtility.getProperty((String)"controller.deffile", (String)"ControllerDef.xml");
                        String fileName = ConfigPathUtil.getMiddlewareHome() + "/middleware/middleware-bootconfig/" + controllerDef;
                        dc.init(fileName);
                    }
                    catch (ControllerInitializationException cie) {
                        LOGGER.debug((Object)("IN MWServlet - Controller Initialization Exception. Error code: " + cie.getErrorCode()));
                        throw new ControllerInitializationException("", "DataController Can not be Initialized");
                    }
                }
                requestData = (IRequestData)request.getAttribute("requestdata");
                serviceId = requestData.getServiceId();
                drequest = DataControllerRequestFactory.newInstance(request, additionalRequestParams);
                drequest.setAttribute("cacheid", cacheObj);
                drequest.setAttribute("tenantBean", request.getAttribute("tenantBean"));
                drequest.setAttribute("cacheDirector", RequestUtils.getAttribute((HttpServletRequest)request, (String)"cacheDirector"));
                drequest.setAttribute("appregistry_Cache", (Object)requestData.getAppCache());
                drequest.setAttribute("gatewaywrapperobject", (Object)requestData.getMbaasGateWayWrapper());
                drequest.setAttribute("metricsBean", request.getAttribute("metricsBean"));
                if (requestData.getRequestPassThrough()) {
                    drequest.setAttribute("passThruHttpEntity", (Object)DataControllerImpl.getStream(request));
                }
                dresponse = new DataControllerResponseImpl();
                responseStr = null;
                dresponse = dc.processDataRequest(drequest);
                if (requestData.getResponsePassThrough()) {
                    response.setStatus(dresponse.getStatusCode());
                    break block72;
                }
                responseStr = (String)dresponse.getAttribute("chunkedresults_json");
            }
            KonyCustomMetrics customMetrics = (KonyCustomMetrics)drequest.getAttribute("customMetrics");
            try {
                if (customMetrics != null) {
                    drequest.getServicesManager().getKonyCustomMetrics().addCustomMetrics(customMetrics.getCustomMetrics());
                }
            }
            catch (MetricsException | AppRegistryException e1) {
                LOGGER.error((Object)"Error while adding custom metrics to metrics bean", e1);
            }
            if (requestData.getResponsePassThrough()) {
                try {
                    ResponseUtils.addResponseHeadersToServletResponse((HttpServletResponse)response, (DataControllerResponse)dresponse);
                    ResponseUtils.copyBackendResponseToServletResponse((HttpServletResponse)response, (DataControllerResponse)dresponse);
                }
                catch (IllegalStateException e) {
                    LOGGER.error((Object)"Error while setting pass through response", (Throwable)e);
                }
            } else {
                if (StringUtils.isNotBlank((String)responseStr)) {
                    MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"mw_response_context_data", (Object)responseStr);
                }
                if (response != null) {
                    List cookiesList = dresponse.getDeviceCookies();
                    if (cookiesList != null) {
                        for (Cookie apacheCookie : cookiesList) {
                            String cookieName = apacheCookie.getName();
                            if (cookieName == null || "cacheid".equals(cookieName) || "JSESSIONID".equals(cookieName)) continue;
                            javax.servlet.http.Cookie httpcookie = DataControllerImpl.servletCookieFromApacheCookie(apacheCookie);
                            response.addCookie(httpcookie);
                        }
                    }
                    ResponseUtils.addResponseHeaders((HttpServletRequest)request, (HttpServletResponse)response, (Map)dresponse.getDeviceHeaders());
                    HashMap statusHeaderMap = new HashMap();
                    statusHeaderMap.put("X-Kony-Service-Opstatus", dresponse.getHeaders().get("X-Kony-Service-Opstatus"));
                    statusHeaderMap.put("X-Kony-Service-Message", dresponse.getHeaders().get("X-Kony-Service-Message"));
                    String requestId = RequestUtils.getRequestId((HttpServletRequest)request);
                    requestId = requestId == null ? "" : requestId.replace('\r', ' ').replace('\n', ' ');
                    statusHeaderMap.put("X-Kony-RequestId", requestId);
                    String mfCode = (String)dresponse.getHeaders().get("X-Kony-MFCode");
                    if (StringUtils.isNotBlank((String)mfCode)) {
                        statusHeaderMap.put("X-Kony-MFCode", mfCode);
                    }
                    ResponseUtils.addResponseHeaders((HttpServletRequest)request, (HttpServletResponse)response, statusHeaderMap);
                }
            }
            break block75;
            catch (ControllerException ce) {
                block73: {
                    if (!requestData.getResponsePassThrough()) {
                        Result result = null;
                        if (drequest.getAttribute("ResultOnException") != null) {
                            result = (Result)drequest.getAttribute("ResultOnException");
                            drequest.setAttribute("ResultOnException", null);
                        } else {
                            result = new Result();
                        }
                        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"errstack", (Object)ExceptionUtils.getFullStackTrace((Throwable)ce));
                        String mfCode2 = ExceptionUtil.addErrorAttributes((Result)result, (MiddlewareException)((Object)ce));
                        if (mfCode2 != null) {
                            result.addParam(new Param("requestid", RequestUtils.getRequestId((HttpServletRequest)request), "string"));
                            dresponse.getHeaders().put("X-Kony-MFCode", mfCode2);
                        }
                        drequest.setAttribute("results", (Object)result);
                        try {
                            responseStr = ResultToJSON.convert((Result)result, (DataControllerResponse)dresponse);
                        }
                        catch (Exception je) {
                            LOGGER.error((Object)("Json String Syntax Error while Constructing JSON String from Result Object for service:" + serviceId), (Throwable)je);
                        }
                        break block73;
                    }
                    DataControllerImpl.updatePassThroughErrorResponse(response, (DataControllerResponse)dresponse, (MiddlewareException)((Object)ce));
                }
                customMetrics = (KonyCustomMetrics)drequest.getAttribute("customMetrics");
                try {
                    if (customMetrics != null) {
                        drequest.getServicesManager().getKonyCustomMetrics().addCustomMetrics(customMetrics.getCustomMetrics());
                    }
                }
                catch (MetricsException | AppRegistryException e1) {
                    LOGGER.error((Object)"Error while adding custom metrics to metrics bean", e1);
                }
                if (requestData.getResponsePassThrough()) {
                    try {
                        ResponseUtils.addResponseHeadersToServletResponse((HttpServletResponse)response, (DataControllerResponse)dresponse);
                        ResponseUtils.copyBackendResponseToServletResponse((HttpServletResponse)response, (DataControllerResponse)dresponse);
                    }
                    catch (IllegalStateException e) {
                        LOGGER.error((Object)"Error while setting pass through response", (Throwable)e);
                    }
                } else {
                    if (StringUtils.isNotBlank((String)responseStr)) {
                        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"mw_response_context_data", (Object)responseStr);
                    }
                    if (response != null) {
                        List cookiesList = dresponse.getDeviceCookies();
                        if (cookiesList != null) {
                            for (Cookie apacheCookie : cookiesList) {
                                String cookieName = apacheCookie.getName();
                                if (cookieName == null || "cacheid".equals(cookieName) || "JSESSIONID".equals(cookieName)) continue;
                                javax.servlet.http.Cookie httpcookie = DataControllerImpl.servletCookieFromApacheCookie(apacheCookie);
                                response.addCookie(httpcookie);
                            }
                        }
                        ResponseUtils.addResponseHeaders((HttpServletRequest)request, (HttpServletResponse)response, (Map)dresponse.getDeviceHeaders());
                        HashMap statusHeaderMap = new HashMap();
                        statusHeaderMap.put("X-Kony-Service-Opstatus", dresponse.getHeaders().get("X-Kony-Service-Opstatus"));
                        statusHeaderMap.put("X-Kony-Service-Message", dresponse.getHeaders().get("X-Kony-Service-Message"));
                        String requestId = RequestUtils.getRequestId((HttpServletRequest)request);
                        requestId = requestId == null ? "" : requestId.replace('\r', ' ').replace('\n', ' ');
                        statusHeaderMap.put("X-Kony-RequestId", requestId);
                        String mfCode = (String)dresponse.getHeaders().get("X-Kony-MFCode");
                        if (StringUtils.isNotBlank((String)mfCode)) {
                            statusHeaderMap.put("X-Kony-MFCode", mfCode);
                        }
                        ResponseUtils.addResponseHeaders((HttpServletRequest)request, (HttpServletResponse)response, statusHeaderMap);
                    }
                }
            }
            catch (ControllerInitializationException ce2) {
                block74: {
                    if (!requestData.getResponsePassThrough()) {
                        Result result = null;
                        if (drequest.getAttribute("ResultOnException") != null) {
                            result = (Result)drequest.getAttribute("ResultOnException");
                            drequest.setAttribute("ResultOnException", null);
                        } else {
                            result = new Result();
                        }
                        ExceptionUtil.addErrorAttributes((Result)result, (MiddlewareException)((Object)ce2));
                        request.setAttribute("errstack", (Object)ExceptionUtils.getFullStackTrace((Throwable)ce2));
                        boolean isCookieSupported = request.getAttribute("isCookieSupported") != null && Boolean.valueOf((Boolean)request.getAttribute("isCookieSupported")) != false;
                        cacheObj = request.getAttribute("cacheid");
                        if (!isCookieSupported && cacheObj != null) {
                            result.addParam(new Param("cacheid", (String)cacheObj, "string"));
                        }
                        drequest.setAttribute("results", (Object)result);
                        try {
                            responseStr = ResultToJSON.convert((Result)result, (DataControllerResponse)dresponse);
                        }
                        catch (Exception je) {
                            LOGGER.error((Object)"Json String Syntax Error while Constructing JSON String from Result Object : ", (Throwable)je);
                        }
                        break block74;
                    }
                    DataControllerImpl.updatePassThroughErrorResponse(response, (DataControllerResponse)dresponse, (MiddlewareException)((Object)ce2));
                }
                customMetrics = (KonyCustomMetrics)drequest.getAttribute("customMetrics");
                try {
                    if (customMetrics != null) {
                        drequest.getServicesManager().getKonyCustomMetrics().addCustomMetrics(customMetrics.getCustomMetrics());
                    }
                }
                catch (MetricsException | AppRegistryException e1) {
                    LOGGER.error((Object)"Error while adding custom metrics to metrics bean", e1);
                }
                if (requestData.getResponsePassThrough()) {
                    try {
                        ResponseUtils.addResponseHeadersToServletResponse((HttpServletResponse)response, (DataControllerResponse)dresponse);
                        ResponseUtils.copyBackendResponseToServletResponse((HttpServletResponse)response, (DataControllerResponse)dresponse);
                    }
                    catch (IllegalStateException e) {
                        LOGGER.error((Object)"Error while setting pass through response", (Throwable)e);
                    }
                } else {
                    if (StringUtils.isNotBlank((String)responseStr)) {
                        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"mw_response_context_data", (Object)responseStr);
                    }
                    if (response != null) {
                        List cookiesList = dresponse.getDeviceCookies();
                        if (cookiesList != null) {
                            for (Cookie apacheCookie : cookiesList) {
                                String cookieName = apacheCookie.getName();
                                if (cookieName == null || "cacheid".equals(cookieName) || "JSESSIONID".equals(cookieName)) continue;
                                javax.servlet.http.Cookie httpcookie = DataControllerImpl.servletCookieFromApacheCookie(apacheCookie);
                                response.addCookie(httpcookie);
                            }
                        }
                        ResponseUtils.addResponseHeaders((HttpServletRequest)request, (HttpServletResponse)response, (Map)dresponse.getDeviceHeaders());
                        HashMap statusHeaderMap = new HashMap();
                        statusHeaderMap.put("X-Kony-Service-Opstatus", dresponse.getHeaders().get("X-Kony-Service-Opstatus"));
                        statusHeaderMap.put("X-Kony-Service-Message", dresponse.getHeaders().get("X-Kony-Service-Message"));
                        String requestId = RequestUtils.getRequestId((HttpServletRequest)request);
                        requestId = requestId == null ? "" : requestId.replace('\r', ' ').replace('\n', ' ');
                        statusHeaderMap.put("X-Kony-RequestId", requestId);
                        String mfCode = (String)dresponse.getHeaders().get("X-Kony-MFCode");
                        if (StringUtils.isNotBlank((String)mfCode)) {
                            statusHeaderMap.put("X-Kony-MFCode", mfCode);
                        }
                        ResponseUtils.addResponseHeaders((HttpServletRequest)request, (HttpServletResponse)response, statusHeaderMap);
                    }
                }
                {
                    catch (Throwable throwable) {
                        KonyCustomMetrics customMetrics2 = (KonyCustomMetrics)drequest.getAttribute("customMetrics");
                        try {
                            if (customMetrics2 != null) {
                                drequest.getServicesManager().getKonyCustomMetrics().addCustomMetrics(customMetrics2.getCustomMetrics());
                            }
                        }
                        catch (MetricsException | AppRegistryException e1) {
                            LOGGER.error((Object)"Error while adding custom metrics to metrics bean", e1);
                        }
                        if (requestData.getResponsePassThrough()) {
                            try {
                                ResponseUtils.addResponseHeadersToServletResponse((HttpServletResponse)response, (DataControllerResponse)dresponse);
                                ResponseUtils.copyBackendResponseToServletResponse((HttpServletResponse)response, (DataControllerResponse)dresponse);
                            }
                            catch (IllegalStateException e) {
                                LOGGER.error((Object)"Error while setting pass through response", (Throwable)e);
                            }
                        } else {
                            if (StringUtils.isNotBlank((String)responseStr)) {
                                MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)request, (String)"mw_response_context_data", (Object)responseStr);
                            }
                            if (response != null) {
                                List cookiesList2 = dresponse.getDeviceCookies();
                                if (cookiesList2 != null) {
                                    for (Cookie apacheCookie : cookiesList2) {
                                        String cookieName = apacheCookie.getName();
                                        if (cookieName == null || "cacheid".equals(cookieName) || "JSESSIONID".equals(cookieName)) continue;
                                        javax.servlet.http.Cookie httpcookie = DataControllerImpl.servletCookieFromApacheCookie(apacheCookie);
                                        response.addCookie(httpcookie);
                                    }
                                }
                                ResponseUtils.addResponseHeaders((HttpServletRequest)request, (HttpServletResponse)response, (Map)dresponse.getDeviceHeaders());
                                HashMap statusHeaderMap2 = new HashMap();
                                statusHeaderMap2.put("X-Kony-Service-Opstatus", dresponse.getHeaders().get("X-Kony-Service-Opstatus"));
                                statusHeaderMap2.put("X-Kony-Service-Message", dresponse.getHeaders().get("X-Kony-Service-Message"));
                                String requestId2 = RequestUtils.getRequestId((HttpServletRequest)request);
                                requestId2 = requestId2 == null ? "" : requestId2.replace('\r', ' ').replace('\n', ' ');
                                statusHeaderMap2.put("X-Kony-RequestId", requestId2);
                                String mfCode3 = (String)dresponse.getHeaders().get("X-Kony-MFCode");
                                if (StringUtils.isNotBlank((String)mfCode3)) {
                                    statusHeaderMap2.put("X-Kony-MFCode", mfCode3);
                                }
                                ResponseUtils.addResponseHeaders((HttpServletRequest)request, (HttpServletResponse)response, statusHeaderMap2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        return responseStr;
    }

    private static InputStream getStream(HttpServletRequest request) {
        Object inputStream = null;
        try {
            inputStream = request instanceof KHttpServletRequestWrapper ? ((KHttpServletRequestWrapper)request).getStreamData() : request.getInputStream();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Unable to get the request stream", (Throwable)e);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePassThroughErrorResponse(HttpServletResponse response, DataControllerResponse dresponse, MiddlewareException me) {
        LOGGER.error((Object)"Error in passthru reponse phase ", (Throwable)me);
        if (dresponse.getAttribute("chunkedresults_json") == null) {
            String errorResponse = me.getMessage() == null ? me.toString() : me.getMessage();
            PrintWriter pw = null;
            try {
                pw = response.getWriter();
                pw.write(errorResponse);
                pw.flush();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error while setting passthru error reponse ", (Throwable)e);
            }
            finally {
                Closer.closeQuietly((Closeable)pw);
            }
        }
        if (me.getHttpStatusCode() != -1) {
            response.setStatus(me.getHttpStatusCode());
        }
    }

    public static String processHttpRequest(HttpServletRequest request, HttpServletResponse response) throws ControllerInitializationException {
        HashMap pathParams = (HashMap)RequestUtils.getAttribute((HttpServletRequest)request, (String)"frontend_path_params");
        return DataControllerImpl.processHttpRequest(request, response, pathParams);
    }

    public static String processHttpRequest(HttpServletRequest request, HashMap<String, String> additionalRequestParams) throws ControllerInitializationException {
        return DataControllerImpl.processHttpRequest(request, null, additionalRequestParams);
    }

    @Override
    public DataControllerResponse processDataRequest(DataControllerRequest request) throws ControllerInitializationException, ControllerException {
        DataControllerResponse response;
        Sequence seq = this.prepareSequence(request);
        try {
            response = seq.execute(request);
        }
        catch (SequenceException se) {
            MaskUtils.maskTrace((String)se.getMessage(), (Throwable)se);
            throw new ControllerException(se.getErrorCode(), se.getHttpStatusCode(), se.getMessage(), (Exception)((Object)se));
        }
        catch (SequenceInitializationException se) {
            MaskUtils.maskTrace((String)se.getMessage(), (Throwable)se);
            throw new ControllerInitializationException(se.getErrorCode(), se.getMessage());
        }
        this.processResponse(request, response);
        return response;
    }

    @Override
    public void processDataRequest(DataControllerRequest request, Context parentContext) {
        AsyncSequence seq;
        Context context = new Context();
        context.put("parentContext", (Object)parentContext);
        try {
            seq = (AsyncSequence)((Object)this.prepareSequence(request));
        }
        catch (ControllerException exception) {
            DataControllerResponseImpl response = new DataControllerResponseImpl();
            ((AsyncHandler)parentContext.get("handler")).onError(request, (DataControllerResponse)response, (MiddlewareException)((Object)exception), parentContext);
            return;
        }
        context.put("handler", (Object)CONTROLLER_IMPL_ASYNC_HANDLER);
        seq.execute(request, context);
    }

    private void processResponse(DataControllerRequest request, DataControllerResponse response) {
        LOGGER.debug((Object)"Following are parameters of controller response");
        if (response.getAttribute("chunkedresults_json") == null) {
            response.setAttribute("chunkedresults_json", request.getAttribute("chunkedresults_json"));
        }
    }

    private Sequence prepareSequence(DataControllerRequest request) throws ControllerException {
        if (!this.initialized) {
            throw new ControllerException("5000", "Controller not initialized. please call init method on Controller");
        }
        String appID = request.getParameter("appID");
        String serviceID = request.getParameter("serviceID");
        String channel = request.getParameter("channel");
        if (channel == null) {
            LOGGER.fatal((Object)"Mandatory request params channel is missing or null");
            throw new ControllerException("5001", "Mandatory request params channel is missing or null");
        }
        if (!(channel.equals("sms") || channel.equals("wap-ad") || channel.equals("rc-ad") || appID != null && serviceID != null)) {
            LOGGER.fatal((Object)"Mandatory request params such as appid, serviceid  may be missing or nulls");
            throw new ControllerException("5002", "Mandatory request params such as appid, serviceid may be missing or nulls");
        }
        Session session = request.getSession(false);
        LOGGER.debug((Object)"Using an already created session and purposely not creating one here.");
        boolean callService = true;
        if (session == null) {
            session = request.getSession(true);
            LOGGER.debug((Object)"Creating a new session in process data request.");
        } else if (LOGGER.isDebugEnabled()) {
            if (StringUtils.isNotBlank((String)((String)MemcacheProperties.CLUSTER.getFromConfig()))) {
                MaskUtils.logDebugWithMasking((String)"Reusing the existing session.", (String)"sessionid", (String)session.getId());
            }
            try {
                Enumeration en = session.getAttributeNames();
                StringBuffer buf = new StringBuffer(128);
                buf.append("Following are parameters of the session of controller request");
                while (en != null && en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (MaskUtils.getKeyList().contains(key)) {
                        if (session.getAttribute(key) instanceof String) {
                            buf.append(" " + key).append(" = ").append(MaskUtils.maskString((String[])new String[]{(String)session.getAttribute(key)}));
                            continue;
                        }
                        buf.append(" " + key).append(" = ").append(session.getAttribute(key));
                        continue;
                    }
                    buf.append(" " + key).append(" = ").append(session.getAttribute(key));
                }
                LOGGER.debug((Object)buf.toString());
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Error Caught.", (Throwable)ex);
            }
        }
        request.setAttribute("callService", (Object)callService);
        String sequenceName = this.getSequence(appID, channel);
        LOGGER.debug((Object)("Sequence choosen is " + sequenceName));
        return this.getSequence(sequenceName);
    }

    @Override
    public Processor getProcessor(String name) throws ControllerInitializationException {
        Processor pr = this.processors.get(name);
        if (pr != null) {
            return pr;
        }
        DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration pc = this.processorConfig.get(name);
        if (pc == null) {
            LOGGER.fatal((Object)("Error Code : MW5004  - Processor definition doesnt exist : " + name));
            throw new ControllerInitializationException("5004", "Processor definition doesnt exist.");
        }
        try {
            pr = (Processor)ReflectionUtils.newInstanceQuietly((ClassLoader)this.classLoader, (String)pc.getClass1());
            if (pr instanceof Observer) {
                DBConfigSubject.getInstance().registerObserver((Observer)pr);
            }
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)("Error Code : MW5005 - Problem in loading/creating the Processor class " + name), (Throwable)ex);
            throw new ControllerInitializationException("5005", "problem in loading/creating the Processor class.");
        }
        if (pr == null) {
            LOGGER.fatal((Object)("Error Code : MW5005 - Problem in loading/creating the Processor class " + name));
            throw new ControllerInitializationException("5005", "problem in loading/creating the Processor class.");
        }
        LOGGER.debug((Object)(name + " Processor is loaded "));
        Configuration cfg = this.getConfiguration(pc);
        try {
            pr.initConfig(name, cfg);
        }
        catch (ProcessorInitializationException pie) {
            MaskUtils.maskTrace((String)(" Problem in initializing the Processor " + name), (Throwable)pie);
            throw new ControllerInitializationException(pie.getErrorCode(), pie.getMessage());
        }
        LOGGER.debug((Object)(name + " Processor is initialized "));
        this.processors.put(name, pr);
        return pr;
    }

    @Override
    public DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration getProcessorConfiguration(String name) throws ControllerException {
        DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration pc = this.processorConfig.get(name);
        if (pc == null) {
            LOGGER.fatal((Object)("Processor doesnt exist : " + name));
            throw new ControllerException("5004", "Processor doesnt exist");
        }
        return pc;
    }

    private Configuration getConfiguration(DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration pc) {
        DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration.Config cfg = pc.getConfig();
        if (cfg != null) {
            DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration.Config.Attr[] attr = cfg.getAttrArray();
            HashMap<String, Attribute> attrs = new HashMap<String, Attribute>();
            for (int i = 0; attr != null && i < attr.length; ++i) {
                attrs.put(attr[i].getName(), new Attribute(attr[i].getName(), attr[i].getType(), (Object)attr[i].getValue()));
            }
            return new ConfigurationImpl(attrs);
        }
        return null;
    }

    @Override
    public Sequence getSequence(String name) throws ControllerException {
        Sequence seq = this.sequences.get(name);
        if (seq != null) {
            return seq;
        }
        DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration sc = this.sequenceConfig.get(name);
        if (sc == null) {
            LOGGER.fatal((Object)("Error Code: MW5101 Sequence definition doesnt exist: " + name));
            throw new ControllerException("5101", "Sequence definition doesnt exist.");
        }
        try {
            seq = (Sequence)ReflectionUtils.newInstanceQuietly((ClassLoader)this.classLoader, (String)sc.getClass1());
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)("Error Code: MW5102 Problem in loading/creating the Sequence class -" + name), (Throwable)ex);
            throw new ControllerException("5102", "problem in loading/creating the Sequence class.");
        }
        if (seq == null) {
            LOGGER.fatal((Object)("Error Code: MW5102 Problem in loading/creating the Sequence class -" + name));
            throw new ControllerException("5102", "problem in loading/creating the Sequence class.");
        }
        LOGGER.debug((Object)(name + " Sequence is loaded "));
        try {
            seq.initConfig(sc, this);
        }
        catch (SequenceInitializationException sie) {
            MaskUtils.maskTrace((String)(" Problem in initializing the Sequence " + name), (Throwable)sie);
            throw new ControllerException(sie.getErrorCode(), sie.getMessage());
        }
        LOGGER.debug((Object)(name + " Sequence is initialized "));
        this.sequences.put(name, seq);
        return seq;
    }

    public HashMap<String, DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration> getProcessorConfig() {
        return this.processorConfig;
    }

    public HashMap<String, DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration> getSequenceConfig() {
        return this.sequenceConfig;
    }

    public HashMap<String, String> getAppConfig() {
        return this.appConfig;
    }

    public HashMap<String, String> getChannelConfig() {
        return this.channelConfig;
    }

    public static javax.servlet.http.Cookie servletCookieFromApacheCookie(Cookie apacheCookie) {
        if (apacheCookie == null) {
            return null;
        }
        String name = apacheCookie.getName();
        String value = apacheCookie.getValue();
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(name, value);
        value = apacheCookie.getDomain();
        if (value != null) {
            cookie.setDomain(value);
        }
        if ((value = apacheCookie.getPath()) != null) {
            cookie.setPath(value);
        }
        cookie.setSecure(apacheCookie.isSecure());
        value = apacheCookie.getComment();
        if (value != null) {
            cookie.setComment(value);
        }
        cookie.setVersion(apacheCookie.getVersion());
        Date expiryDate = apacheCookie.getExpiryDate();
        if (expiryDate != null) {
            long maxAge = (expiryDate.getTime() - System.currentTimeMillis()) / 1000L;
            cookie.setMaxAge((int)maxAge);
        }
        return cookie;
    }
}

