/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.controller.impl;

import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.controller.AsyncHandler;
import com.konylabs.middleware.controller.AsyncHandlersChain;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.exceptions.ControllerException;
import com.konylabs.middleware.exceptions.ControllerInitializationException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.SequenceException;
import com.konylabs.middleware.exceptions.SequenceInitializationException;
import com.konylabs.middleware.utilities.MaskUtils;

public class DataControllerImplAsyncHandler
implements AsyncHandler,
AsyncHandlersChain {
    protected DataControllerImplAsyncHandler() {
    }

    @Override
    public void onSuccess(DataControllerRequest request, DataControllerResponse response, Context context) {
        this.processResponse(request, response);
        Context parentContext = (Context)context.get("parentContext");
        AsyncHandler parentAsyncHandler = this.getParentHandler(parentContext);
        parentAsyncHandler.onSuccess(request, response, parentContext);
    }

    @Override
    public void onError(DataControllerRequest request, DataControllerResponse response, MiddlewareException exception, Context context) {
        Context parentContext = (Context)context.get("parentContext");
        AsyncHandler parentAsyncHandler = this.getParentHandler(parentContext);
        if (exception instanceof SequenceException) {
            MaskUtils.maskTrace((String)exception.getMessage(), (Throwable)exception);
            parentAsyncHandler.onError(request, response, (MiddlewareException)((Object)new ControllerException(exception.getErrorCode(), exception.getHttpStatusCode(), exception.getMessage(), (Exception)((Object)exception))), parentContext);
        } else if (exception instanceof SequenceInitializationException) {
            MaskUtils.maskTrace((String)exception.getMessage(), (Throwable)exception);
            parentAsyncHandler.onError(request, response, (MiddlewareException)((Object)new ControllerInitializationException(exception.getErrorCode(), exception.getMessage())), parentContext);
        } else {
            parentAsyncHandler.onError(request, response, exception, parentContext);
        }
    }

    @Override
    public AsyncHandler getParentHandler(Context parentContext) {
        return (AsyncHandler)parentContext.get("handler");
    }

    private void processResponse(DataControllerRequest request, DataControllerResponse response) {
        if (response.getAttribute("chunkedresults_json") == null) {
            response.setAttribute("chunkedresults_json", request.getAttribute("chunkedresults_json"));
        }
    }
}

