/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.controller.impl;

import com.konylabs.middleware.common.KHttpServletRequestWrapper;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.impl.AbstractDataControllerRequestImpl;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.session.impl.HttpSessionImpl;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;

public class DataControllerRequestHttpImpl
extends AbstractDataControllerRequestImpl {
    private final HttpServletRequest request;
    private final Map<String, Object> attributesMap = new HashMap<String, Object>(0);
    private final Map<String, String> headersMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, String> additionalParams = new HashMap<String, String>(0);

    public DataControllerRequestHttpImpl(HttpServletRequest request, Map<String, String> requestParams) {
        this.request = request;
        if (requestParams != null) {
            this.additionalParams.putAll(requestParams);
        }
        this.extractHeaders(this.additionalParams != null ? this.additionalParams.get("httpheaders") : null);
        this.headersMap.putAll(this.consumeHeadersFromCustomProcessor(request));
        this.extractCookiesAndConvertToApacheCookies(request.getCookies());
    }

    public void updateOriginalRequest(Map<String, Object> map) {
    }

    public String getParameter(String name) {
        String paramValue = this.additionalParams != null ? this.additionalParams.get(name) : null;
        return paramValue == null ? this.request.getParameter(name) : paramValue;
    }

    public String[] getParameterValues(String name) {
        String[] stringArray;
        String paramValue;
        String string = paramValue = this.additionalParams != null ? this.additionalParams.get(name) : null;
        if (paramValue == null) {
            stringArray = this.request.getParameterValues(name);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = paramValue;
        }
        return stringArray;
    }

    public Iterator<String> getParameterNames() {
        HashSet<Object> paramNames = new HashSet<Object>();
        Map map = this.request.getParameterMap();
        if (map != null) {
            paramNames.addAll(map.keySet());
        }
        if (this.additionalParams != null) {
            paramNames.addAll(this.additionalParams.keySet());
        }
        return paramNames.iterator();
    }

    public File getUploadedFile(String name) {
        if (name == null) {
            return null;
        }
        if (this.request instanceof KHttpServletRequestWrapper) {
            KHttpServletRequestWrapper krequest = (KHttpServletRequestWrapper)this.request;
            List<File> files = krequest.getUploadedFiles();
            for (File file : files) {
                if (!name.equals(file.getName())) continue;
                return file;
            }
        }
        return null;
    }

    public String[] getUploadedFileNames() {
        if (this.request instanceof KHttpServletRequestWrapper) {
            KHttpServletRequestWrapper krequest = (KHttpServletRequestWrapper)this.request;
            List<File> files = krequest.getUploadedFiles();
            String[] fileNames = new String[files.size()];
            int i = 0;
            for (File file : files) {
                fileNames[i++] = file.getName();
            }
            return fileNames;
        }
        return null;
    }

    public File[] getUploadedFiles() {
        if (this.request instanceof KHttpServletRequestWrapper) {
            KHttpServletRequestWrapper krequest = (KHttpServletRequestWrapper)this.request;
            List<File> files = krequest.getUploadedFiles();
            return files.toArray(new File[files.size()]);
        }
        return null;
    }

    public Object getAttribute(String name) {
        return this.attributesMap.get(name);
    }

    public void setAttribute(String name, Object val) {
        this.attributesMap.put(name, val);
    }

    public Iterator<String> getAttributeNames() {
        return this.attributesMap.keySet().iterator();
    }

    public Map<String, String[]> getSource() {
        return this.request.getParameterMap();
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public Session getSession(boolean flag) {
        HttpSession session = this.request.getSession(flag);
        return session != null ? new HttpSessionImpl(session) : null;
    }

    public boolean containsKeyInRequestContext(String key) {
        return this.attributesMap.containsKey(key);
    }

    public boolean containsKeyInRequest(String key) {
        return this.getParameter(key) != null;
    }

    public void setSession(Session session) {
        throw new RuntimeException("Not Required for HTTP Request");
    }

    public Object getOriginalRequest() {
        return this.request;
    }

    public String getHeader(String headerKey) {
        return this.headersMap.containsKey(headerKey) ? this.headersMap.get(headerKey) : this.request.getHeader(headerKey);
    }

    public void addRequestParam_(String key, String value) {
        if (this.additionalParams == null) {
            this.additionalParams = new HashMap<String, String>();
        }
        this.additionalParams.put(key, value);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    @Override
    public DataControllerRequest clone() {
        super.clone();
        DataControllerRequestHttpImpl newRequest = new DataControllerRequestHttpImpl(this.request, null);
        newRequest.additionalParams.putAll(this.additionalParams);
        newRequest.attributesMap.putAll(this.attributesMap);
        newRequest.cookies.putAll(this.cookies);
        return newRequest;
    }

    public Map<String, Object> getHeaderMap() {
        HashMap<String, Object> reqHeaderMap = new HashMap<String, Object>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            reqHeaderMap.put(key, this.request.getHeader(key));
        }
        return reqHeaderMap;
    }

    private Map<String, String> extractHeaders(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            value = value.substring(1, value.length() - 1);
            String[] pairs = value.split(",");
            for (int i = 0; i < pairs.length; ++i) {
                String pair = pairs[i];
                if (!StringUtils.isNotBlank((String)(pair = pair.trim()))) continue;
                String[] keyValue = pair.split("=");
                this.headersMap.put(keyValue[0].trim(), keyValue[1].trim());
            }
        }
        return this.headersMap;
    }
}

